/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.joor;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.StaticService;
import org.apache.camel.language.joor.JoorCompiler;
import org.apache.camel.language.joor.JoorExpression;
import org.apache.camel.spi.annotations.Language;
import org.apache.camel.support.ExpressionToPredicateAdapter;
import org.apache.camel.support.LanguageSupport;
import org.apache.camel.support.ScriptHelper;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Language(value="joor")
public class JoorLanguage
extends LanguageSupport
implements StaticService {
    private static final Logger LOG = LoggerFactory.getLogger(JoorLanguage.class);
    private static Boolean java8;
    private final JoorCompiler compiler = new JoorCompiler();
    private final Set<String> imports = new TreeSet<String>();
    private final Map<String, String> aliases = new HashMap<String, String>();
    private String configResource = "classpath:camel-joor.properties?optional=true";
    private boolean preCompile = true;
    private Class<?> resultType;
    private boolean singleQuotes = true;

    public String getConfigResource() {
        return this.configResource;
    }

    public void setConfigResource(String configResource) {
        this.configResource = configResource;
        this.loadConfiguration();
    }

    public boolean isPreCompile() {
        return this.preCompile;
    }

    public void setPreCompile(boolean preCompile) {
        this.preCompile = preCompile;
    }

    public Class<?> getResultType() {
        return this.resultType;
    }

    public void setResultType(Class<?> resultType) {
        this.resultType = resultType;
    }

    public boolean isSingleQuotes() {
        return this.singleQuotes;
    }

    public void setSingleQuotes(boolean singleQuotes) {
        this.singleQuotes = singleQuotes;
    }

    @Override
    public Predicate createPredicate(String expression) {
        return ExpressionToPredicateAdapter.toPredicate(this.createExpression(expression));
    }

    @Override
    public Expression createExpression(String expression) {
        JoorExpression exp = new JoorExpression(expression);
        exp.setCompiler(this.compiler);
        exp.setResultType(this.resultType);
        exp.setSingleQuotes(this.singleQuotes);
        exp.init(this.getCamelContext());
        return exp;
    }

    @Override
    public Predicate createPredicate(String expression, Object[] properties) {
        return (JoorExpression)this.createExpression(expression, properties);
    }

    @Override
    public Expression createExpression(String expression, Object[] properties) {
        JoorExpression exp = new JoorExpression(expression);
        exp.setCompiler(this.compiler);
        exp.setPreCompile(this.property(Boolean.TYPE, properties, 0, this.preCompile));
        exp.setResultType(this.property(Class.class, properties, 1, this.resultType));
        exp.setSingleQuotes(this.property(Boolean.TYPE, properties, 2, this.singleQuotes));
        exp.init(this.getCamelContext());
        return exp;
    }

    @Override
    public void init() {
        if (java8 == null && (java8 = Boolean.valueOf(JoorLanguage.getJavaMajorVersion() == 8)).booleanValue()) {
            throw new UnsupportedOperationException("Java 8 is not supported. Use Java 11 or higher");
        }
        this.loadConfiguration();
    }

    @Override
    public void start() {
        ServiceHelper.startService((Object)this.compiler);
    }

    @Override
    public void stop() {
        ServiceHelper.stopService((Object)this.compiler);
    }

    private void loadConfiguration() {
        String loaded = ScriptHelper.resolveOptionalExternalScript(this.getCamelContext(), "resource:" + this.configResource);
        int counter1 = 0;
        int counter2 = 0;
        if (loaded != null) {
            String[] lines;
            for (String line : lines = loaded.split("\n")) {
                if ((line = line.trim()).startsWith("#")) continue;
                if (line.startsWith("import ")) {
                    this.imports.add(line);
                    ++counter1;
                    continue;
                }
                String key = StringHelper.before(line, "=");
                String value = StringHelper.after(line, "=");
                if (key != null) {
                    key = key.trim();
                }
                if (value != null) {
                    value = value.trim();
                }
                if (key == null || value == null) continue;
                this.aliases.put(key, value);
                ++counter2;
            }
        }
        if (counter1 > 0 || counter2 > 0) {
            LOG.info("Loaded jOOR language imports: {} and aliases: {} from configuration: {}", new Object[]{counter1, counter2, this.configResource});
        }
        if (this.compiler.getAliases() == null) {
            this.compiler.setAliases(this.aliases);
        } else {
            this.compiler.getAliases().putAll(this.aliases);
        }
        if (this.compiler.getImports() == null) {
            this.compiler.setImports(this.imports);
        } else {
            this.compiler.getImports().addAll(this.imports);
        }
    }

    private static int getJavaMajorVersion() {
        String javaSpecVersion = System.getProperty("java.specification.version");
        return javaSpecVersion.contains(".") ? Integer.parseInt(javaSpecVersion.split("\\.")[1]) : Integer.parseInt(javaSpecVersion);
    }
}

