/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jsch;

import java.net.URI;
import org.apache.camel.component.file.remote.RemoteFileConfiguration;

public class ScpConfiguration
extends RemoteFileConfiguration {
    public static final int DEFAULT_SFTP_PORT = 22;
    public static final String DEFAULT_MOD = "664";
    private String knownHostsFile;
    private String privateKeyFile;
    private String privateKeyFilePassphrase;
    private String strictHostKeyChecking;
    private int serverAliveInterval;
    private int serverAliveCountMax = 1;
    private String chmod = "664";
    private String ciphers;
    private int compression;

    public ScpConfiguration() {
        this.setProtocol("sftp");
    }

    public ScpConfiguration(URI uri) {
        super(uri);
    }

    @Override
    protected void setDefaultPort() {
        this.setPort(22);
    }

    public String getKnownHostsFile() {
        return this.knownHostsFile;
    }

    public void setKnownHostsFile(String knownHostsFile) {
        this.knownHostsFile = knownHostsFile;
    }

    public String getPrivateKeyFile() {
        return this.privateKeyFile;
    }

    public void setPrivateKeyFile(String privateKeyFile) {
        this.privateKeyFile = privateKeyFile;
    }

    public String getPrivateKeyFilePassphrase() {
        return this.privateKeyFilePassphrase;
    }

    public void setPrivateKeyFilePassphrase(String privateKeyFilePassphrase) {
        this.privateKeyFilePassphrase = privateKeyFilePassphrase;
    }

    public String getStrictHostKeyChecking() {
        return this.strictHostKeyChecking;
    }

    public void setStrictHostKeyChecking(String strictHostKeyChecking) {
        this.strictHostKeyChecking = strictHostKeyChecking;
    }

    public void setServerAliveInterval(int serverAliveInterval) {
        this.serverAliveInterval = serverAliveInterval;
    }

    public int getServerAliveInterval() {
        return this.serverAliveInterval;
    }

    public void setServerAliveCountMax(int serverAliveCountMax) {
        this.serverAliveCountMax = serverAliveCountMax;
    }

    public int getServerAliveCountMax() {
        return this.serverAliveCountMax;
    }

    public void setChmod(String chmod) {
        if (chmod.length() == 3) {
            for (byte c : chmod.getBytes()) {
                if (c >= 48 && c <= 55) continue;
                chmod = DEFAULT_MOD;
                break;
            }
        } else {
            chmod = DEFAULT_MOD;
        }
        this.chmod = chmod;
    }

    public String getChmod() {
        return this.chmod;
    }

    public void setCiphers(String ciphers) {
        this.ciphers = ciphers;
    }

    public String getCiphers() {
        return this.ciphers;
    }

    public int getCompression() {
        return this.compression;
    }

    public void setCompression(int compression) {
        this.compression = compression;
    }
}

