/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.remote;

import com.jcraft.jsch.Identity;
import com.jcraft.jsch.JSchException;
import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPublicKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DSAKeyPairIdentity
implements Identity {
    private static final String ALGORITHM_TYPE = "ssh-dss";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private KeyPair keyPair;
    private String name;

    public DSAKeyPairIdentity(String name, KeyPair keyPair) {
        this.name = name;
        this.keyPair = keyPair;
    }

    @Override
    public boolean setPassphrase(byte[] passphrase) throws JSchException {
        return true;
    }

    @Override
    public byte[] getPublicKeyBlob() {
        DSAPublicKey publicKey = (DSAPublicKey)this.keyPair.getPublic();
        byte[] sshDss = ALGORITHM_TYPE.getBytes();
        DSAParams dsaParams = publicKey.getParams();
        byte[] pArray = dsaParams.getP().toByteArray();
        byte[] qArray = dsaParams.getQ().toByteArray();
        byte[] gArray = dsaParams.getG().toByteArray();
        byte[] yArray = publicKey.getY().toByteArray();
        byte[] result = new byte[sshDss.length + 4 + pArray.length + 4 + qArray.length + 4 + gArray.length + 4 + yArray.length + 4];
        int index = 0;
        byte[] intAsByteArray = ByteBuffer.allocate(4).putInt(sshDss.length).array();
        System.arraycopy(intAsByteArray, 0, result, index, 4);
        System.arraycopy(sshDss, 0, result, index += 4, sshDss.length);
        intAsByteArray = ByteBuffer.allocate(4).putInt(pArray.length).array();
        System.arraycopy(intAsByteArray, 0, result, index += sshDss.length, 4);
        System.arraycopy(pArray, 0, result, index += 4, pArray.length);
        intAsByteArray = ByteBuffer.allocate(4).putInt(qArray.length).array();
        System.arraycopy(intAsByteArray, 0, result, index += pArray.length, 4);
        System.arraycopy(qArray, 0, result, index += 4, qArray.length);
        intAsByteArray = ByteBuffer.allocate(4).putInt(gArray.length).array();
        System.arraycopy(intAsByteArray, 0, result, index += qArray.length, 4);
        System.arraycopy(gArray, 0, result, index += 4, gArray.length);
        intAsByteArray = ByteBuffer.allocate(4).putInt(yArray.length).array();
        System.arraycopy(intAsByteArray, 0, result, index += gArray.length, 4);
        System.arraycopy(yArray, 0, result, index += 4, yArray.length);
        return result;
    }

    @Override
    public byte[] getSignature(byte[] data) {
        try {
            PrivateKey prvKey = this.keyPair.getPrivate();
            Signature sig = Signature.getInstance("SHA1withDSA");
            sig.initSign(prvKey);
            sig.update(data);
            byte[] sshDss = ALGORITHM_TYPE.getBytes();
            byte[] signature = sig.sign();
            signature = this.convertDERToP1363(signature);
            byte[] result = new byte[sshDss.length + 4 + signature.length + 4];
            int index = 0;
            byte[] intAsByteArray = ByteBuffer.allocate(4).putInt(sshDss.length).array();
            System.arraycopy(intAsByteArray, 0, result, index, 4);
            System.arraycopy(sshDss, 0, result, index += 4, sshDss.length);
            intAsByteArray = ByteBuffer.allocate(4).putInt(signature.length).array();
            System.arraycopy(intAsByteArray, 0, result, index += sshDss.length, 4);
            System.arraycopy(signature, 0, result, index += 4, signature.length);
            return result;
        }
        catch (NoSuchAlgorithmException e) {
            this.log.error("Cannot sign", (Throwable)e);
        }
        catch (InvalidKeyException e) {
            this.log.error("Cannot sign", (Throwable)e);
        }
        catch (SignatureException e) {
            this.log.error("Cannot sign", (Throwable)e);
        }
        return null;
    }

    private byte[] convertDERToP1363(byte[] sig) {
        int off;
        int index = 3;
        int len = sig[index++] & 0xFF;
        byte[] r = new byte[len];
        System.arraycopy(sig, index, r, 0, r.length);
        index = index + len + 1;
        len = sig[index++] & 0xFF;
        byte[] s = new byte[len];
        System.arraycopy(sig, index, s, 0, s.length);
        byte[] p1363Signature = new byte[40];
        if (r.length <= 21 && (r.length != 21 || r[0] == 0)) {
            if (r.length == 21) {
                System.arraycopy(r, 1, p1363Signature, 0, 20);
            } else if (r.length == 20) {
                System.arraycopy(r, 0, p1363Signature, 0, 20);
            } else {
                len = r.length;
                off = 20 - len;
                System.arraycopy(r, 0, p1363Signature, off, len);
            }
        }
        if (s.length > 21 || s.length == 21 && s[0] != 0) {
            p1363Signature = new byte[]{};
        } else if (s.length == 21) {
            System.arraycopy(s, 1, p1363Signature, 20, 20);
        } else if (s.length == 20) {
            System.arraycopy(s, 0, p1363Signature, 20, 20);
        } else {
            len = s.length;
            off = 40 - len;
            System.arraycopy(s, 0, p1363Signature, off, len);
        }
        return p1363Signature;
    }

    @Override
    public boolean decrypt() {
        return true;
    }

    @Override
    public String getAlgName() {
        return ALGORITHM_TYPE;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isEncrypted() {
        return false;
    }

    @Override
    public void clear() {
    }
}

