/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.scp;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Logger;
import java.net.URI;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.component.file.GenericFileEndpoint;
import org.apache.camel.component.file.remote.RemoteFileComponent;
import org.apache.camel.component.scp.ScpConfiguration;
import org.apache.camel.component.scp.ScpEndpoint;
import org.apache.camel.component.scp.ScpFile;
import org.slf4j.LoggerFactory;

public class ScpComponent
extends RemoteFileComponent<ScpFile> {
    private static final org.slf4j.Logger LOG = LoggerFactory.getLogger(ScpComponent.class);
    private boolean verboseLogging;

    public ScpComponent() {
    }

    public ScpComponent(CamelContext context) {
        super(context);
    }

    protected GenericFileEndpoint<ScpFile> buildFileEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        int query = uri.indexOf("?");
        return new ScpEndpoint(uri, this, new ScpConfiguration(new URI(query >= 0 ? uri.substring(0, query) : uri)));
    }

    protected void afterPropertiesSet(GenericFileEndpoint<ScpFile> endpoint) throws Exception {
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.initJsch();
    }

    protected void doStop() throws Exception {
        super.doStop();
    }

    public boolean isVerboseLogging() {
        return this.verboseLogging;
    }

    public void setVerboseLogging(boolean verboseLogging) {
        this.verboseLogging = verboseLogging;
    }

    protected void initJsch() {
        JSch.setConfig("StrictHostKeyChecking", "yes");
        JSch.setLogger(new Logger(){

            @Override
            public boolean isEnabled(int level) {
                return level == 4 || level == 3 ? LOG.isErrorEnabled() : (level == 2 ? LOG.isWarnEnabled() : (level == 1 ? LOG.isInfoEnabled() : LOG.isDebugEnabled()));
            }

            @Override
            public void log(int level, String message) {
                if (level == 4 || level == 3) {
                    LOG.error("[JSCH] {}", (Object)message);
                } else if (level == 2) {
                    LOG.warn("[JSCH] {}", (Object)message);
                } else if (level == 1) {
                    if (ScpComponent.this.isVerboseLogging()) {
                        LOG.info("[JSCH] {}", (Object)message);
                    } else {
                        LOG.debug("[JSCH] {}", (Object)message);
                    }
                } else {
                    LOG.debug("[JSCH] {}", (Object)message);
                }
            }
        });
    }
}

