/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.remote;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.file.GenericFileEndpoint;
import org.apache.camel.component.file.GenericFileOperationFailedException;
import org.apache.camel.component.file.GenericFileProcessStrategy;
import org.apache.camel.component.file.remote.FtpClientActivityListener;
import org.apache.camel.component.file.remote.FtpConfiguration;
import org.apache.camel.component.file.remote.FtpOperations;
import org.apache.camel.component.file.remote.FtpUtils;
import org.apache.camel.component.file.remote.RemoteFile;
import org.apache.camel.component.file.remote.RemoteFileConfiguration;
import org.apache.camel.component.file.remote.RemoteFileConsumer;
import org.apache.camel.component.file.remote.RemoteFileEndpoint;
import org.apache.camel.component.file.remote.RemoteFileOperations;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StopWatch;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.TimeUtils;
import org.apache.camel.util.URISupport;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedResource(description="Managed FtpConsumer")
public class FtpConsumer
extends RemoteFileConsumer<FTPFile> {
    private static final Logger LOG = LoggerFactory.getLogger(FtpConsumer.class);
    protected String endpointPath;
    private transient String ftpConsumerToString;

    public FtpConsumer(RemoteFileEndpoint<FTPFile> endpoint, Processor processor, RemoteFileOperations<FTPFile> fileOperations, GenericFileProcessStrategy processStrategy) {
        super(endpoint, processor, fileOperations, processStrategy);
        this.endpointPath = endpoint.getConfiguration().getDirectory();
    }

    protected FtpOperations getOperations() {
        return (FtpOperations)super.getOperations();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doStart() throws Exception {
        boolean startScheduler = this.isStartScheduler();
        this.setStartScheduler(false);
        try {
            super.doStart();
            if (this.endpoint.isAutoCreate() && this.hasStartingDirectory()) {
                String dir = this.endpoint.getConfiguration().getDirectory();
                LOG.debug("Auto creating directory: {}", (Object)dir);
                try {
                    this.connectIfNecessary();
                    this.operations.buildDirectory(dir, true);
                }
                catch (GenericFileOperationFailedException e) {
                    LOG.warn("Error auto creating directory: " + dir + " due " + e.getMessage() + ". This exception is ignored.", (Throwable)e);
                }
            }
        }
        finally {
            if (startScheduler) {
                this.setStartScheduler(true);
                this.startScheduler();
            }
        }
    }

    @Override
    protected boolean pollDirectory(String fileName, List<GenericFile<FTPFile>> fileList, int depth) {
        String currentDir = null;
        if (this.isStepwise()) {
            currentDir = this.operations.getCurrentDirectory();
        }
        fileName = FileUtil.stripTrailingSeparator(fileName);
        boolean answer = this.doPollDirectory(fileName, (String)null, fileList, depth);
        if (currentDir != null) {
            this.operations.changeCurrentDirectory(currentDir);
        }
        return answer;
    }

    protected boolean pollSubDirectory(String absolutePath, String dirName, List<GenericFile<FTPFile>> fileList, int depth) {
        boolean answer = this.doSafePollSubDirectory(absolutePath, dirName, fileList, depth);
        if (this.isStepwise()) {
            this.operations.changeToParentDirectory();
        }
        return answer;
    }

    @Override
    protected boolean doPollDirectory(String absolutePath, String dirName, List<GenericFile<FTPFile>> fileList, int depth) {
        LOG.trace("doPollDirectory from absolutePath: {}, dirName: {}", (Object)absolutePath, (Object)dirName);
        ++depth;
        dirName = FileUtil.stripTrailingSeparator(dirName);
        String dir = null;
        List files = null;
        try {
            if (this.isStepwise()) {
                dir = ObjectHelper.isNotEmpty(dirName) ? dirName : absolutePath;
                this.operations.changeCurrentDirectory(dir);
            } else {
                dir = absolutePath;
            }
            LOG.trace("Polling directory: {}", (Object)dir);
            if (this.isUseList()) {
                files = this.isStepwise() ? this.operations.listFiles() : this.operations.listFiles(dir);
            } else {
                Exchange dummy = this.endpoint.createExchange();
                String name = this.evaluateFileExpression(dummy);
                if (name != null) {
                    FTPFile file = new FTPFile();
                    file.setType(0);
                    file.setName(name);
                    files = new ArrayList(1);
                    files.add(file);
                }
            }
        }
        catch (GenericFileOperationFailedException e) {
            if (this.ignoreCannotRetrieveFile(null, null, e)) {
                LOG.debug("Cannot list files in directory {} due directory does not exists or file permission error.", (Object)dir);
            }
            throw e;
        }
        if (files == null || files.isEmpty()) {
            LOG.trace("No files found in directory: {}", (Object)dir);
            return true;
        }
        LOG.trace("Found {} in directory: {}", (Object)files.size(), (Object)dir);
        if (((GenericFileEndpoint)this.getEndpoint()).isPreSort()) {
            Collections.sort(files, (a, b) -> a.getName().compareTo(b.getName()));
        }
        for (FTPFile file : files) {
            RemoteFile<FTPFile> remote;
            if (LOG.isTraceEnabled()) {
                LOG.trace("FtpFile[name={}, dir={}, file={}]", new Object[]{file.getName(), file.isDirectory(), file.isFile()});
            }
            if (!this.canPollMoreFiles(fileList)) {
                return false;
            }
            if (file.isDirectory()) {
                remote = this.asRemoteFile(absolutePath, file, ((GenericFileEndpoint)this.getEndpoint()).getCharset());
                if (!this.endpoint.isRecursive() || depth >= this.endpoint.getMaxDepth() || !this.isValidFile(remote, true, files)) continue;
                String subDirectory = file.getName();
                String path = ObjectHelper.isNotEmpty(absolutePath) ? absolutePath + "/" + subDirectory : subDirectory;
                boolean canPollMore = this.pollSubDirectory(path, subDirectory, fileList, depth);
                if (canPollMore) continue;
                return false;
            }
            if (file.isFile()) {
                remote = this.asRemoteFile(absolutePath, file, ((GenericFileEndpoint)this.getEndpoint()).getCharset());
                if (depth < this.endpoint.getMinDepth() || !this.isValidFile(remote, false, files)) continue;
                fileList.add(remote);
                continue;
            }
            LOG.debug("Ignoring unsupported remote file type: {}", (Object)file);
        }
        return true;
    }

    @Override
    protected boolean isMatched(GenericFile<FTPFile> file, String doneFileName, List<FTPFile> files) {
        String onlyName = FileUtil.stripPath(doneFileName);
        for (FTPFile f : files) {
            if (!f.getName().equals(onlyName)) continue;
            return true;
        }
        LOG.trace("Done file: {} does not exist", (Object)doneFileName);
        return false;
    }

    @Override
    protected boolean ignoreCannotRetrieveFile(String name, Exchange exchange, Exception cause) {
        if (((RemoteFileEndpoint)this.getEndpoint()).getConfiguration().isIgnoreFileNotFoundOrPermissionError()) {
            GenericFileOperationFailedException generic;
            int code;
            if (exchange != null && (code = exchange.getIn().getHeader("CamelFtpReplyCode", 0, Integer.TYPE).intValue()) == 550) {
                return true;
            }
            if (cause instanceof GenericFileOperationFailedException && (generic = ObjectHelper.getException(GenericFileOperationFailedException.class, cause)).getCode() == 550) {
                return true;
            }
        }
        return super.ignoreCannotRetrieveFile(name, exchange, cause);
    }

    private RemoteFile<FTPFile> asRemoteFile(String absolutePath, FTPFile file, String charset) {
        RemoteFile<FTPFile> answer = new RemoteFile<FTPFile>();
        answer.setCharset(charset);
        answer.setEndpointPath(this.endpointPath);
        answer.setFile(file);
        answer.setFileNameOnly(file.getName());
        answer.setFileLength(file.getSize());
        answer.setDirectory(file.isDirectory());
        if (file.getTimestamp() != null) {
            answer.setLastModified(file.getTimestamp().getTimeInMillis());
        }
        answer.setHostname(((RemoteFileConfiguration)this.endpoint.getConfiguration()).getHost());
        boolean absolute = FileUtil.hasLeadingSeparator(absolutePath);
        answer.setAbsolute(absolute);
        String dir = FileUtil.stripTrailingSeparator(absolutePath);
        String fileName = file.getName();
        if (((FtpConfiguration)this.endpoint.getConfiguration()).isHandleDirectoryParserAbsoluteResult()) {
            fileName = FtpUtils.extractDirNameFromAbsolutePath(file.getName());
        }
        String absoluteFileName = FileUtil.stripLeadingSeparator(dir + "/" + fileName);
        if (absolute) {
            absoluteFileName = "/" + absoluteFileName;
        }
        answer.setAbsoluteFilePath(absoluteFileName);
        String relativePath = StringHelper.after(absoluteFileName, this.endpointPath);
        relativePath = FileUtil.stripLeadingSeparator(relativePath);
        answer.setRelativeFilePath(relativePath);
        answer.setFileName(answer.getRelativeFilePath());
        return answer;
    }

    @Override
    protected void updateFileHeaders(GenericFile<FTPFile> file, Message message) {
        long length = file.getFile().getSize();
        long modified = file.getFile().getTimestamp() != null ? file.getFile().getTimestamp().getTimeInMillis() : -1L;
        file.setFileLength(length);
        file.setLastModified(modified);
        if (length >= 0L) {
            message.setHeader("CamelFileLength", length);
        }
        if (modified >= 0L) {
            message.setHeader("CamelFileLastModified", modified);
        }
    }

    private boolean isStepwise() {
        RemoteFileConfiguration config = (RemoteFileConfiguration)this.endpoint.getConfiguration();
        return config.isStepwise();
    }

    private boolean isUseList() {
        RemoteFileConfiguration config = (RemoteFileConfiguration)this.endpoint.getConfiguration();
        return config.isUseList();
    }

    @ManagedAttribute(description="Summary of last FTP activity (download only)")
    public String getLastFtpActivity() {
        String log;
        FTPClient client = this.getOperations().getFtpClient();
        FtpClientActivityListener listener = (FtpClientActivityListener)client.getCopyStreamListener();
        if (listener != null && (log = listener.getLastLogActivity()) != null) {
            long since = listener.getLastLogActivityTimestamp();
            if (since > 0L) {
                StopWatch watch = new StopWatch(new Date(since));
                long delta = watch.taken();
                String human = TimeUtils.printDuration(delta);
                return log + " " + human + " ago";
            }
            return log;
        }
        return null;
    }

    @ManagedAttribute(description="Summary of last FTP activity (all)")
    public String getLastFtpActivityVerbose() {
        String log;
        FTPClient client = this.getOperations().getFtpClient();
        FtpClientActivityListener listener = (FtpClientActivityListener)client.getCopyStreamListener();
        if (listener != null && (log = listener.getLastVerboseLogActivity()) != null) {
            long since = listener.getLastVerboseLogActivityTimestamp();
            if (since > 0L) {
                StopWatch watch = new StopWatch(new Date(since));
                long delta = watch.taken();
                String human = TimeUtils.printDuration(delta);
                return log + " " + human + " ago";
            }
            return log;
        }
        return null;
    }

    @Override
    public String toString() {
        if (this.ftpConsumerToString == null) {
            this.ftpConsumerToString = "FtpConsumer[" + URISupport.sanitizeUri(((DefaultEndpoint)this.getEndpoint()).getEndpointUri()) + "]";
        }
        return this.ftpConsumerToString;
    }
}

