/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.remote;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class FtpsEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":host:port/directoryName";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;

    @Override
    public boolean isEnabled(String scheme) {
        return "ftps".equals(scheme);
    }

    @Override
    public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
        String syntax;
        String uri = syntax = scheme + BASE;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, uri, "host", null, true, copy);
        uri = this.buildPathParameter(syntax, uri, "port", null, false, copy);
        uri = this.buildPathParameter(syntax, uri, "directoryName", null, false, copy);
        uri = this.buildQueryParameters(uri, copy, encode);
        return uri;
    }

    @Override
    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    @Override
    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    @Override
    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(122);
        props.add("disconnect");
        props.add("moveExistingFileStrategy");
        props.add("fileName");
        props.add("synchronous");
        props.add("idempotent");
        props.add("password");
        props.add("preSort");
        props.add("sortBy");
        props.add("scheduledExecutorService");
        props.add("directoryName");
        props.add("readLockDeleteOrphanLockFiles");
        props.add("disableSecureDataChannelDefaults");
        props.add("schedulerProperties");
        props.add("ftpClientKeyStoreParameters");
        props.add("inProgressRepository");
        props.add("soTimeout");
        props.add("execProt");
        props.add("backoffIdleThreshold");
        props.add("passiveMode");
        props.add("delay");
        props.add("startScheduler");
        props.add("binary");
        props.add("readLockTimeout");
        props.add("charset");
        props.add("disconnectOnBatchComplete");
        props.add("implicit");
        props.add("ftpClientParameters");
        props.add("idempotentKey");
        props.add("sorter");
        props.add("maximumReconnectAttempts");
        props.add("stepwise");
        props.add("sslContextParameters");
        props.add("autoCreate");
        props.add("includeExt");
        props.add("recursive");
        props.add("antExclude");
        props.add("keepLastModified");
        props.add("noop");
        props.add("handleDirectoryParserAbsoluteResult");
        props.add("useFixedDelay");
        props.add("runLoggingLevel");
        props.add("transferLoggingLevel");
        props.add("tempPrefix");
        props.add("sendNoop");
        props.add("transferLoggingIntervalSeconds");
        props.add("ftpClientConfig");
        props.add("minDepth");
        props.add("activePortRange");
        props.add("include");
        props.add("idempotentRepository");
        props.add("streamDownload");
        props.add("reconnectDelay");
        props.add("filter");
        props.add("maxDepth");
        props.add("filterFile");
        props.add("pollStrategy");
        props.add("shuffle");
        props.add("excludeExt");
        props.add("antInclude");
        props.add("moveExisting");
        props.add("throwExceptionOnConnectFailed");
        props.add("initialDelay");
        props.add("flatten");
        props.add("download");
        props.add("bridgeErrorHandler");
        props.add("eagerDeleteTargetFile");
        props.add("readLockRemoveOnRollback");
        props.add("siteCommand");
        props.add("readLockRemoveOnCommit");
        props.add("host");
        props.add("connectTimeout");
        props.add("greedy");
        props.add("exclude");
        props.add("maxMessagesPerPoll");
        props.add("fastExistsCheck");
        props.add("repeatCount");
        props.add("ftpClientTrustStoreParameters");
        props.add("sendEmptyMessageWhenIdle");
        props.add("processStrategy");
        props.add("readLock");
        props.add("separator");
        props.add("readLockLoggingLevel");
        props.add("readLockMinLength");
        props.add("lazyStartProducer");
        props.add("ftpClient");
        props.add("port");
        props.add("readLockMarkerFile");
        props.add("exceptionHandler");
        props.add("execPbsz");
        props.add("eagerMaxMessagesPerPoll");
        props.add("backoffMultiplier");
        props.add("exclusiveReadLockStrategy");
        props.add("readLockCheckInterval");
        props.add("fileExist");
        props.add("localWorkDirectory");
        props.add("transferLoggingVerbose");
        props.add("delete");
        props.add("readLockMinAge");
        props.add("timeout");
        props.add("scheduler");
        props.add("jailStartingDirectory");
        props.add("securityProtocol");
        props.add("doneFileName");
        props.add("backoffErrorThreshold");
        props.add("resumeDownload");
        props.add("chmod");
        props.add("onCompletionExceptionHandler");
        props.add("allowNullBody");
        props.add("timeUnit");
        props.add("moveFailed");
        props.add("preMove");
        props.add("move");
        props.add("exchangePattern");
        props.add("useList");
        props.add("ftpClientConfigParameters");
        props.add("tempFileName");
        props.add("ignoreFileNotFoundOrPermissionError");
        props.add("antFilterCaseSensitive");
        props.add("account");
        props.add("bufferSize");
        props.add("filterDirectory");
        props.add("username");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        HashSet<String> secretProps = new HashSet<String>(3);
        secretProps.add("password");
        secretProps.add("account");
        secretProps.add("username");
        SECRET_PROPERTY_NAMES = Collections.unmodifiableSet(secretProps);
    }
}

