/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.remote.strategy;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Expression;
import org.apache.camel.LoggingLevel;
import org.apache.camel.component.file.GenericFileExclusiveReadLockStrategy;
import org.apache.camel.component.file.GenericFileProcessStrategy;
import org.apache.camel.component.file.GenericFileProcessStrategyFactory;
import org.apache.camel.component.file.remote.strategy.FtpChangedExclusiveReadLockStrategy;
import org.apache.camel.component.file.strategy.GenericFileDeleteProcessStrategy;
import org.apache.camel.component.file.strategy.GenericFileExpressionRenamer;
import org.apache.camel.component.file.strategy.GenericFileNoOpProcessStrategy;
import org.apache.camel.component.file.strategy.GenericFileRenameExclusiveReadLockStrategy;
import org.apache.camel.component.file.strategy.GenericFileRenameProcessStrategy;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.net.ftp.FTPFile;

public final class FtpProcessStrategyFactory
implements GenericFileProcessStrategyFactory<FTPFile> {
    @Override
    public GenericFileProcessStrategy<FTPFile> createGenericFileProcessStrategy(CamelContext context, Map<String, Object> params) {
        boolean isMove;
        Expression moveExpression = (Expression)params.get("move");
        Expression moveFailedExpression = (Expression)params.get("moveFailed");
        Expression preMoveExpression = (Expression)params.get("preMove");
        boolean isNoop = params.get("noop") != null;
        boolean isDelete = params.get("delete") != null;
        boolean bl = isMove = moveExpression != null || preMoveExpression != null || moveFailedExpression != null;
        if (isDelete) {
            GenericFileExpressionRenamer renamer;
            GenericFileDeleteProcessStrategy<FTPFile> strategy = new GenericFileDeleteProcessStrategy<FTPFile>();
            strategy.setExclusiveReadLockStrategy(FtpProcessStrategyFactory.getExclusiveReadLockStrategy(params));
            if (preMoveExpression != null) {
                renamer = new GenericFileExpressionRenamer();
                renamer.setExpression(preMoveExpression);
                strategy.setBeginRenamer(renamer);
            }
            if (moveFailedExpression != null) {
                renamer = new GenericFileExpressionRenamer();
                renamer.setExpression(moveFailedExpression);
                strategy.setFailureRenamer(renamer);
            }
            return strategy;
        }
        if (isMove || isNoop) {
            GenericFileExpressionRenamer renamer;
            GenericFileRenameProcessStrategy<FTPFile> strategy = new GenericFileRenameProcessStrategy<FTPFile>();
            strategy.setExclusiveReadLockStrategy(FtpProcessStrategyFactory.getExclusiveReadLockStrategy(params));
            if (!isNoop && moveExpression != null) {
                renamer = new GenericFileExpressionRenamer();
                renamer.setExpression(moveExpression);
                strategy.setCommitRenamer(renamer);
            }
            if (moveFailedExpression != null) {
                renamer = new GenericFileExpressionRenamer();
                renamer.setExpression(moveFailedExpression);
                strategy.setFailureRenamer(renamer);
            }
            if (preMoveExpression != null) {
                renamer = new GenericFileExpressionRenamer();
                renamer.setExpression(preMoveExpression);
                strategy.setBeginRenamer(renamer);
            }
            return strategy;
        }
        GenericFileNoOpProcessStrategy<FTPFile> strategy = new GenericFileNoOpProcessStrategy<FTPFile>();
        strategy.setExclusiveReadLockStrategy(FtpProcessStrategyFactory.getExclusiveReadLockStrategy(params));
        return strategy;
    }

    private static GenericFileExclusiveReadLockStrategy<FTPFile> getExclusiveReadLockStrategy(Map<String, Object> params) {
        GenericFileExclusiveReadLockStrategy strategy = (GenericFileExclusiveReadLockStrategy)params.get("exclusiveReadLockStrategy");
        if (strategy != null) {
            return strategy;
        }
        String readLock = (String)params.get("readLock");
        if (ObjectHelper.isNotEmpty(readLock)) {
            if ("none".equals(readLock) || "false".equals(readLock)) {
                return null;
            }
            if ("rename".equals(readLock)) {
                LoggingLevel readLockLoggingLevel;
                Boolean readLockMarkerFile;
                Long checkInterval;
                GenericFileRenameExclusiveReadLockStrategy<FTPFile> readLockStrategy = new GenericFileRenameExclusiveReadLockStrategy<FTPFile>();
                Long timeout = (Long)params.get("readLockTimeout");
                if (timeout != null) {
                    readLockStrategy.setTimeout(timeout);
                }
                if ((checkInterval = (Long)params.get("readLockCheckInterval")) != null) {
                    readLockStrategy.setCheckInterval(checkInterval);
                }
                if ((readLockMarkerFile = (Boolean)params.get("readLockMarkerFile")) != null) {
                    readLockStrategy.setMarkerFiler(readLockMarkerFile);
                }
                if ((readLockLoggingLevel = (LoggingLevel)((Object)params.get("readLockLoggingLevel"))) != null) {
                    readLockStrategy.setReadLockLoggingLevel(readLockLoggingLevel);
                }
                return readLockStrategy;
            }
            if ("changed".equals(readLock)) {
                LoggingLevel readLockLoggingLevel;
                Boolean readLockMarkerFile;
                Boolean fastExistsCheck;
                Long minAge;
                Long minLength;
                Long checkInterval;
                FtpChangedExclusiveReadLockStrategy readLockStrategy = new FtpChangedExclusiveReadLockStrategy();
                Long timeout = (Long)params.get("readLockTimeout");
                if (timeout != null) {
                    readLockStrategy.setTimeout(timeout);
                }
                if ((checkInterval = (Long)params.get("readLockCheckInterval")) != null) {
                    readLockStrategy.setCheckInterval(checkInterval);
                }
                if ((minLength = (Long)params.get("readLockMinLength")) != null) {
                    readLockStrategy.setMinLength(minLength);
                }
                if (null != (minAge = (Long)params.get("readLockMinAge"))) {
                    readLockStrategy.setMinAge(minAge);
                }
                if ((fastExistsCheck = (Boolean)params.get("fastExistsCheck")) != null) {
                    readLockStrategy.setFastExistsCheck(fastExistsCheck);
                }
                if ((readLockMarkerFile = (Boolean)params.get("readLockMarkerFile")) != null) {
                    readLockStrategy.setMarkerFiler(readLockMarkerFile);
                }
                if ((readLockLoggingLevel = (LoggingLevel)((Object)params.get("readLockLoggingLevel"))) != null) {
                    readLockStrategy.setReadLockLoggingLevel(readLockLoggingLevel);
                }
                return readLockStrategy;
            }
        }
        return null;
    }
}

