/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.scp;

import org.apache.camel.Category;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.component.file.GenericFileProcessStrategy;
import org.apache.camel.component.file.GenericFileProducer;
import org.apache.camel.component.file.remote.RemoteFileConsumer;
import org.apache.camel.component.file.remote.RemoteFileEndpoint;
import org.apache.camel.component.file.remote.RemoteFileOperations;
import org.apache.camel.component.scp.ScpComponent;
import org.apache.camel.component.scp.ScpConfiguration;
import org.apache.camel.component.scp.ScpFile;
import org.apache.camel.component.scp.ScpOperations;
import org.apache.camel.component.scp.ScpProcessStrategyFactory;
import org.apache.camel.component.scp.ScpProducer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;

@UriEndpoint(firstVersion="2.10.0", scheme="scp", extendsScheme="ftp", title="SCP", syntax="scp:host:port/directoryName", producerOnly=true, category={Category.FILE})
@Metadata(excludeProperties="appendChars,binary,charset,doneFileName,download,fastExistsCheck,fileExist,moveExisting,passiveMode,separator,tempFileName,tempPrefix,eagerDeleteTargetFile,keepLastModified,sendNoop,maximumReconnectAttempts,reconnectDelay,autoCreate,bufferSize,siteCommand,stepwise,throwExceptionOnConnectFailed,transferLoggingIntervalSeconds,transferLoggingLevel,transferLoggingVerbose,resumeDownload,handleDirectoryParserAbsoluteResult,activePortRange,ftpClient,ftpClientConfig,ftpClientConfigParameters,ftpClientParameters,account")
public class ScpEndpoint
extends RemoteFileEndpoint<ScpFile> {
    @UriParam
    private ScpConfiguration configuration;

    public ScpEndpoint() {
    }

    public ScpEndpoint(String uri, ScpComponent component, ScpConfiguration configuration) {
        super(uri, component, configuration);
        this.configuration = configuration;
    }

    @Override
    public ScpConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    protected RemoteFileConsumer<ScpFile> buildConsumer(Processor processor) {
        throw new UnsupportedOperationException("This component does not support consuming from this endpoint");
    }

    @Override
    protected GenericFileProducer<ScpFile> buildProducer() {
        return new ScpProducer(this, this.createRemoteFileOperations());
    }

    @Override
    public RemoteFileOperations<ScpFile> createRemoteFileOperations() {
        ScpOperations operations = new ScpOperations();
        operations.setEndpoint(this);
        return operations;
    }

    @Override
    protected GenericFileProcessStrategy<ScpFile> createGenericFileStrategy() {
        return new ScpProcessStrategyFactory().createGenericFileProcessStrategy(this.getCamelContext(), this.getParamsAsMap());
    }

    @Override
    public String getScheme() {
        return "scp";
    }

    @Override
    public Expression getTempFileName() {
        return null;
    }
}

