/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.Comparator;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.Expression;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.ExpressionNodeHelper;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.spi.Metadata;

@Metadata(label="eip,routing")
@XmlRootElement(name="sort")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class SortDefinition<T>
extends ExpressionNode {
    @XmlTransient
    private Comparator<? super T> comparator;
    @XmlAttribute
    private String comparatorRef;

    public SortDefinition() {
    }

    public SortDefinition(Expression expression) {
        this.setExpression(ExpressionNodeHelper.toExpressionDefinition(expression));
    }

    public SortDefinition(Expression expression, Comparator<? super T> comparator) {
        this(expression);
        this.comparator = comparator;
    }

    public String toString() {
        return "sort[" + this.getExpression() + " by: " + (this.comparatorRef != null ? "ref:" + this.comparatorRef : this.comparator) + "]";
    }

    @Override
    public String getShortName() {
        return "sort";
    }

    @Override
    public String getLabel() {
        return "sort[" + this.getExpression() + "]";
    }

    @Override
    public void setExpression(ExpressionDefinition expression) {
        super.setExpression(expression);
    }

    public Comparator<? super T> getComparator() {
        return this.comparator;
    }

    public void setComparator(Comparator<T> comparator) {
        this.comparator = comparator;
    }

    public String getComparatorRef() {
        return this.comparatorRef;
    }

    public void setComparatorRef(String comparatorRef) {
        this.comparatorRef = comparatorRef;
    }

    public SortDefinition<T> comparator(Comparator<T> comparator) {
        this.setComparator(comparator);
        return this;
    }

    public SortDefinition<T> comparatorRef(String ref) {
        this.setComparatorRef(ref);
        return this;
    }
}

