/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.consumer.adapters;

import java.io.File;
import java.nio.ByteBuffer;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.file.consumer.DirectoryEntriesResumeAdapter;
import org.apache.camel.component.file.consumer.FileOffsetResumeAdapter;
import org.apache.camel.component.file.consumer.FileResumeAdapter;
import org.apache.camel.component.file.consumer.adapters.DefaultDirectoryEntriesResumeAdapter;
import org.apache.camel.component.file.consumer.adapters.DefaultFileOffsetResumeAdapter;
import org.apache.camel.resume.Cacheable;
import org.apache.camel.resume.Deserializable;
import org.apache.camel.resume.Offset;
import org.apache.camel.resume.OffsetKey;
import org.apache.camel.resume.cache.ResumeCache;
import org.apache.camel.spi.annotations.JdkService;
import org.apache.camel.support.resume.OffsetKeys;
import org.apache.camel.support.resume.Offsets;

@JdkService(value="file-adapter-factory")
public class FileResumeAdapterDelegate
implements FileResumeAdapter,
Cacheable,
Deserializable,
FileOffsetResumeAdapter,
DirectoryEntriesResumeAdapter {
    private final DefaultDirectoryEntriesResumeAdapter directoryEntriesResumeAdapter = new DefaultDirectoryEntriesResumeAdapter();
    private final DefaultFileOffsetResumeAdapter fileOffsetResumeAdapter = new DefaultFileOffsetResumeAdapter();

    @Override
    public void setResumePayload(GenericFile<File> genericFile) {
        this.fileOffsetResumeAdapter.setResumePayload(genericFile);
    }

    @Override
    public boolean add(OffsetKey<?> key, Offset<?> offset) {
        Object offsetObj = offset.getValue();
        if (offsetObj instanceof Long) {
            return this.fileOffsetResumeAdapter.add(key, offset);
        }
        return this.directoryEntriesResumeAdapter.add(key, offset);
    }

    @Override
    public void setCache(ResumeCache<?> cache) {
        this.fileOffsetResumeAdapter.setCache(cache);
        this.directoryEntriesResumeAdapter.setCache(cache);
    }

    @Override
    public ResumeCache<?> getCache() {
        return this.fileOffsetResumeAdapter.getCache();
    }

    @Override
    public boolean deserialize(ByteBuffer keyBuffer, ByteBuffer valueBuffer) {
        Object keyObj = this.deserializeKey(keyBuffer);
        Object valueObj = this.deserializeValue(valueBuffer);
        if (valueObj instanceof File) {
            this.directoryEntriesResumeAdapter.deserializeFileEntry((File)keyObj, (File)valueObj);
        }
        if (valueObj instanceof Long) {
            this.fileOffsetResumeAdapter.deserializeFileOffset((File)keyObj, (Long)valueObj);
        }
        return this.add(OffsetKeys.of(keyObj), Offsets.of(valueObj));
    }

    @Override
    public void resume() {
        this.fileOffsetResumeAdapter.resume();
        this.directoryEntriesResumeAdapter.resume();
    }

    @Override
    public boolean resume(File file) {
        return this.directoryEntriesResumeAdapter.resume(file);
    }
}

