/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.remote;

import java.util.HashMap;
import java.util.Map;
import org.apache.camel.Category;
import org.apache.camel.Endpoint;
import org.apache.camel.FailedToCreateConsumerException;
import org.apache.camel.FailedToCreateProducerException;
import org.apache.camel.LoggingLevel;
import org.apache.camel.Processor;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.component.file.GenericFileConfiguration;
import org.apache.camel.component.file.GenericFileProcessStrategy;
import org.apache.camel.component.file.GenericFileProducer;
import org.apache.camel.component.file.remote.CamelFTPParserFactory;
import org.apache.camel.component.file.remote.FtpConfiguration;
import org.apache.camel.component.file.remote.FtpConstants;
import org.apache.camel.component.file.remote.FtpConsumer;
import org.apache.camel.component.file.remote.FtpDefaultMoveExistingFileStrategy;
import org.apache.camel.component.file.remote.FtpOperations;
import org.apache.camel.component.file.remote.RemoteFileComponent;
import org.apache.camel.component.file.remote.RemoteFileConfiguration;
import org.apache.camel.component.file.remote.RemoteFileConsumer;
import org.apache.camel.component.file.remote.RemoteFileEndpoint;
import org.apache.camel.component.file.remote.RemoteFileOperations;
import org.apache.camel.component.file.remote.RemoteFileProducer;
import org.apache.camel.component.file.remote.strategy.FtpProcessStrategyFactory;
import org.apache.camel.component.file.strategy.FileMoveExistingStrategy;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPClientConfig;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.parser.FTPFileEntryParserFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(firstVersion="1.1.0", scheme="ftp", extendsScheme="file", title="FTP", syntax="ftp:host:port/directoryName", alternativeSyntax="ftp:username:password@host:port/directoryName", category={Category.FILE}, headersClass=FtpConstants.class)
@Metadata(excludeProperties="appendChars,readLockIdempotentReleaseAsync,readLockIdempotentReleaseAsyncPoolSize,readLockIdempotentReleaseDelay,readLockIdempotentReleaseExecutorService,directoryMustExist,extendedAttributes,probeContentType,startingDirectoryMustExist,startingDirectoryMustHaveAccess,chmodDirectory,forceWrites,copyAndDeleteOnRenameFail,renameUsingCopy,synchronous")
@ManagedResource(description="Managed FtpEndpoint")
public class FtpEndpoint<T extends FTPFile>
extends RemoteFileEndpoint<FTPFile> {
    private static final Logger LOG = LoggerFactory.getLogger(FtpEndpoint.class);
    protected int soTimeout;
    protected int dataTimeout;
    @UriParam
    protected FtpConfiguration configuration;
    @UriParam(label="advanced")
    protected FTPClientConfig ftpClientConfig;
    @UriParam(label="advanced", prefix="ftpClientConfig.", multiValue=true)
    protected Map<String, Object> ftpClientConfigParameters;
    @UriParam(label="advanced", prefix="ftpClient.", multiValue=true)
    protected Map<String, Object> ftpClientParameters;
    @UriParam(label="advanced")
    protected FTPClient ftpClient;
    @UriParam(label="common", defaultValue="DEBUG")
    protected LoggingLevel transferLoggingLevel = LoggingLevel.DEBUG;
    @UriParam(label="common", defaultValue="5")
    protected int transferLoggingIntervalSeconds = 5;
    @UriParam(label="common")
    protected boolean transferLoggingVerbose;
    @UriParam(label="consumer")
    protected boolean resumeDownload;

    public FtpEndpoint() {
    }

    public FtpEndpoint(String uri, RemoteFileComponent<FTPFile> component, FtpConfiguration configuration) {
        super(uri, component, configuration);
        this.configuration = configuration;
    }

    @Override
    public String getScheme() {
        return "ftp";
    }

    @Override
    public RemoteFileConsumer<FTPFile> createConsumer(Processor processor) throws Exception {
        if (this.isResumeDownload() && ObjectHelper.isEmpty(this.getLocalWorkDirectory())) {
            throw new IllegalArgumentException("The option localWorkDirectory must be configured when resumeDownload=true");
        }
        if (this.isResumeDownload() && !this.getConfiguration().isBinary()) {
            throw new IllegalArgumentException("The option binary must be enabled when resumeDownload=true");
        }
        return super.createConsumer(processor);
    }

    @Override
    protected RemoteFileConsumer<FTPFile> buildConsumer(Processor processor) {
        try {
            return new FtpConsumer(this, processor, this.createRemoteFileOperations(), (GenericFileProcessStrategy)(this.processStrategy != null ? this.processStrategy : this.createGenericFileStrategy()));
        }
        catch (Exception e) {
            throw new FailedToCreateConsumerException((Endpoint)this, (Throwable)e);
        }
    }

    @Override
    protected GenericFileProducer<FTPFile> buildProducer() {
        try {
            if (this.getMoveExistingFileStrategy() == null) {
                this.setMoveExistingFileStrategy(this.createDefaultFtpMoveExistingFileStrategy());
            }
            return new RemoteFileProducer<FTPFile>(this, this.createRemoteFileOperations());
        }
        catch (Exception e) {
            throw new FailedToCreateProducerException(this, (Throwable)e);
        }
    }

    private FileMoveExistingStrategy createDefaultFtpMoveExistingFileStrategy() {
        return new FtpDefaultMoveExistingFileStrategy();
    }

    @Override
    protected GenericFileProcessStrategy<FTPFile> createGenericFileStrategy() {
        return new FtpProcessStrategyFactory().createGenericFileProcessStrategy(this.getCamelContext(), this.getParamsAsMap());
    }

    @Override
    public RemoteFileOperations<FTPFile> createRemoteFileOperations() throws Exception {
        FTPClient client = this.ftpClient;
        if (client == null) {
            client = this.createFtpClient();
        }
        if (this.getBufferSize() > 0) {
            client.setBufferSize(this.getBufferSize());
        }
        if (this.getConfiguration().getConnectTimeout() > -1) {
            client.setConnectTimeout(this.getConfiguration().getConnectTimeout());
        }
        if (this.getConfiguration().getSoTimeout() > -1) {
            this.soTimeout = this.getConfiguration().getSoTimeout();
        }
        this.dataTimeout = this.getConfiguration().getTimeout();
        if (this.getConfiguration().getActivePortRange() != null) {
            String[] parts = this.getConfiguration().getActivePortRange().split("-");
            if (parts.length != 2) {
                throw new IllegalArgumentException("The option activePortRange should have syntax: min-max");
            }
            int min = this.getCamelContext().getTypeConverter().mandatoryConvertTo(Integer.TYPE, parts[0]);
            int max = this.getCamelContext().getTypeConverter().mandatoryConvertTo(Integer.TYPE, parts[1]);
            LOG.debug("Using active port range: {}-{}", (Object)min, (Object)max);
            client.setActivePortRange(min, max);
        }
        if (this.ftpClientParameters != null) {
            HashMap<String, Object> localParameters = new HashMap<String, Object>(this.ftpClientParameters);
            Object timeout = localParameters.remove("soTimeout");
            if (timeout != null) {
                this.soTimeout = this.getCamelContext().getTypeConverter().convertTo(Integer.TYPE, timeout);
            }
            if ((timeout = localParameters.remove("dataTimeout")) != null) {
                this.dataTimeout = this.getCamelContext().getTypeConverter().convertTo(Integer.TYPE, timeout);
            }
            this.setProperties(client, localParameters);
        }
        if (this.ftpClientConfigParameters != null) {
            if (this.ftpClientConfig == null) {
                this.ftpClientConfig = new FTPClientConfig();
            }
            HashMap<String, Object> localConfigParameters = new HashMap<String, Object>(this.ftpClientConfigParameters);
            this.setProperties(this.ftpClientConfig, localConfigParameters);
        }
        if (this.dataTimeout > 0) {
            client.setDataTimeout(this.dataTimeout);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Created FTPClient[connectTimeout: {}, soTimeout: {}, dataTimeout: {}, bufferSize: {}, receiveDataSocketBufferSize: {}, sendDataSocketBufferSize: {}]: {}", new Object[]{client.getConnectTimeout(), this.getSoTimeout(), this.dataTimeout, client.getBufferSize(), client.getReceiveDataSocketBufferSize(), client.getSendDataSocketBufferSize(), client});
        }
        FtpOperations operations = new FtpOperations(client, this.getFtpClientConfig());
        operations.setEndpoint(this);
        return operations;
    }

    protected FTPClient createFtpClient() throws Exception {
        FTPClient client = new FTPClient();
        ClassResolver cr = this.getCamelContext().getClassResolver();
        client.setParserFactory((FTPFileEntryParserFactory)new CamelFTPParserFactory(cr));
        return client;
    }

    @Override
    public FtpConfiguration getConfiguration() {
        if (this.configuration == null) {
            this.configuration = new FtpConfiguration();
        }
        return this.configuration;
    }

    @Override
    public void setConfiguration(GenericFileConfiguration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException("FtpConfiguration expected");
        }
        this.configuration = (FtpConfiguration)configuration;
        super.setConfiguration(configuration);
    }

    public FTPClient getFtpClient() {
        return this.ftpClient;
    }

    public void setFtpClient(FTPClient ftpClient) {
        this.ftpClient = ftpClient;
    }

    public FTPClientConfig getFtpClientConfig() {
        return this.ftpClientConfig;
    }

    public void setFtpClientConfig(FTPClientConfig ftpClientConfig) {
        this.ftpClientConfig = ftpClientConfig;
    }

    public Map<String, Object> getFtpClientParameters() {
        return this.ftpClientParameters;
    }

    void setFtpClientParameters(Map<String, Object> ftpClientParameters) {
        this.ftpClientParameters = ftpClientParameters;
    }

    public Map<String, Object> getFtpClientConfigParameters() {
        return this.ftpClientConfigParameters;
    }

    void setFtpClientConfigParameters(Map<String, Object> ftpClientConfigParameters) {
        this.ftpClientConfigParameters = new HashMap<String, Object>(ftpClientConfigParameters);
    }

    public int getSoTimeout() {
        return this.soTimeout;
    }

    public void setSoTimeout(int soTimeout) {
        this.soTimeout = soTimeout;
    }

    public int getDataTimeout() {
        return this.dataTimeout;
    }

    public void setDataTimeout(int dataTimeout) {
        this.dataTimeout = dataTimeout;
    }

    public LoggingLevel getTransferLoggingLevel() {
        return this.transferLoggingLevel;
    }

    public void setTransferLoggingLevel(LoggingLevel transferLoggingLevel) {
        this.transferLoggingLevel = transferLoggingLevel;
    }

    @ManagedAttribute(description="Logging level to use when logging the progress of upload and download operations")
    public void setTransferLoggingLevelName(String transferLoggingLevel) {
        this.transferLoggingLevel = this.getCamelContext().getTypeConverter().convertTo(LoggingLevel.class, transferLoggingLevel);
    }

    @ManagedAttribute
    public String getTransferLoggingLevelName() {
        return this.transferLoggingLevel.name();
    }

    @ManagedAttribute
    public int getTransferLoggingIntervalSeconds() {
        return this.transferLoggingIntervalSeconds;
    }

    @ManagedAttribute(description="Interval in seconds to use when logging the progress of upload and download operations that are in-flight")
    public void setTransferLoggingIntervalSeconds(int transferLoggingIntervalSeconds) {
        this.transferLoggingIntervalSeconds = transferLoggingIntervalSeconds;
    }

    @ManagedAttribute
    public boolean isTransferLoggingVerbose() {
        return this.transferLoggingVerbose;
    }

    @ManagedAttribute(description="Whether the perform verbose (fine grained) logging of the progress of upload and download operations")
    public void setTransferLoggingVerbose(boolean transferLoggingVerbose) {
        this.transferLoggingVerbose = transferLoggingVerbose;
    }

    public boolean isResumeDownload() {
        return this.resumeDownload;
    }

    public void setResumeDownload(boolean resumeDownload) {
        this.resumeDownload = resumeDownload;
    }

    @Override
    public char getFileSeparator() {
        RemoteFileConfiguration.PathSeparator pathSeparator = this.getConfiguration().getSeparator();
        switch (pathSeparator) {
            case Windows: {
                return '\\';
            }
            case UNIX: {
                return '/';
            }
        }
        return super.getFileSeparator();
    }
}

