/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.remote;

import java.net.URI;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.SSLContextParametersAware;
import org.apache.camel.component.file.GenericFileEndpoint;
import org.apache.camel.component.file.remote.FtpComponent;
import org.apache.camel.component.file.remote.FtpUtils;
import org.apache.camel.component.file.remote.FtpsConfiguration;
import org.apache.camel.component.file.remote.FtpsEndpoint;
import org.apache.camel.component.file.remote.RemoteFileComponent;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.util.PropertiesHelper;
import org.apache.commons.net.ftp.FTPFile;

@Component(value="ftps")
public class FtpsComponent
extends FtpComponent
implements SSLContextParametersAware {
    @Metadata(label="security", defaultValue="false")
    private boolean useGlobalSslContextParameters;

    public FtpsComponent() {
    }

    public FtpsComponent(CamelContext context) {
        super(context);
    }

    @Override
    protected GenericFileEndpoint<FTPFile> buildFileEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        String baseUri = this.getBaseUri(uri);
        FtpsConfiguration config = new FtpsConfiguration(new URI(baseUri));
        FtpUtils.ensureRelativeFtpDirectory(this, config);
        FtpsEndpoint endpoint = new FtpsEndpoint(uri, (RemoteFileComponent<FTPFile>)this, config);
        this.extractAndSetFtpClientKeyStoreParameters(parameters, endpoint);
        this.extractAndSetFtpClientTrustStoreParameters(parameters, endpoint);
        this.extractAndSetFtpClientConfigParameters(parameters, endpoint);
        this.extractAndSetFtpClientParameters(parameters, endpoint);
        if (endpoint.getSslContextParameters() == null) {
            endpoint.setSslContextParameters(this.retrieveGlobalSslContextParameters());
        }
        return endpoint;
    }

    protected void extractAndSetFtpClientKeyStoreParameters(Map<String, Object> parameters, FtpsEndpoint endpoint) {
        if (PropertiesHelper.hasProperties(parameters, "ftpClient.keyStore.")) {
            Map<String, Object> param = PropertiesHelper.extractProperties(parameters, "ftpClient.keyStore.");
            endpoint.setFtpClientKeyStoreParameters(param);
        }
    }

    protected void extractAndSetFtpClientTrustStoreParameters(Map<String, Object> parameters, FtpsEndpoint endpoint) {
        if (PropertiesHelper.hasProperties(parameters, "ftpClient.trustStore.")) {
            Map<String, Object> param = PropertiesHelper.extractProperties(parameters, "ftpClient.trustStore.");
            endpoint.setFtpClientTrustStoreParameters(param);
        }
    }

    @Override
    public boolean isUseGlobalSslContextParameters() {
        return this.useGlobalSslContextParameters;
    }

    @Override
    public void setUseGlobalSslContextParameters(boolean useGlobalSslContextParameters) {
        this.useGlobalSslContextParameters = useGlobalSslContextParameters;
    }
}

