/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.remote;

import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.file.GenericFileMessage;

public class RemoteFile<T>
extends GenericFile<T>
implements Cloneable {
    private String hostname;

    public void populateHeaders(GenericFileMessage<T> message) {
        if (message != null) {
            super.populateHeaders(message, false);
            message.setHeader("CamelFileHost", this.getHostname());
        }
    }

    @Override
    public void populateHeaders(GenericFileMessage<T> message, boolean isProbeContentTypeFromEndpoint) {
        this.populateHeaders(message);
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    @Override
    public char getFileSeparator() {
        return '/';
    }

    @Override
    protected boolean isAbsolute(String name) {
        if (name.length() > 0) {
            return name.charAt(0) == '/' || name.charAt(0) == '\\';
        }
        return false;
    }

    @Override
    protected String normalizePath(String name) {
        return name;
    }

    @Override
    public void copyFromPopulateAdditional(GenericFile<T> source, GenericFile<T> result) {
        RemoteFile remoteSource = (RemoteFile)source;
        RemoteFile remoteResult = (RemoteFile)result;
        remoteResult.setHostname(remoteSource.getHostname());
    }

    @Override
    public String toString() {
        return "RemoteFile[" + (this.isAbsolute() ? this.getAbsoluteFilePath() : this.getRelativeFilePath()) + "]";
    }
}

