/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.event;

import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.impl.event.AbstractExchangeEvent;
import org.apache.camel.spi.CamelEvent;
import org.apache.camel.util.URISupport;

public class ExchangeFailureHandlingEvent
extends AbstractExchangeEvent
implements CamelEvent.ExchangeFailureHandlingEvent {
    private static final long serialVersionUID = -7554809462006009549L;
    private final transient Processor failureHandler;
    private final boolean deadLetterChannel;
    private final String deadLetterUri;

    public ExchangeFailureHandlingEvent(Exchange source, Processor failureHandler, boolean deadLetterChannel, String deadLetterUri) {
        super(source);
        this.failureHandler = failureHandler;
        this.deadLetterChannel = deadLetterChannel;
        this.deadLetterUri = deadLetterUri;
    }

    @Override
    public Processor getFailureHandler() {
        return this.failureHandler;
    }

    @Override
    public boolean isDeadLetterChannel() {
        return this.deadLetterChannel;
    }

    @Override
    public String getDeadLetterUri() {
        return this.deadLetterUri;
    }

    @Override
    public String toString() {
        if (this.isDeadLetterChannel()) {
            String uri = URISupport.sanitizeUri(this.deadLetterUri);
            return this.getExchange().getExchangeId() + " exchange failed and sending to dead letter channel: " + uri;
        }
        return this.getExchange().getExchangeId() + " exchange failed and sending to processor: " + this.failureHandler;
    }
}

