/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.camel.CamelContext;
import org.apache.camel.RouteConfigurationsBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.Model;
import org.apache.camel.model.RouteConfigurationDefinition;
import org.apache.camel.model.RouteConfigurationsDefinition;

public abstract class RouteConfigurationBuilder
extends RouteBuilder
implements RouteConfigurationsBuilder {
    private final AtomicBoolean initializedConfiguration = new AtomicBoolean();
    private RouteConfigurationsDefinition routeConfigurationCollection = new RouteConfigurationsDefinition();

    @Override
    public void configure() throws Exception {
    }

    @Override
    public abstract void configuration() throws Exception;

    public RouteConfigurationsDefinition getRouteConfigurationCollection() {
        return this.routeConfigurationCollection;
    }

    public void setRouteConfigurationCollection(RouteConfigurationsDefinition routeConfigurationCollection) {
        this.routeConfigurationCollection = routeConfigurationCollection;
    }

    public RouteConfigurationDefinition routeConfiguration() {
        return this.routeConfiguration(null);
    }

    public RouteConfigurationDefinition routeConfiguration(String id) {
        this.getRouteConfigurationCollection().setCamelContext(this.getCamelContext());
        RouteConfigurationDefinition answer = this.getRouteConfigurationCollection().routeConfiguration(id);
        this.configureRouteConfiguration(answer);
        return answer;
    }

    @Override
    public void addRouteConfigurationsToCamelContext(CamelContext context) throws Exception {
        this.setCamelContext(context);
        this.routeConfigurationCollection.setCamelContext(context);
        if (this.initializedConfiguration.compareAndSet(false, true)) {
            this.configuration();
        }
        this.populateRoutesConfiguration();
    }

    @Override
    public void updateRouteConfigurationsToCamelContext(CamelContext context) throws Exception {
        List<RouteConfigurationDefinition> list;
        this.setCamelContext(context);
        this.routeConfigurationCollection.setCamelContext(context);
        if (this.initializedConfiguration.compareAndSet(false, true)) {
            this.configuration();
        }
        if (!(list = this.getRouteConfigurationCollection().getRouteConfigurations()).isEmpty()) {
            for (RouteConfigurationDefinition def : list) {
                context.getExtension(Model.class).removeRouteConfiguration(def);
            }
            this.populateRoutesConfiguration();
        }
    }

    protected void populateRoutesConfiguration() throws Exception {
        CamelContext camelContext = this.getContext();
        if (camelContext == null) {
            throw new IllegalArgumentException("CamelContext has not been injected!");
        }
        this.getRouteConfigurationCollection().setCamelContext(camelContext);
        camelContext.getExtension(Model.class).addRouteConfigurations(this.getRouteConfigurationCollection().getRouteConfigurations());
    }
}

