/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.catalog.impl;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import org.apache.camel.CamelContext;
import org.apache.camel.CatalogCamelContext;
import org.apache.camel.catalog.JSonSchemaResolver;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.util.IOHelper;

public class CamelContextJSonSchemaResolver
implements JSonSchemaResolver {
    private ClassLoader classLoader;
    private final CatalogCamelContext camelContext;

    public CamelContextJSonSchemaResolver(CamelContext camelContext) {
        this.camelContext = camelContext.adapt(CatalogCamelContext.class);
    }

    @Override
    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public String getComponentJSonSchema(String name) {
        try {
            return this.camelContext.getComponentParameterJsonSchema(name);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public String getDataFormatJSonSchema(String name) {
        try {
            return this.camelContext.getDataFormatParameterJsonSchema(name);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public String getLanguageJSonSchema(String name) {
        try {
            return this.camelContext.getLanguageParameterJsonSchema(name);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public String getOtherJSonSchema(String name) {
        return null;
    }

    @Override
    public String getModelJSonSchema(String name) {
        try {
            return this.camelContext.getEipParameterJsonSchema(name);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getMainJsonSchema() {
        String path = "META-INF/camel-main-configuration-metadata.json";
        InputStream is = null;
        if (this.classLoader != null) {
            is = this.classLoader.getResourceAsStream(path);
        }
        if (is == null) {
            ClassResolver resolver = this.camelContext.getClassResolver();
            is = resolver.loadResourceAsStream(path);
        }
        if (is != null) {
            try {
                String string = IOHelper.loadText(is);
                return string;
            }
            catch (IOException iOException) {
            }
            finally {
                IOHelper.close((Closeable)is);
            }
        }
        return null;
    }
}

