/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.remote;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class FtpEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":host:port/directoryName";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;
    private static final Set<String> MULTI_VALUE_PREFIXES;

    @Override
    public boolean isEnabled(String scheme) {
        return "ftp".equals(scheme);
    }

    @Override
    public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
        String syntax = scheme + BASE;
        Object uri = syntax;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, (String)uri, "host", null, true, copy);
        uri = this.buildPathParameter(syntax, (String)uri, "port", null, false, copy);
        uri = this.buildPathParameter(syntax, (String)uri, "directoryName", null, false, copy);
        uri = this.buildQueryParameters((String)uri, copy, encode);
        return uri;
    }

    @Override
    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    @Override
    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    @Override
    public Set<String> multiValuePrefixes() {
        return MULTI_VALUE_PREFIXES;
    }

    @Override
    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(113);
        props.add("account");
        props.add("activePortRange");
        props.add("allowNullBody");
        props.add("antExclude");
        props.add("antFilterCaseSensitive");
        props.add("antInclude");
        props.add("autoCreate");
        props.add("backoffErrorThreshold");
        props.add("backoffIdleThreshold");
        props.add("backoffMultiplier");
        props.add("binary");
        props.add("bridgeErrorHandler");
        props.add("bufferSize");
        props.add("charset");
        props.add("chmod");
        props.add("connectTimeout");
        props.add("delay");
        props.add("delete");
        props.add("directoryName");
        props.add("disconnect");
        props.add("disconnectOnBatchComplete");
        props.add("doneFileName");
        props.add("download");
        props.add("eagerDeleteTargetFile");
        props.add("eagerMaxMessagesPerPoll");
        props.add("exceptionHandler");
        props.add("exchangePattern");
        props.add("exclude");
        props.add("excludeExt");
        props.add("exclusiveReadLockStrategy");
        props.add("fastExistsCheck");
        props.add("fileExist");
        props.add("fileName");
        props.add("filter");
        props.add("filterDirectory");
        props.add("filterFile");
        props.add("flatten");
        props.add("ftpClient");
        props.add("ftpClientConfig");
        props.add("ftpClientConfigParameters");
        props.add("ftpClientParameters");
        props.add("greedy");
        props.add("handleDirectoryParserAbsoluteResult");
        props.add("host");
        props.add("idempotent");
        props.add("idempotentKey");
        props.add("idempotentRepository");
        props.add("ignoreFileNotFoundOrPermissionError");
        props.add("inProgressRepository");
        props.add("include");
        props.add("includeExt");
        props.add("initialDelay");
        props.add("jailStartingDirectory");
        props.add("keepLastModified");
        props.add("lazyStartProducer");
        props.add("localWorkDirectory");
        props.add("maxDepth");
        props.add("maxMessagesPerPoll");
        props.add("maximumReconnectAttempts");
        props.add("minDepth");
        props.add("move");
        props.add("moveExisting");
        props.add("moveExistingFileStrategy");
        props.add("moveFailed");
        props.add("noop");
        props.add("onCompletionExceptionHandler");
        props.add("passiveMode");
        props.add("password");
        props.add("pollStrategy");
        props.add("port");
        props.add("preMove");
        props.add("preSort");
        props.add("processStrategy");
        props.add("readLock");
        props.add("readLockCheckInterval");
        props.add("readLockDeleteOrphanLockFiles");
        props.add("readLockLoggingLevel");
        props.add("readLockMarkerFile");
        props.add("readLockMinAge");
        props.add("readLockMinLength");
        props.add("readLockRemoveOnCommit");
        props.add("readLockRemoveOnRollback");
        props.add("readLockTimeout");
        props.add("reconnectDelay");
        props.add("recursive");
        props.add("repeatCount");
        props.add("resumeDownload");
        props.add("runLoggingLevel");
        props.add("scheduledExecutorService");
        props.add("scheduler");
        props.add("schedulerProperties");
        props.add("sendEmptyMessageWhenIdle");
        props.add("sendNoop");
        props.add("separator");
        props.add("shuffle");
        props.add("siteCommand");
        props.add("soTimeout");
        props.add("sortBy");
        props.add("sorter");
        props.add("startScheduler");
        props.add("stepwise");
        props.add("streamDownload");
        props.add("tempFileName");
        props.add("tempPrefix");
        props.add("throwExceptionOnConnectFailed");
        props.add("timeUnit");
        props.add("timeout");
        props.add("transferLoggingIntervalSeconds");
        props.add("transferLoggingLevel");
        props.add("transferLoggingVerbose");
        props.add("useFixedDelay");
        props.add("useList");
        props.add("username");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        HashSet<String> secretProps = new HashSet<String>(3);
        secretProps.add("account");
        secretProps.add("password");
        secretProps.add("username");
        SECRET_PROPERTY_NAMES = Collections.unmodifiableSet(secretProps);
        HashSet<String> prefixes = new HashSet<String>(3);
        prefixes.add("ftpClient.");
        prefixes.add("ftpClientConfig.");
        prefixes.add("scheduler.");
        MULTI_VALUE_PREFIXES = Collections.unmodifiableSet(prefixes);
    }
}

