/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.remote;

import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.component.file.remote.RemoteFileConsumer;
import org.apache.camel.support.DefaultPollingConsumerPollStrategy;

public class RemoteFilePollingConsumerPollStrategy
extends DefaultPollingConsumerPollStrategy {
    @Override
    public boolean rollback(Consumer consumer, Endpoint endpoint, int retryCounter, Exception e) throws Exception {
        RemoteFileConsumer rfc;
        if (consumer instanceof RemoteFileConsumer && (rfc = (RemoteFileConsumer)consumer).isRunAllowed()) {
            this.log.warn("Trying to recover by force disconnecting from remote server and re-connecting at next poll: {}", (Object)rfc.remoteServer());
            try {
                rfc.forceDisconnect();
            }
            catch (Throwable t) {
                this.log.debug("Error occurred during force disconnecting from: {}. This exception will be ignored.", (Object)rfc.remoteServer(), (Object)t);
            }
        }
        return super.rollback(consumer, endpoint, retryCounter, e);
    }
}

