/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.remote.strategy;

import java.util.Date;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.file.GenericFileOperations;
import org.apache.camel.util.StopWatch;
import org.apache.commons.net.ftp.FTPFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExclusiveReadLockCheck {
    private static final Logger LOG = LoggerFactory.getLogger(ExclusiveReadLockCheck.class);
    private final boolean fastExistsCheck;
    private final long startTime;
    private final long minAge;
    private final long minLength;
    private final StopWatch watch;
    private long lastModified;
    private long length;

    public ExclusiveReadLockCheck(boolean fastExistsCheck, long minAge, long minLength) {
        this.fastExistsCheck = fastExistsCheck;
        this.startTime = new Date().getTime();
        this.minAge = minAge;
        this.minLength = minLength;
        this.watch = new StopWatch();
        this.lastModified = Long.MIN_VALUE;
        this.length = Long.MIN_VALUE;
    }

    public boolean tryAcquireExclusiveReadLock(GenericFileOperations<FTPFile> operations, GenericFile<FTPFile> file) {
        long newLastModified = 0L;
        long newLength = 0L;
        FTPFile[] files = this.getFtpFiles(operations, file);
        LOG.trace("List files {} found {} files", (Object)file.getAbsoluteFilePath(), (Object)files.length);
        for (FTPFile f : files) {
            boolean match = this.fastExistsCheck ? f.getName().equals(file.getAbsoluteFilePath()) || f.getName().equals(file.getFileNameOnly()) : f.getName().equals(file.getFileNameOnly());
            if (!match) continue;
            newLength = f.getSize();
            if (f.getTimestamp() == null) continue;
            newLastModified = f.getTimestamp().getTimeInMillis();
        }
        LOG.trace("Previous last modified: {}, new last modified: {}", (Object)this.lastModified, (Object)newLastModified);
        LOG.trace("Previous length: {}, new length: {}", (Object)this.length, (Object)newLength);
        long newOlderThan = this.startTime + this.watch.taken() - this.minAge;
        LOG.trace("New older than threshold: {}", (Object)newOlderThan);
        if (this.isReadLockAcquired(this.lastModified, this.length, newLastModified, newLength, newOlderThan)) {
            LOG.trace("Read lock acquired.");
            return true;
        }
        this.lastModified = newLastModified;
        this.length = newLength;
        return false;
    }

    private FTPFile[] getFtpFiles(GenericFileOperations<FTPFile> operations, GenericFile<FTPFile> file) {
        FTPFile[] files = this.fastExistsCheck ? this.getFtpFilesFast(operations, file) : this.getFtpFilesByFilter(operations, file);
        return files;
    }

    private FTPFile[] getFtpFilesByFilter(GenericFileOperations<FTPFile> operations, GenericFile<FTPFile> file) {
        String path = file.getParent();
        if (path.equals("/") || path.equals("\\")) {
            LOG.trace("Using full directory listing in home directory to update file information. Consider enabling fastExistsCheck option.");
            return operations.listFiles();
        }
        LOG.trace("Using full directory listing to update file information for {}. Consider enabling fastExistsCheck option.", (Object)path);
        return operations.listFiles(path);
    }

    private FTPFile[] getFtpFilesFast(GenericFileOperations<FTPFile> operations, GenericFile<FTPFile> file) {
        String path = file.getAbsoluteFilePath();
        if (path.equals("/") || path.equals("\\")) {
            LOG.trace("Using fast exists to update file information in home directory");
            return operations.listFiles();
        }
        LOG.trace("Using fast exists to update file information for {}", (Object)path);
        return operations.listFiles(path);
    }

    private boolean isReadLockAcquired(long lastModified, long length, long newLastModified, long newLength, long newOlderThan) {
        return newLength >= this.minLength && (this.minAge == 0L && newLastModified == lastModified && newLength == length || this.minAge != 0L && newLastModified < newOlderThan);
    }
}

