/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jsonpatch;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.fge.jsonpatch.JsonPatch;
import org.apache.camel.Exchange;
import org.apache.camel.component.jsonpatch.JsonPatchEndpoint;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.ResourceHelper;

public class JsonPatchProducer
extends DefaultProducer {
    private final JsonPatchEndpoint endpoint;
    private final ObjectMapper objectMapper;

    public JsonPatchProducer(JsonPatchEndpoint endpoint) {
        this(endpoint, new ObjectMapper());
    }

    public JsonPatchProducer(JsonPatchEndpoint endpoint, ObjectMapper objectMapper) {
        super(endpoint);
        this.endpoint = endpoint;
        this.objectMapper = objectMapper;
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        String resourceUri = exchange.getIn().getHeader("CamelJsonPatchResourceUri", String.class);
        if (resourceUri == null || resourceUri.isEmpty()) {
            resourceUri = this.endpoint.getResourceUri();
        }
        JsonPatch patch = this.objectMapper.readValue(ResourceHelper.resolveMandatoryResourceAsInputStream(exchange.getContext(), resourceUri), JsonPatch.class);
        JsonNode input = this.objectMapper.readTree(exchange.getIn().getBody(String.class));
        JsonNode result = patch.apply(input);
        ExchangeHelper.setInOutBodyPatternAware(exchange, result.toString());
    }
}

