/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.spi.PropertyConfigurer;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.ObjectHelper;

public final class PropertyConfigurerHelper {
    private PropertyConfigurerHelper() {
    }

    public static PropertyConfigurer resolvePropertyConfigurer(CamelContext context, Object target) {
        ObjectHelper.notNull(target, "target");
        ObjectHelper.notNull(context, "context");
        PropertyConfigurer configurer = null;
        if (target instanceof Component) {
            ServiceHelper.initService(target);
            configurer = ((Component)target).getComponentPropertyConfigurer();
        }
        if (configurer == null) {
            String name = target.getClass().getName();
            configurer = context.adapt(ExtendedCamelContext.class).getConfigurerResolver().resolvePropertyConfigurer(name, context);
        }
        return configurer;
    }

    public static PropertyConfigurer resolvePropertyConfigurer(CamelContext context, Class<?> targetType) {
        ObjectHelper.notNull(targetType, "targetType");
        ObjectHelper.notNull(context, "context");
        String name = targetType.getName();
        return context.adapt(ExtendedCamelContext.class).getConfigurerResolver().resolvePropertyConfigurer(name, context);
    }

    public static <T> T resolvePropertyConfigurer(CamelContext context, Object target, Class<T> type) {
        ObjectHelper.notNull(target, "target");
        ObjectHelper.notNull(context, "context");
        PropertyConfigurer configurer = PropertyConfigurerHelper.resolvePropertyConfigurer(context, target);
        if (type.isInstance(configurer)) {
            return type.cast(configurer);
        }
        return null;
    }
}

