/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.util.Optional;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.DataFormatFactory;
import org.apache.camel.spi.FactoryFinder;
import org.apache.camel.spi.Language;
import org.apache.camel.support.CamelContextHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ResolverHelper {
    public static final String COMPONENT_FALLBACK_SUFFIX = "-component";
    public static final String DATA_FORMAT_FALLBACK_SUFFIX = "-dataformat";
    public static final String DATA_FORMAT_FACTORY_FALLBACK_SUFFIX = "-dataformat-factory";
    public static final String LANGUAGE_FALLBACK_SUFFIX = "-language";
    private static final Logger LOG = LoggerFactory.getLogger(ResolverHelper.class);
    private static final LookupExceptionHandler EXCEPTION_HANDLER = new LookupExceptionHandler();

    private ResolverHelper() {
    }

    public static Component lookupComponentInRegistryWithFallback(CamelContext context, String name) {
        return ResolverHelper.lookupComponentInRegistryWithFallback(context, name, EXCEPTION_HANDLER);
    }

    public static Component lookupComponentInRegistryWithFallback(CamelContext context, String name, LookupExceptionHandler exceptionHandler) {
        Object bean = ResolverHelper.lookupInRegistry(context, Component.class, false, exceptionHandler, name, name + COMPONENT_FALLBACK_SUFFIX);
        if (bean != null) {
            if (bean instanceof Component) {
                return (Component)bean;
            }
            Component component = CamelContextHelper.convertTo(context, Component.class, bean);
            if (component != null) {
                return component;
            }
        }
        if (bean != null) {
            LOG.debug("Found Component with incompatible class: {}", (Object)bean.getClass().getName());
        }
        return null;
    }

    public static DataFormat lookupDataFormatInRegistryWithFallback(CamelContext context, String name) {
        return ResolverHelper.lookupDataFormatInRegistryWithFallback(context, name, EXCEPTION_HANDLER);
    }

    public static DataFormat lookupDataFormatInRegistryWithFallback(CamelContext context, String name, LookupExceptionHandler exceptionHandler) {
        Object bean = ResolverHelper.lookupInRegistry(context, DataFormat.class, false, exceptionHandler, name, name + DATA_FORMAT_FALLBACK_SUFFIX);
        if (bean instanceof DataFormat) {
            return (DataFormat)bean;
        }
        if (bean != null) {
            LOG.debug("Found DataFormat with incompatible class: {}", (Object)bean.getClass().getName());
        }
        return null;
    }

    public static DataFormatFactory lookupDataFormatFactoryInRegistryWithFallback(CamelContext context, String name) {
        return ResolverHelper.lookupDataFormatFactoryInRegistryWithFallback(context, name, EXCEPTION_HANDLER);
    }

    public static DataFormatFactory lookupDataFormatFactoryInRegistryWithFallback(CamelContext context, String name, LookupExceptionHandler exceptionHandler) {
        Object bean = ResolverHelper.lookupInRegistry(context, DataFormatFactory.class, false, exceptionHandler, name, name + DATA_FORMAT_FACTORY_FALLBACK_SUFFIX);
        if (bean instanceof DataFormatFactory) {
            return (DataFormatFactory)bean;
        }
        if (bean != null) {
            LOG.debug("Found DataFormatFactory with incompatible class: {}", (Object)bean.getClass().getName());
        }
        return null;
    }

    public static Language lookupLanguageInRegistryWithFallback(CamelContext context, String name) {
        return ResolverHelper.lookupLanguageInRegistryWithFallback(context, name, EXCEPTION_HANDLER);
    }

    public static Language lookupLanguageInRegistryWithFallback(CamelContext context, String name, LookupExceptionHandler exceptionHandler) {
        Object bean = ResolverHelper.lookupInRegistry(context, Language.class, false, exceptionHandler, name, name + LANGUAGE_FALLBACK_SUFFIX);
        if (bean instanceof Language) {
            return (Language)bean;
        }
        if (bean != null) {
            LOG.debug("Found Language with incompatible class: {}", (Object)bean.getClass().getName());
        }
        return null;
    }

    public static <T> Optional<T> resolveService(CamelContext camelContext, String factoryPath, String factoryKey, Class<T> factoryClass) {
        return ResolverHelper.resolveService(camelContext, camelContext.adapt(ExtendedCamelContext.class).getFactoryFinder(factoryPath), factoryKey, factoryClass);
    }

    public static <T> Optional<T> resolveService(CamelContext camelContext, String factoryKey, Class<T> factoryClass) {
        return ResolverHelper.resolveService(camelContext, camelContext.adapt(ExtendedCamelContext.class).getDefaultFactoryFinder(), factoryKey, factoryClass);
    }

    public static <T> Optional<T> resolveService(CamelContext camelContext, FactoryFinder factoryFinder, String factoryKey, Class<T> factoryClass) {
        Class type = null;
        try {
            type = factoryFinder.findClass(factoryKey).orElse(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (type != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Found {}: {} via: {}{}", new Object[]{factoryClass.getSimpleName(), type.getName(), "META-INF/services/org/apache/camel/", factoryKey});
            }
            if (factoryClass.isAssignableFrom(type)) {
                Object instance = camelContext.getInjector().newInstance(type, false);
                T answer = factoryClass.cast(instance);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Detected and using {}: {}", (Object)factoryClass.getSimpleName(), answer);
                }
                return Optional.of(answer);
            }
            throw new IllegalArgumentException("Type is not a " + factoryClass.getSimpleName() + " implementation. Found: " + type.getName());
        }
        return Optional.empty();
    }

    private static Object lookupInRegistry(CamelContext context, Class<?> type, boolean lookupByNameAndType, LookupExceptionHandler exceptionHandler, String ... names) {
        for (String name : names) {
            try {
                Object bean = lookupByNameAndType ? context.getRegistry().lookupByNameAndType(name, type) : context.getRegistry().lookupByName(name);
                LOG.debug("Lookup {} with name {} in registry. Found: {}", new Object[]{type.getSimpleName(), name, bean});
                if (bean == null) continue;
                return bean;
            }
            catch (Exception e) {
                exceptionHandler.handleException(e, LOG, name);
            }
        }
        return null;
    }

    public static class LookupExceptionHandler {
        public void handleException(Exception e, Logger log, String name) {
            log.debug("Ignored error looking up bean: {}", (Object)name, (Object)e);
        }
    }
}

