/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.jsse;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.spi.Resource;
import org.apache.camel.util.ObjectHelper;

public class JsseParameters
implements CamelContextAware {
    private CamelContext context;

    @Override
    public CamelContext getCamelContext() {
        return this.context;
    }

    @Override
    public void setCamelContext(CamelContext context) {
        this.context = context;
    }

    protected String parsePropertyValue(String value) throws RuntimeCamelException {
        if (this.getCamelContext() != null) {
            try {
                return this.getCamelContext().resolvePropertyPlaceholders(value);
            }
            catch (Exception e) {
                throw new RuntimeCamelException("Error parsing property value: " + value, e);
            }
        }
        return value;
    }

    protected List<String> parsePropertyValues(List<String> values) throws RuntimeCamelException {
        if (this.getCamelContext() == null) {
            return values;
        }
        ArrayList<String> parsedValues = new ArrayList<String>(values.size());
        for (String value : values) {
            parsedValues.add(this.parsePropertyValue(value));
        }
        return parsedValues;
    }

    protected InputStream resolveResource(String resource) throws IOException {
        ObjectHelper.notNull(this.getCamelContext(), "CamelContext", this);
        Resource res = this.getCamelContext().adapt(ExtendedCamelContext.class).getResourceLoader().resolveResource(resource);
        if (res == null) {
            throw new IOException("Could not open " + resource + " as a file, class path resource, or URL.");
        }
        return res.getInputStream();
    }
}

