/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import org.apache.camel.Message;
import org.apache.camel.MessageHistory;
import org.apache.camel.NamedNode;

public class DefaultMessageHistory
implements MessageHistory {
    private final String routeId;
    private final NamedNode node;
    private final String nodeId;
    private final long timestamp;
    private final Message message;
    private long elapsed;

    public DefaultMessageHistory(String routeId, NamedNode node, long timestamp) {
        this(routeId, node, timestamp, null);
    }

    public DefaultMessageHistory(String routeId, NamedNode node, long timestamp, Message message) {
        this.routeId = routeId;
        this.node = node;
        this.nodeId = node.getId();
        this.timestamp = timestamp;
        this.message = message;
    }

    @Override
    public String getRouteId() {
        return this.routeId;
    }

    @Override
    public NamedNode getNode() {
        return this.node;
    }

    @Override
    public long getTime() {
        return this.timestamp;
    }

    @Override
    public long getElapsed() {
        return this.elapsed;
    }

    @Override
    public void nodeProcessingDone() {
        if (this.timestamp > 0L) {
            this.elapsed = System.currentTimeMillis() - this.timestamp;
        }
    }

    @Override
    public Message getMessage() {
        return this.message;
    }

    public String toString() {
        return "DefaultMessageHistory[routeId=" + this.routeId + ", node=" + this.nodeId + "]";
    }
}

