/*
 * Decompiled with CFR 0.152.
 */
package com.github.jasminb.jsonapi.retrofit;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.jasminb.jsonapi.ResourceConverter;
import com.github.jasminb.jsonapi.retrofit.JSONAPIDocumentResponseBodyConverter;
import com.github.jasminb.jsonapi.retrofit.JSONAPIRequestBodyConverter;
import com.github.jasminb.jsonapi.retrofit.JSONAPIResponseBodyConverter;
import com.github.jasminb.jsonapi.retrofit.RetrofitType;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import retrofit2.Converter;
import retrofit2.Retrofit;

public class JSONAPIConverterFactory
extends Converter.Factory {
    private ResourceConverter deserializer;
    private ResourceConverter serializer;
    private Converter.Factory alternativeFactory;

    public JSONAPIConverterFactory(ResourceConverter converter) {
        this.deserializer = converter;
        this.serializer = converter;
    }

    public JSONAPIConverterFactory(ResourceConverter deserializer, ResourceConverter serializer) {
        this.deserializer = deserializer;
        this.serializer = serializer;
    }

    public JSONAPIConverterFactory(ObjectMapper mapper, Class<?> ... classes) {
        this.serializer = this.deserializer = new ResourceConverter(mapper, classes);
    }

    public void setAlternativeFactory(Converter.Factory alternativeFactory) {
        this.alternativeFactory = alternativeFactory;
    }

    @Override
    public Converter<ResponseBody, ?> responseBodyConverter(Type type, Annotation[] annotations, Retrofit retrofit) {
        RetrofitType retrofitType = new RetrofitType(type);
        if (retrofitType.isValid() && this.deserializer.isRegisteredType(retrofitType.getType())) {
            if (retrofitType.isJSONAPIDocumentType()) {
                return new JSONAPIDocumentResponseBodyConverter(this.deserializer, retrofitType.getType(), retrofitType.isCollection());
            }
            return new JSONAPIResponseBodyConverter(this.deserializer, retrofitType.getType(), retrofitType.isCollection());
        }
        if (this.alternativeFactory != null) {
            return this.alternativeFactory.responseBodyConverter(type, annotations, retrofit);
        }
        return null;
    }

    @Override
    public Converter<?, RequestBody> requestBodyConverter(Type type, Annotation[] parameterAnnotations, Annotation[] methodAnnotations, Retrofit retrofit) {
        RetrofitType retrofitType = new RetrofitType(type);
        if (retrofitType.isValid() && this.serializer.isRegisteredType(retrofitType.getType())) {
            return new JSONAPIRequestBodyConverter(this.serializer);
        }
        if (this.alternativeFactory != null) {
            return this.alternativeFactory.requestBodyConverter(type, parameterAnnotations, methodAnnotations, retrofit);
        }
        return null;
    }
}

