/*
 * Decompiled with CFR 0.152.
 */
package com.github.jasminb.jsonapi.retrofit;

import com.github.jasminb.jsonapi.JSONAPIDocument;
import com.github.jasminb.jsonapi.ResourceConverter;
import java.io.IOException;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import retrofit2.Converter;

public class JSONAPIRequestBodyConverter<T>
implements Converter<T, RequestBody> {
    private final ResourceConverter converter;

    public JSONAPIRequestBodyConverter(ResourceConverter converter) {
        this.converter = converter;
    }

    @Override
    public RequestBody convert(T t) throws IOException {
        try {
            boolean isCollection;
            JSONAPIDocument<T> document;
            MediaType mediaType = MediaType.parse("application/vnd.api+json");
            if (t instanceof JSONAPIDocument) {
                document = (JSONAPIDocument<T>)t;
                isCollection = Iterable.class.isAssignableFrom(document.get().getClass());
            } else {
                document = new JSONAPIDocument<T>(t);
                isCollection = Iterable.class.isAssignableFrom(t.getClass());
            }
            if (isCollection) {
                return RequestBody.create(mediaType, this.converter.writeDocumentCollection(document));
            }
            return RequestBody.create(mediaType, this.converter.writeDocument(document));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

