/*
 * Decompiled with CFR 0.152.
 */
package net.minidev.json.actions.navigate;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minidev.json.actions.navigate.NavigateAction;
import net.minidev.json.actions.path.DotDelimiter;
import net.minidev.json.actions.path.TreePath;

public class TreeNavigator<M extends Map<String, Object>, L extends List<Object>> {
    protected List<String> pathsToNavigate;
    protected NavigateAction action;
    protected String pathPrefix = "";

    public TreeNavigator(NavigateAction action, List<String> pathsToNavigate) {
        if (action == null) {
            throw new IllegalArgumentException("NavigateAction cannot be null");
        }
        this.action = action;
        this.pathsToNavigate = pathsToNavigate;
    }

    public TreeNavigator with(String pathPrefix) {
        this.pathPrefix = pathPrefix;
        return this;
    }

    public TreeNavigator(NavigateAction action, String ... pathsToNavigate) {
        this(action, Arrays.asList(pathsToNavigate));
    }

    public void nav(M object) throws Exception {
        if (this.action.start(object, this.pathsToNavigate)) {
            for (String path : this.pathsToNavigate) {
                try {
                    if (path == null || path.equals("") || !this.action.pathStart(path)) continue;
                    TreePath jp = new TreePath(path, new DotDelimiter().withAcceptDelimiterInNodeName(true));
                    this.nav(jp, (L)object);
                    this.action.pathEnd(path);
                }
                catch (Exception e) {
                    if (this.action.failSilently(path, e)) break;
                    if (!this.action.failFast(path, e)) continue;
                    throw e;
                }
            }
        }
        this.action.end();
    }

    public void nav(TreePath jp, M map) {
        if (map == null || !this.action.recurInto(jp, map)) {
            return;
        }
        if (jp.hasNext()) {
            String key = jp.next();
            if (!map.containsKey(key)) {
                this.action.pathTailNotFound(jp, map);
            } else if (map.get(key) instanceof Map) {
                this.nav(jp, (L)((Map)map.get(key)));
            } else if (map.get(key) instanceof List) {
                this.nav(jp, (L)((List)map.get(key)));
            } else if (jp.hasNext()) {
                this.action.foundLeafBeforePathEnd(jp, map.get(key));
            } else if (!jp.hasNext()) {
                this.action.handleLeaf(jp, map.get(key));
            } else {
                throw new IllegalStateException("fatal: unreachable code reached at '" + jp.origin() + "'");
            }
        }
        this.action.recurEnd(jp, map);
    }

    public void nav(TreePath jp, L list) {
        if (list == null || !this.action.recurInto(jp, list)) {
            return;
        }
        int arrIndex = 0;
        Object[] objectArray = list.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object arrItem = objectArray[n2];
            if (arrItem instanceof Map) {
                TreePath jpClone = this.getClone(jp);
                this.nav(jpClone, (L)((Map)arrItem));
            } else if (arrItem instanceof List) {
                this.nav(jp, (L)((List)arrItem));
            } else if (!jp.hasNext()) {
                this.action.handleLeaf(jp, arrIndex, arrItem);
            }
            ++arrIndex;
            ++n2;
        }
        this.action.recurEnd(jp, list);
    }

    private TreePath getClone(TreePath jp) {
        try {
            return jp.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("failed to clone path", e);
        }
    }
}

