/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.jsonpath.easypredicate;

import java.util.ArrayList;
import org.apache.camel.jsonpath.easypredicate.EasyPredicateOperators;

public class EasyPredicateParser {
    public String parse(String predicate) {
        if (predicate.startsWith("$")) {
            return predicate;
        }
        if (!EasyPredicateOperators.hasOperator(predicate)) {
            return predicate;
        }
        StringBuilder sb = new StringBuilder();
        String[] parts = EasyPredicateParser.tokens(predicate);
        if (parts.length == 3) {
            String prev = parts[0];
            String op = parts[1];
            String next = parts[2];
            if (EasyPredicateOperators.isOperator(op)) {
                String after;
                String before;
                int pos = prev.lastIndexOf(".");
                if (pos == -1) {
                    before = "..*";
                    after = prev;
                } else {
                    before = prev.substring(0, pos);
                    after = prev.substring(pos + 1);
                }
                sb.append("$");
                if (!before.startsWith(".")) {
                    sb.append(".");
                }
                sb.append(before);
                sb.append("[?(@.");
                sb.append(after);
                sb.append(" ");
                sb.append(op);
                sb.append(" ");
                sb.append(next);
                sb.append(")]");
            }
            return sb.toString();
        }
        return predicate;
    }

    private static String[] tokens(String predicate) {
        ArrayList<String> list = new ArrayList<String>();
        StringBuilder part = new StringBuilder();
        for (int i = 0; i < predicate.length(); ++i) {
            String s = predicate.substring(i);
            String op = EasyPredicateOperators.getOperatorAtStart(s);
            if (op != null) {
                if (part.length() > 0) {
                    list.add(part.toString());
                    part.setLength(0);
                }
                list.add(op.trim());
                i = i + op.length() + 1;
                continue;
            }
            char ch = predicate.charAt(i);
            part.append(ch);
        }
        if (part.length() > 0) {
            list.add(part.toString());
        }
        return list.toArray(new String[list.size()]);
    }
}

