/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConnectionDroppedException;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Calendar;
import java.util.Date;

public class JavaProgram
implements Serializable {
    static final long serialVersionUID = -209990140140936884L;
    private boolean loaded_ = false;
    private AS400 system_;
    private String path_;
    private String fileOwner_;
    private Date fileChangeDate_;
    private Date javaProgramCreationDate_;
    private int numberOfAttachedPrograms_;
    private int numberOfClassesWithJavaPrograms_;
    private int numberOfClassesWithoutPrograms_;
    private int numberOfClassesWithErrors_;
    private int numberOfClasses_;
    private int optimizationLevel_;
    private String performanceCollectionEnabledFlag_;
    private String performanceCollectionType_;
    private boolean useAdoptedAuthority_;
    private String adoptedAuthorityProfile_;
    private int sizeOfAttachedPrograms_;
    private String javaProgramVersion_;
    private String profilingDataStatus_;
    private String LICoptions_;
    public static final String ADOPTED_AUTHORITY_PROFILE_USER = "*USER";
    public static final String ADOPTED_AUTHORITY_PROFILE_OWNER = "*OWNER";
    public static final String PERFORMANCE_COLLECTION_TYPE_ENTRYEXIT = "*ENTRYEXIT";
    public static final String PERFORMANCE_COLLECTION_TYPE_FULL = "*FULL";
    public static final String PROFILING_DATA_STATUS_NOCOL = "*NOCOL";
    public static final String PROFILING_DATA_STATUS_COL = "*COL";
    public static final String PROFILING_DATA_STATUS_APY = "*APY";

    public JavaProgram() {
    }

    public JavaProgram(AS400 aS400, String string) {
        this.setSystem(aS400);
        this.setPath(string);
    }

    public AS400 getSystem() {
        return this.system_;
    }

    public String getPath() {
        return this.path_;
    }

    public String getAdoptedAuthorityProfile() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.loaded_) {
            this.refresh();
        }
        if (this.adoptedAuthorityProfile_.equals("0")) {
            return ADOPTED_AUTHORITY_PROFILE_USER;
        }
        return ADOPTED_AUTHORITY_PROFILE_OWNER;
    }

    public Date getFileChangeDate() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.loaded_) {
            this.refresh();
        }
        return (Date)this.fileChangeDate_.clone();
    }

    public String getFileOwner() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.loaded_) {
            this.refresh();
        }
        return this.fileOwner_;
    }

    public Date getJavaProgramCreationDate() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.loaded_) {
            this.refresh();
        }
        return (Date)this.javaProgramCreationDate_.clone();
    }

    public String getJavaProgramVersion() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.loaded_) {
            this.refresh();
        }
        return this.javaProgramVersion_;
    }

    public int getNumberOfClasses() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.loaded_) {
            this.refresh();
        }
        return this.numberOfClasses_;
    }

    public int getNumberOfClassesWithCurrentJavaPrograms() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.loaded_) {
            this.refresh();
        }
        return this.numberOfClassesWithJavaPrograms_;
    }

    public int getNumberOfClassesWithErrors() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.loaded_) {
            this.refresh();
        }
        return this.numberOfClassesWithErrors_;
    }

    public int getNumberOfClassesWithoutCurrentJavaPrograms() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.loaded_) {
            this.refresh();
        }
        return this.numberOfClassesWithoutPrograms_;
    }

    public int getNumberOfAttachedPrograms() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.loaded_) {
            this.refresh();
        }
        return this.numberOfAttachedPrograms_;
    }

    public int getOptimizationLevel() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.loaded_) {
            this.refresh();
        }
        return this.optimizationLevel_;
    }

    public String getPerformanceCollectionEnabledFlag() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.loaded_) {
            this.refresh();
        }
        return this.performanceCollectionEnabledFlag_;
    }

    public String getPerformanceCollectionType() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.loaded_) {
            this.refresh();
        }
        if (this.performanceCollectionType_.equals("0")) {
            return PERFORMANCE_COLLECTION_TYPE_ENTRYEXIT;
        }
        return PERFORMANCE_COLLECTION_TYPE_FULL;
    }

    public boolean isUseAdoptedAuthority() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.loaded_) {
            this.refresh();
        }
        return this.useAdoptedAuthority_;
    }

    public int getSizeOfAttachedJavaPrograms() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.loaded_) {
            this.refresh();
        }
        return this.sizeOfAttachedPrograms_;
    }

    public String getProfilingDataStatus() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.loaded_) {
            this.refresh();
        }
        if (this.profilingDataStatus_.equals("0")) {
            return PROFILING_DATA_STATUS_NOCOL;
        }
        if (this.profilingDataStatus_.equals("1")) {
            return PROFILING_DATA_STATUS_COL;
        }
        return PROFILING_DATA_STATUS_APY;
    }

    public String getLICOptions() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.loaded_) {
            this.refresh();
        }
        return this.LICoptions_;
    }

    public void refresh() throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, ObjectDoesNotExistException, IOException, UnsupportedEncodingException {
        Object object;
        int n = this.system_.getCcsid();
        ConvTable convTable = ConvTable.getTable(n, null);
        int n2 = 4096;
        ProgramParameter[] programParameterArray = new ProgramParameter[]{new ProgramParameter(n2), new ProgramParameter(BinaryConverter.intToByteArray(n2)), new ProgramParameter(convTable.stringToByteArray("RJPI0100")), new ProgramParameter(0), new ProgramParameter(BinaryConverter.intToByteArray(0)), new ProgramParameter(convTable.stringToByteArray("RJPC0100")), new ProgramParameter(convTable.stringToByteArray(this.path_)), new ProgramParameter(BinaryConverter.intToByteArray(this.path_.length())), new ProgramParameter(convTable.stringToByteArray(" ")), new ProgramParameter(BinaryConverter.intToByteArray(0)), new ProgramParameter(0), new ProgramParameter(BinaryConverter.intToByteArray(0)), new ProgramParameter(BinaryConverter.intToByteArray(1)), new ProgramParameter(convTable.stringToByteArray("*PGM")), new ProgramParameter(BinaryConverter.intToByteArray(0))};
        ProgramCall programCall = new ProgramCall(this.system_, "/QSYS.LIB/QJVAMAT.PGM", programParameterArray);
        if (!programCall.run()) {
            throw new AS400Exception(programCall.getMessageList());
        }
        byte[] byArray = programParameterArray[0].getOutputData();
        int n3 = BinaryConverter.byteArrayToInt(byArray, 4);
        this.fileOwner_ = convTable.byteArrayToString(byArray, 8, 10);
        String string = convTable.byteArrayToString(byArray, 18, 13);
        if (string.trim().length() == 13) {
            object = Calendar.getInstance();
            ((Calendar)object).clear();
            ((Calendar)object).set(Integer.parseInt(string.substring(0, 3)) + 1900, Integer.parseInt(string.substring(3, 5)) - 1, Integer.parseInt(string.substring(5, 7)), Integer.parseInt(string.substring(7, 9)), Integer.parseInt(string.substring(9, 11)), Integer.parseInt(string.substring(11, 13)));
            this.fileChangeDate_ = ((Calendar)object).getTime();
        } else {
            this.fileChangeDate_ = null;
        }
        string = convTable.byteArrayToString(byArray, 31, 13);
        if (string.trim().length() == 13) {
            object = Calendar.getInstance();
            ((Calendar)object).clear();
            ((Calendar)object).set(Integer.parseInt(string.substring(0, 3)) + 1900, Integer.parseInt(string.substring(3, 5)) - 1, Integer.parseInt(string.substring(5, 7)), Integer.parseInt(string.substring(7, 9)), Integer.parseInt(string.substring(9, 11)), Integer.parseInt(string.substring(11, 13)));
            this.javaProgramCreationDate_ = ((Calendar)object).getTime();
        } else {
            this.javaProgramCreationDate_ = null;
        }
        this.numberOfAttachedPrograms_ = BinaryConverter.byteArrayToInt(byArray, 44);
        this.numberOfClassesWithJavaPrograms_ = BinaryConverter.byteArrayToInt(byArray, 48);
        this.numberOfClassesWithoutPrograms_ = BinaryConverter.byteArrayToInt(byArray, 52);
        this.numberOfClassesWithErrors_ = BinaryConverter.byteArrayToInt(byArray, 56);
        this.numberOfClasses_ = BinaryConverter.byteArrayToInt(byArray, 60);
        this.optimizationLevel_ = BinaryConverter.byteArrayToInt(byArray, 64);
        this.performanceCollectionEnabledFlag_ = convTable.byteArrayToString(byArray, 68, 1);
        this.performanceCollectionType_ = convTable.byteArrayToString(byArray, 69, 1);
        object = convTable.byteArrayToString(byArray, 70, 1);
        this.adoptedAuthorityProfile_ = convTable.byteArrayToString(byArray, 71, 1);
        this.sizeOfAttachedPrograms_ = BinaryConverter.byteArrayToInt(byArray, 72);
        String string2 = Integer.toString((byArray[76] & 0xFF) + 256, 16).substring(1);
        String string3 = Integer.toString((byArray[77] & 0xFF) + 256, 16).substring(1);
        this.javaProgramVersion_ = this.getVersion((string2 + string3).toCharArray());
        this.profilingDataStatus_ = Byte.toString(byArray[78]);
        int n4 = BinaryConverter.byteArrayToInt(byArray, 80);
        int n5 = BinaryConverter.byteArrayToInt(byArray, 84);
        int n6 = BinaryConverter.byteArrayToInt(byArray, 88);
        this.LICoptions_ = convTable.byteArrayToString(byArray, n4, n5);
        this.useAdoptedAuthority_ = !((String)object).equals("0");
        this.loaded_ = true;
    }

    private String getVersion(char[] cArray) {
        String string = "V";
        String string2 = "R";
        String string3 = "M";
        if (cArray[0] != '0') {
            string = string + cArray[0];
        }
        string = string + cArray[1];
        string2 = string2 + cArray[2];
        string3 = string3 + cArray[3];
        return string + string2 + string3;
    }

    public void setSystem(AS400 aS400) {
        if (this.loaded_) {
            throw new ExtendedIllegalStateException("propertiesFrozen", 5);
        }
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        this.system_ = aS400;
    }

    public void setPath(String string) {
        if (this.loaded_) {
            throw new ExtendedIllegalStateException("propertiesFrozen", 5);
        }
        if (string == null) {
            throw new NullPointerException("path");
        }
        this.path_ = string;
    }
}

