/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.data;

import com.ibm.as400.access.AS400DataType;
import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.Trace;
import com.ibm.as400.data.PcmlData;
import com.ibm.as400.data.PcmlDimensions;
import com.ibm.as400.data.PcmlDocNode;
import com.ibm.as400.data.PcmlException;
import com.ibm.as400.data.PcmlMessageLog;
import com.ibm.as400.data.PcmlNode;
import com.ibm.as400.data.PcmlProgram;
import com.ibm.as400.data.RfmlDocument;
import com.ibm.as400.data.SystemResourceFinder;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Hashtable;
import java.util.StringTokenizer;

class PcmlDataValues
implements Serializable {
    static final long serialVersionUID = -8169008879805188674L;
    private PcmlData m_owner;
    private PcmlDimensions m_indices;
    private Object m_value = null;
    private long m_valueTs = 0L;
    private byte[] m_bytes = null;
    private long m_bytesTs = 0L;
    private int m_bidiStringType = 0;

    private PcmlDataValues() {
    }

    PcmlDataValues(PcmlData pcmlData, PcmlDimensions pcmlDimensions) {
        this();
        this.m_owner = pcmlData;
        this.m_indices = new PcmlDimensions(pcmlDimensions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        PcmlDataValues pcmlDataValues = this;
        synchronized (pcmlDataValues) {
            if (this.m_owner.getUsage() == 2 && this.m_bytesTs > this.m_valueTs) {
                this.m_value = null;
                this.m_valueTs = 0L;
            }
            if (this.m_owner.getUsage() == 3 && this.m_valueTs > this.m_bytesTs) {
                this.m_bytes = null;
                this.m_bytesTs = 0L;
            }
            objectOutputStream.defaultWriteObject();
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }

    void readObjectPostprocessing() {
        if (this.m_valueTs == this.m_bytesTs && this.m_valueTs > 0L) {
            this.m_valueTs = this.m_owner.getDoc().getDeserializationTimestamp();
            this.m_bytesTs = this.m_owner.getDoc().getDeserializationTimestamp();
        }
        if (this.m_valueTs > this.m_bytesTs) {
            this.m_valueTs = this.m_owner.getDoc().getDeserializationTimestamp();
            this.m_bytesTs = 0L;
        }
        if (this.m_bytesTs > this.m_valueTs) {
            this.m_bytesTs = this.m_owner.getDoc().getDeserializationTimestamp();
            this.m_valueTs = 0L;
        }
    }

    void flushValues() {
        this.m_value = null;
        this.m_bytes = null;
        this.m_valueTs = 0L;
        this.m_bytesTs = 0L;
    }

    String getQualifiedName() {
        return this.m_owner.getQualifiedName();
    }

    String getNameForException() {
        return this.m_owner.getNameForException();
    }

    long getTimestamp() {
        return Math.max(this.m_valueTs, this.m_bytesTs);
    }

    public Object getValue() throws PcmlException {
        return this.bytesToValue();
    }

    public void setValue(Object object) throws PcmlException {
        if (object == null) {
            throw new PcmlException("NULL_VALUE", new Object[]{this.getNameForException()});
        }
        if (this.getDataType() == 7) {
            throw new PcmlException("STRUCT_VALUE", new Object[]{this.getNameForException()});
        }
        this.m_value = object.getClass().equals(this.getValueClass()) ? (object instanceof BigDecimal ? ((BigDecimal)object).setScale(this.getPrecision(), 6) : object) : PcmlDataValues.convertValue(object, this.getDataType(), this.getLength(), this.getPrecision(), this.getNameForException());
        this.m_valueTs = this.m_owner.getDoc().getCorrelationID();
    }

    public void setBytes(byte[] byArray) {
        this.m_bytes = byArray;
        this.m_bytesTs = this.m_owner.getDoc().getCorrelationID();
    }

    public void setStringType(int n) {
        if (this.m_bidiStringType == n) {
            return;
        }
        this.m_bidiStringType = n;
        this.m_value = null;
        this.m_valueTs = 0L;
    }

    private Object bytesToValue() throws PcmlException {
        Object object;
        if (this.m_bytesTs > this.m_valueTs) {
            this.m_valueTs = this.m_bytesTs;
            this.toObject(this.m_bytes);
        }
        if (this.m_value == null && (object = this.m_owner.getInit()) != null) {
            this.setValue(object);
        }
        if (this.m_value == null) {
            return this.m_value;
        }
        if (this.getDataType() == 6) {
            object = (byte[])this.m_value;
            byte[] byArray = new byte[((Object)object).length];
            for (int i = 0; i < ((Object)object).length; ++i) {
                byArray[i] = (byte)object[i];
            }
            return byArray;
        }
        return this.m_value;
    }

    int getDataType() {
        return this.m_owner.getDataType();
    }

    int getLength() throws PcmlException {
        String string = this.m_owner.getCharType();
        if (string != null && string.equals("twobyte")) {
            return this.resolveIntegerValue(this.m_owner.getLength(), this.m_owner.getLengthId()) * 2;
        }
        return this.resolveIntegerValue(this.m_owner.getLength(), this.m_owner.getLengthId());
    }

    int getOffset() throws PcmlException {
        return this.resolveIntegerValue(this.m_owner.getOffset(), this.m_owner.getOffsetId());
    }

    int getCcsid() throws PcmlException {
        int n = this.resolveIntegerValue(this.m_owner.getCcsid(), this.m_owner.getCcsidId());
        if (n == 0) {
            PcmlNode pcmlNode = this.m_owner.getParent();
            for (pcmlNode = pcmlNode.getParent(); pcmlNode != this.m_owner.getDoc(); pcmlNode = pcmlNode.getParent()) {
            }
            if (pcmlNode instanceof PcmlProgram) {
                return ((PcmlProgram)pcmlNode).getProgramCCSID();
            }
            if (pcmlNode instanceof RfmlDocument) {
                return ((RfmlDocument)pcmlNode).getCcsidInt();
            }
            return this.m_owner.getDoc().getAs400().getCcsid();
        }
        return n;
    }

    int getPrecision() {
        return this.m_owner.getPrecision();
    }

    String getTrim() {
        return this.m_owner.getTrim();
    }

    boolean isArray() {
        return this.m_owner.isArray();
    }

    public int byteLength() throws PcmlException {
        int n = this.getLength();
        switch (this.getDataType()) {
            case 1: {
                return n;
            }
            case 2: {
                return n;
            }
            case 3: {
                return n / 2 + 1;
            }
            case 4: {
                return n;
            }
            case 5: {
                return n;
            }
            case 6: {
                return n;
            }
        }
        throw new PcmlException("BAD_DATA_TYPE", new Object[]{new Integer(this.getDataType()), this.getNameForException()});
    }

    private Class getValueClass() throws PcmlException {
        int n = this.getLength();
        int n2 = this.getPrecision();
        int n3 = this.getDataType();
        try {
            switch (n3) {
                case 1: {
                    return Class.forName("java.lang.String");
                }
                case 2: {
                    if (n == 2) {
                        if (n2 == 16) {
                            return Class.forName("java.lang.Integer");
                        }
                        return Class.forName("java.lang.Short");
                    }
                    if (n == 4) {
                        if (n2 == 32) {
                            return Class.forName("java.lang.Long");
                        }
                        return Class.forName("java.lang.Integer");
                    }
                    if (n == 8) {
                        return Class.forName("java.lang.Long");
                    }
                }
                case 3: 
                case 4: {
                    return Class.forName("java.math.BigDecimal");
                }
                case 5: {
                    if (n == 4) {
                        return Class.forName("java.lang.Float");
                    }
                    return Class.forName("java.lang.Double");
                }
                case 6: {
                    return new byte[0].getClass();
                }
            }
            throw new PcmlException("BAD_DATA_TYPE", new Object[]{new Integer(this.getDataType()), this.getNameForException()});
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new PcmlException("CLASS_NOT_FOUND", new Object[]{new Integer(this.getDataType()), this.getNameForException()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int toBytes(OutputStream outputStream, int n) throws PcmlException {
        Object object;
        Object object2 = null;
        int n2 = this.getDataType();
        int n3 = this.getLength();
        int n4 = this.getPrecision();
        int n5 = 0;
        object2 = this.getValue();
        if (object2 == null) {
            throw new PcmlException("INPUT_VALUE_NOT_SET", new Object[]{this.getNameForException()});
        }
        AS400DataType aS400DataType = this.m_owner.getDoc().getConverter(n2, n3, n4, this.getCcsid());
        byte[] byArray = new byte[n3];
        if (n2 != 1) {
            object = aS400DataType;
            synchronized (object) {
                aS400DataType.toBytes(object2, byArray);
                n5 = aS400DataType.getByteLength();
            }
        }
        object = aS400DataType;
        synchronized (object) {
            ((AS400Text)aS400DataType).toBytes(object2, byArray, 0, this.m_bidiStringType);
            n5 = aS400DataType.getByteLength();
        }
        try {
            outputStream.write(byArray, 0, n5);
        }
        catch (IOException iOException) {
            throw new PcmlException(iOException);
        }
        if (Trace.isTracePCMLOn()) {
            object = this.m_indices.size() > 0 ? SystemResourceFinder.format("WRITE_DATA_W_INDICES", new Object[]{Integer.toHexString(n), Integer.toString(n5), this.getNameForException(), this.m_indices.toString(), PcmlMessageLog.toHexString(byArray, 0, n5)}) : SystemResourceFinder.format("WRITE_DATA", new Object[]{Integer.toHexString(n), Integer.toString(n5), this.getNameForException(), PcmlMessageLog.toHexString(byArray, 0, n5)});
            object = (String)object + "\t  " + Thread.currentThread();
            Trace.log(7, (String)object);
        }
        return n5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object toObject(byte[] byArray) throws PcmlException {
        Object object = null;
        int n = this.getDataType();
        int n2 = this.getLength();
        int n3 = this.getPrecision();
        AS400DataType aS400DataType = this.m_owner.getDoc().getConverter(n, n2, n3, this.getCcsid());
        if (n != 1) {
            AS400DataType aS400DataType2 = aS400DataType;
            synchronized (aS400DataType2) {
                object = aS400DataType.toObject(byArray);
            }
        }
        AS400DataType aS400DataType3 = aS400DataType;
        synchronized (aS400DataType3) {
            object = ((AS400Text)aS400DataType).toObject(byArray, 0, this.m_bidiStringType);
        }
        if (n == 1) {
            object = PcmlDataValues.trimString((String)object, this.getTrim());
        }
        this.setValue(object);
        return object;
    }

    public int parseBytes(byte[] byArray, int n, Hashtable hashtable) throws PcmlException {
        Object object;
        int n2 = 0;
        int n3 = 0;
        int n4 = this.getOffset();
        if (n4 != 0) {
            if (n4 < 0 || n4 > byArray.length) {
                throw new PcmlException("BAD_OFFSET_VALUE", new Object[]{new Integer(n4), new Integer(byArray.length), "<data>", this.getNameForException()});
            }
            object = null;
            String string = this.m_owner.getOffsetfromId();
            if (string != null) {
                object = (Integer)hashtable.get(string);
                if (object == null) {
                    throw new PcmlException("OFFSETFROM_NOT_FOUND", new Object[]{string, this.getNameForException()});
                }
            } else if (this.m_owner.getOffsetfrom() >= 0) {
                object = new Integer(this.m_owner.getOffsetfrom());
            } else {
                string = ((PcmlDocNode)this.m_owner.getParent()).getQualifiedName();
                object = (Integer)hashtable.get(string);
            }
            if (object != null && ((n4 += ((Integer)object).intValue()) < 0 || n4 > byArray.length)) {
                throw new PcmlException("BAD_TOTAL_OFFSET", new Object[]{new Integer(n4), new Integer(byArray.length), object, string, "<data>", this.getNameForException()});
            }
            if (n4 > n) {
                n3 = n4 - n;
            }
        }
        if ((n2 = this.byteLength()) < 0 || n2 > 0x100000) {
            throw new PcmlException("BAD_DATA_LENGTH", new Object[]{new Integer(n2), new Integer(0x100000), "<data>", this.getNameForException()});
        }
        if (n + n3 + n2 > byArray.length) {
            throw new PcmlException("INSUFFICIENT_INPUT_DATA", new Object[]{Integer.toString(n + n3 + n2), Integer.toString(byArray.length), "<data>", this.getNameForException()});
        }
        object = new byte[n2];
        for (int i = 0; i < n2; ++i) {
            object[i] = byArray[n + n3 + i];
        }
        this.setBytes((byte[])object);
        if (Trace.isTracePCMLOn()) {
            String string = this.m_indices.size() > 0 ? SystemResourceFinder.format("READ_DATA_W_INDICES", new Object[]{Integer.toHexString(n + n3), Integer.toString(n2), this.getNameForException(), this.m_indices.toString(), PcmlMessageLog.toHexString((byte[])object)}) : SystemResourceFinder.format("READ_DATA", new Object[]{Integer.toHexString(n + n3), Integer.toString(n2), this.getNameForException(), PcmlMessageLog.toHexString((byte[])object)});
            string = string + "\t  " + Thread.currentThread();
            Trace.log(7, string);
        }
        return n3 + n2;
    }

    private int resolveIntegerValue(int n, String string) throws PcmlException {
        if (string != null) {
            PcmlData pcmlData = (PcmlData)this.m_owner.getRootNode().getElement(string);
            Object object = pcmlData.getValue(this.m_indices);
            if (object instanceof String) {
                return Integer.parseInt((String)object);
            }
            if (object instanceof Number) {
                return ((Number)object).intValue();
            }
            if (object == null) {
                throw new PcmlException("INPUT_VALUE_NOT_SET", new Object[]{pcmlData.getNameForException()});
            }
            throw new PcmlException("STRING_OR_NUMBER", new Object[]{object.getClass().getName(), pcmlData.getNameForException()});
        }
        return n;
    }

    public static Object convertValue(Object object, int n, int n2, int n3, String string) throws PcmlException {
        Object object2 = null;
        if (object == null) {
            throw new PcmlException("NULL_VALUE", new Object[]{string});
        }
        switch (n) {
            case 1: {
                if (object instanceof String) {
                    object2 = object;
                    break;
                }
                object2 = object.toString();
                break;
            }
            case 2: {
                if (n2 == 2) {
                    if (n3 == 16) {
                        if (object instanceof String) {
                            object2 = new Integer((String)object);
                            break;
                        }
                        if (object instanceof Number) {
                            object2 = new Integer(((Number)object).intValue());
                            break;
                        }
                        throw new PcmlException("STRING_OR_NUMBER", new Object[]{object.getClass().getName(), string});
                    }
                    if (object instanceof String) {
                        object2 = new Short((String)object);
                        break;
                    }
                    if (object instanceof Number) {
                        object2 = new Short(((Number)object).shortValue());
                        break;
                    }
                    throw new PcmlException("STRING_OR_NUMBER", new Object[]{object.getClass().getName(), string});
                }
                if (n2 == 4) {
                    if (n3 == 32) {
                        if (object instanceof String) {
                            object2 = new Long((String)object);
                            break;
                        }
                        if (object instanceof Number) {
                            object2 = new Long(((Number)object).longValue());
                            break;
                        }
                        throw new PcmlException("STRING_OR_NUMBER", new Object[]{object.getClass().getName(), string});
                    }
                    if (object instanceof String) {
                        object2 = new Integer((String)object);
                        break;
                    }
                    if (object instanceof Number) {
                        object2 = new Integer(((Number)object).intValue());
                        break;
                    }
                    throw new PcmlException("STRING_OR_NUMBER", new Object[]{object.getClass().getName(), string});
                }
                if (object instanceof String) {
                    object2 = new Long((String)object);
                    break;
                }
                if (object instanceof Number) {
                    object2 = new Long(((Number)object).longValue());
                    break;
                }
                throw new PcmlException("STRING_OR_NUMBER", new Object[]{object.getClass().getName(), string});
            }
            case 3: 
            case 4: {
                if (object instanceof BigDecimal) {
                    object2 = ((BigDecimal)object).setScale(n3, 6);
                    break;
                }
                if (object instanceof String) {
                    object2 = new BigDecimal((String)object);
                    if (((BigDecimal)object2).scale() == n3) break;
                    object2 = ((BigDecimal)object2).setScale(n3, 6);
                    break;
                }
                if (object instanceof Number) {
                    object2 = new BigDecimal(((Number)object).doubleValue()).setScale(n3, 6);
                    break;
                }
                throw new PcmlException("STRING_OR_NUMBER", new Object[]{object.getClass().getName(), string});
            }
            case 5: {
                if (n2 == 4) {
                    if (object instanceof String) {
                        object2 = new Float((String)object);
                        break;
                    }
                    if (object instanceof Number) {
                        object2 = new Float(((Number)object).floatValue());
                        break;
                    }
                    throw new PcmlException("STRING_OR_NUMBER", new Object[]{object.getClass().getName(), string});
                }
                if (object instanceof String) {
                    object2 = new Double((String)object);
                    break;
                }
                if (object instanceof Number) {
                    object2 = new Double(((Number)object).doubleValue());
                    break;
                }
                throw new PcmlException("STRING_OR_NUMBER", new Object[]{object.getClass().getName(), string});
            }
            case 6: {
                if (object instanceof String) {
                    StringTokenizer stringTokenizer = new StringTokenizer((String)object, " ,");
                    byte by = 0;
                    byte[] byArray = new byte[n2];
                    for (int i = 0; i < n2; ++i) {
                        if (stringTokenizer.hasMoreTokens()) {
                            String string2 = stringTokenizer.nextToken();
                            try {
                                by = Byte.decode(string2);
                            }
                            catch (NumberFormatException numberFormatException) {
                                try {
                                    byte[] byArray2 = BinaryConverter.stringToBytes(string2);
                                    by = byArray2[0];
                                }
                                catch (NumberFormatException numberFormatException2) {
                                    throw numberFormatException;
                                }
                            }
                        }
                        byArray[i] = by;
                    }
                    object2 = byArray;
                    break;
                }
                if (object instanceof Number) {
                    byte by = ((Number)object).byteValue();
                    byte[] byArray = new byte[n2];
                    for (int i = 0; i < n2; ++i) {
                        byArray[i] = by;
                    }
                    object2 = byArray;
                    break;
                }
                throw new PcmlException("STRING_OR_NUMBER", new Object[]{object.getClass().getName(), string});
            }
            default: {
                throw new PcmlException("BAD_DATA_TYPE", new Object[]{new Integer(n), string});
            }
        }
        return object2;
    }

    static String trimString(String string, String string2) {
        int n;
        if (string2 != null && string2.equals("none")) {
            return string;
        }
        char[] cArray = string.toCharArray();
        int n2 = 0;
        if (string2 == null || string2.equals("right") || string2.equals("both")) {
            block6: for (n = cArray.length; n > 0; --n) {
                switch (cArray[n - 1]) {
                    case '\u0000': 
                    case ' ': {
                        continue block6;
                    }
                }
            }
        }
        if (string2 != null && (string2.equals("left") || string2.equals("both"))) {
            block7: while (n2 < n) {
                switch (cArray[n2]) {
                    case '\u0000': 
                    case ' ': {
                        ++n2;
                        --n;
                        continue block7;
                    }
                }
            }
        }
        return new String(cArray, n2, n);
    }
}

