/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.data;

import com.ibm.as400.access.AS400Bin2;
import com.ibm.as400.access.AS400Bin4;
import com.ibm.as400.access.AS400Bin8;
import com.ibm.as400.access.AS400ByteArray;
import com.ibm.as400.access.AS400Float4;
import com.ibm.as400.access.AS400Float8;
import com.ibm.as400.access.AS400PackedDecimal;
import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.AS400UnsignedBin2;
import com.ibm.as400.access.AS400UnsignedBin4;
import com.ibm.as400.access.AS400ZonedDecimal;
import com.ibm.as400.access.BinaryFieldDescription;
import com.ibm.as400.access.CharacterFieldDescription;
import com.ibm.as400.access.FieldDescription;
import com.ibm.as400.access.FloatFieldDescription;
import com.ibm.as400.access.HexFieldDescription;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.PackedDecimalFieldDescription;
import com.ibm.as400.access.Record;
import com.ibm.as400.access.RecordFormat;
import com.ibm.as400.access.Trace;
import com.ibm.as400.access.ZonedDecimalFieldDescription;
import com.ibm.as400.data.PcmlAttributeList;
import com.ibm.as400.data.PcmlData;
import com.ibm.as400.data.PcmlDataValues;
import com.ibm.as400.data.PcmlDimensions;
import com.ibm.as400.data.PcmlDocNode;
import com.ibm.as400.data.PcmlException;
import com.ibm.as400.data.RfmlData;
import com.ibm.as400.data.XmlException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

class RfmlRecordFormat
extends PcmlDocNode {
    static final long serialVersionUID = 5L;
    private static final String[] RECORD_FORMAT_ATTRIBUTES = new String[]{"name", "description"};
    private String m_Description;
    private static final int DESCRIPTION_MAX_LENGTH = 50;
    private static final int MAX_DDS_NAME_LENGTH = 10;
    private static final int MAX_FIELD_TEXT_LENGTH = 50;

    public RfmlRecordFormat(PcmlAttributeList pcmlAttributeList) {
        super(pcmlAttributeList);
        this.setNodeType(6);
        this.setDescription(this.getAttributeValue("description"));
    }

    public Object clone() {
        RfmlRecordFormat rfmlRecordFormat = (RfmlRecordFormat)super.clone();
        return rfmlRecordFormat;
    }

    private static void addFieldDescriptions(PcmlDocNode pcmlDocNode, Vector vector, Vector vector2, Vector vector3, String string) throws XmlException {
        Object object;
        Object object2;
        boolean bl = false;
        String string2 = null;
        if (pcmlDocNode.getNodeType() == 3) {
            bl = true;
            string2 = string != null ? string : pcmlDocNode.getName();
        } else if (pcmlDocNode.getNodeType() == 4) {
            Object object3;
            int n;
            object2 = (RfmlData)pcmlDocNode;
            object = new PcmlDimensions();
            try {
                n = ((PcmlData)object2).getLength((PcmlDimensions)object);
            }
            catch (PcmlException pcmlException) {
                throw new XmlException(pcmlException);
            }
            string2 = string != null ? string : ((PcmlDocNode)object2).getName();
            FieldDescription fieldDescription = null;
            String string3 = ((PcmlData)object2).getInit();
            int n2 = ((PcmlData)object2).getPrecision();
            block2 : switch (((PcmlData)object2).getDataType()) {
                case 7: {
                    bl = true;
                    break;
                }
                case 1: {
                    int n3 = ((PcmlData)object2).getCcsid();
                    object3 = n3 == 0 ? new AS400Text(n) : new AS400Text(n, n3);
                    fieldDescription = new CharacterFieldDescription((AS400Text)object3, string2);
                    if (n3 != 0) {
                        ((CharacterFieldDescription)fieldDescription).setCCSID(Integer.toString(n3));
                    }
                    if (string3 == null) break;
                    ((CharacterFieldDescription)fieldDescription).setDFT(string3);
                    break;
                }
                case 2: {
                    switch (n) {
                        case 2: {
                            if (n2 == 16) {
                                fieldDescription = new BinaryFieldDescription(new AS400UnsignedBin2(), string2);
                                if (string3 == null) break block2;
                                ((BinaryFieldDescription)fieldDescription).setDFT(Integer.valueOf(string3));
                                break block2;
                            }
                            fieldDescription = new BinaryFieldDescription(new AS400Bin2(), string2);
                            if (string3 == null) break block2;
                            ((BinaryFieldDescription)fieldDescription).setDFT(Short.valueOf(string3));
                            break block2;
                        }
                        case 4: {
                            if (n2 == 32) {
                                fieldDescription = new BinaryFieldDescription(new AS400UnsignedBin4(), string2);
                                if (string3 == null) break block2;
                                ((BinaryFieldDescription)fieldDescription).setDFT(Long.valueOf(string3));
                                break block2;
                            }
                            fieldDescription = new BinaryFieldDescription(new AS400Bin4(), string2);
                            if (string3 == null) break block2;
                            ((BinaryFieldDescription)fieldDescription).setDFT(Integer.valueOf(string3));
                            break block2;
                        }
                        case 8: {
                            fieldDescription = new BinaryFieldDescription(new AS400Bin8(), string2);
                            if (string3 == null) break block2;
                            ((BinaryFieldDescription)fieldDescription).setDFT(Long.valueOf(string3));
                            break block2;
                        }
                        default: {
                            Trace.log(2, "Invalid field length for type=int: " + n);
                            throw new InternalErrorException(6);
                        }
                    }
                }
                case 4: {
                    AS400ZonedDecimal aS400ZonedDecimal = new AS400ZonedDecimal(n, n2);
                    fieldDescription = new ZonedDecimalFieldDescription(aS400ZonedDecimal, string2);
                    if (string3 == null) break;
                    object3 = new BigDecimal(string3);
                    if (((BigDecimal)object3).scale() != n2) {
                        object3 = ((BigDecimal)object3).setScale(n2, 6);
                    }
                    ((ZonedDecimalFieldDescription)fieldDescription).setDFT((BigDecimal)object3);
                    break;
                }
                case 3: {
                    AS400PackedDecimal aS400PackedDecimal = new AS400PackedDecimal(n, n2);
                    fieldDescription = new PackedDecimalFieldDescription(aS400PackedDecimal, string2);
                    if (string3 == null) break;
                    object3 = new BigDecimal(string3);
                    if (((BigDecimal)object3).scale() != n2) {
                        object3 = ((BigDecimal)object3).setScale(n2, 6);
                    }
                    ((PackedDecimalFieldDescription)fieldDescription).setDFT(new BigDecimal(string3));
                    break;
                }
                case 5: {
                    switch (n) {
                        case 4: {
                            fieldDescription = new FloatFieldDescription(new AS400Float4(), string2);
                            break;
                        }
                        case 8: {
                            fieldDescription = new FloatFieldDescription(new AS400Float8(), string2);
                            break;
                        }
                        default: {
                            Trace.log(2, "Invalid field length for type=float: " + n);
                            throw new InternalErrorException(6);
                        }
                    }
                    if (string3 != null) {
                        if (n == 4) {
                            ((FloatFieldDescription)fieldDescription).setDFT(new Float(string3));
                        } else {
                            ((FloatFieldDescription)fieldDescription).setDFT(new Double(string3));
                        }
                    }
                    ((FloatFieldDescription)fieldDescription).setLength(n);
                    break;
                }
                case 6: {
                    AS400ByteArray aS400ByteArray = new AS400ByteArray(n);
                    fieldDescription = new HexFieldDescription(aS400ByteArray, string2);
                    if (string3 == null) break;
                    object3 = PcmlDataValues.convertValue(string3, 6, n, 0, ((PcmlDocNode)object2).getNameForException());
                    ((HexFieldDescription)fieldDescription).setDFT((byte[])object3);
                    break;
                }
                default: {
                    Trace.log(2, "Invalid data field type: " + ((PcmlData)object2).getDataType());
                    throw new InternalErrorException(6);
                }
            }
            if (fieldDescription != null) {
                int n4;
                String string4 = ((PcmlDocNode)object2).getQualifiedName();
                if (string4.length() <= 50) {
                    fieldDescription.setTEXT(string4);
                } else {
                    int n5 = string4.length() - 50 + 2;
                    String string5 = ".." + string4.substring(n5);
                    fieldDescription.setTEXT(string5);
                }
                object3 = RfmlRecordFormat.generateUniqueName(string2, vector3);
                fieldDescription.setDDSName((String)object3);
                vector3.addElement(((String)object3).toUpperCase());
                try {
                    n4 = ((PcmlData)object2).getCount((PcmlDimensions)object);
                    if (n4 != 1) {
                        Trace.log(4, "Ignoring attribute 'count' (" + n4 + ") for field " + string4);
                    }
                }
                catch (PcmlException pcmlException) {
                    throw new XmlException(pcmlException);
                }
                vector.addElement(fieldDescription);
                if (((PcmlData)object2).isKeyField()) {
                    n4 = vector.size() - 1;
                    vector2.addElement(new Integer(n4));
                }
            }
        }
        if (pcmlDocNode.hasChildren()) {
            object2 = bl && pcmlDocNode.getNbrChildren() == 1 ? string2 : null;
            object = pcmlDocNode.getChildren();
            while (object.hasMoreElements()) {
                PcmlDocNode pcmlDocNode2 = (PcmlDocNode)object.nextElement();
                RfmlRecordFormat.addFieldDescriptions(pcmlDocNode2, vector, vector2, vector3, (String)object2);
            }
        }
    }

    private static String generateUniqueName(String string, Vector vector) {
        if (string.length() <= 10 && !vector.contains(string)) {
            return string;
        }
        int n = Math.max(0, string.length() - 10);
        String string2 = string.substring(n);
        if (!vector.contains(string2)) {
            return string2;
        }
        int n2 = string2.length();
        String string3 = Integer.toString(0);
        StringBuffer stringBuffer = new StringBuffer(string2);
        int n3 = 0;
        while (string3.length() < 10) {
            stringBuffer.replace(0, n2, string2);
            stringBuffer.setLength(n2);
            stringBuffer.append(string3);
            n = Math.max(0, stringBuffer.length() - 10);
            stringBuffer.delete(0, n);
            if (!vector.contains(stringBuffer.toString())) {
                return stringBuffer.toString();
            }
            string3 = Integer.toString(++n3);
        }
        Trace.log(2, "Failed to generate unique DDS name for field: " + string);
        throw new InternalErrorException(6);
    }

    String[] getAttributeList() {
        return RECORD_FORMAT_ATTRIBUTES;
    }

    private static void getDataNodes(PcmlDocNode pcmlDocNode, Vector vector) throws XmlException {
        Serializable serializable;
        Object object;
        if (pcmlDocNode.getNodeType() == 4) {
            object = (RfmlData)pcmlDocNode;
            serializable = new PcmlDimensions();
            try {
                int n = ((PcmlData)object).getLength((PcmlDimensions)serializable);
            }
            catch (PcmlException pcmlException) {
                throw new XmlException(pcmlException);
            }
            String string = ((PcmlDocNode)object).getName();
            switch (((PcmlData)object).getDataType()) {
                case 7: {
                    break;
                }
                default: {
                    vector.addElement(object);
                }
            }
        }
        if (pcmlDocNode.hasChildren()) {
            object = pcmlDocNode.getChildren();
            while (object.hasMoreElements()) {
                serializable = (PcmlDocNode)object.nextElement();
                RfmlRecordFormat.getDataNodes((PcmlDocNode)serializable, vector);
            }
        }
    }

    String getDescription() {
        return this.m_Description;
    }

    int parseBytes(byte[] byArray) throws XmlException {
        PcmlDimensions pcmlDimensions = new PcmlDimensions();
        Hashtable hashtable = new Hashtable();
        int n = 0;
        Enumeration enumeration = this.getChildren();
        while (enumeration.hasMoreElements()) {
            PcmlDocNode pcmlDocNode = (PcmlDocNode)enumeration.nextElement();
            if (pcmlDocNode.getNodeType() == 4) {
                try {
                    int n2 = ((RfmlData)pcmlDocNode).parseBytes(byArray, n, hashtable, pcmlDimensions);
                    n += n2;
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    Trace.log(2, arrayIndexOutOfBoundsException);
                    throw new XmlException("INSUFFICIENT_INPUT_DATA", new Object[]{"(unknown)", Integer.toString(byArray.length), "<recordformat>", this.getNameForException()});
                }
            }
            throw new XmlException("BAD_NODE_TYPE", new Object[]{new Integer(pcmlDocNode.getNodeType()), pcmlDocNode.getNameForException()});
        }
        return n;
    }

    public void setValues(Record record) throws UnsupportedEncodingException, XmlException {
        Vector vector = new Vector();
        RfmlRecordFormat.getDataNodes(this, vector);
        for (int i = 0; i < vector.size(); ++i) {
            RfmlData rfmlData = (RfmlData)vector.elementAt(i);
            Object object = record.getField(i);
            if (object != null) {
                rfmlData.setValue(object);
                continue;
            }
            if (!Trace.isTraceWarningOn()) continue;
            String string = rfmlData.getName();
            Trace.log(4, "Record field " + i + "(" + string + ") is null.");
        }
    }

    void setDescription(String string) {
        this.m_Description = string;
    }

    public byte[] toBytes() throws XmlException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(512);
        PcmlDimensions pcmlDimensions = new PcmlDimensions();
        int n = 0;
        Enumeration enumeration = this.getChildren();
        block6: while (enumeration.hasMoreElements()) {
            PcmlDocNode pcmlDocNode = (PcmlDocNode)enumeration.nextElement();
            switch (pcmlDocNode.getNodeType()) {
                case 3: {
                    continue block6;
                }
                case 4: {
                    RfmlData rfmlData = (RfmlData)pcmlDocNode;
                    int n2 = rfmlData.toBytes(byteArrayOutputStream, n, pcmlDimensions);
                    n += n2;
                    continue block6;
                }
            }
            throw new XmlException("BAD_NODE_TYPE", new Object[]{new Integer(pcmlDocNode.getNodeType()), pcmlDocNode.getNameForException()});
        }
        try {
            byteArrayOutputStream.flush();
        }
        catch (IOException iOException) {
            throw new XmlException(iOException);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public RecordFormat toRecordFormat() throws XmlException {
        int n;
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        Vector vector3 = new Vector();
        RfmlRecordFormat.addFieldDescriptions(this, vector, vector3, vector2, null);
        RecordFormat recordFormat = new RecordFormat(this.getName());
        for (n = 0; n < vector.size(); ++n) {
            recordFormat.addFieldDescription((FieldDescription)vector.elementAt(n));
        }
        for (n = 0; n < vector3.size(); ++n) {
            recordFormat.addKeyFieldDescription((Integer)vector3.elementAt(n));
        }
        return recordFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        RfmlRecordFormat rfmlRecordFormat = this;
        synchronized (rfmlRecordFormat) {
            objectOutputStream.defaultWriteObject();
        }
    }
}

