/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.data;

import com.ibm.as400.access.Trace;
import com.ibm.as400.data.ResourceLoader;
import com.ibm.as400.data.SystemClassLoader;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.text.MessageFormat;
import java.util.MissingResourceException;

class SystemResourceFinder {
    public static final String m_pcmlExtension = ".pcml";
    public static final String m_pcmlSerializedExtension = ".pcml.ser";
    public static final String m_rfmlExtension = ".rfml";
    public static final String m_rfmlSerializedExtension = ".rfml.ser";
    private static final String m_rfmlHeaderName = "com/ibm/as400/data/rfml.dtd";
    private static final String m_pcmlHeaderName = "com/ibm/as400/data/pcml.dtd";
    private static int m_headerLineCount;
    private static ResourceLoader m_loader;

    SystemResourceFinder() {
    }

    public static final String format(String string) {
        return SystemResourceFinder.format(string, null);
    }

    public static final String format(String string, Object[] objectArray) {
        if (objectArray != null) {
            try {
                return MessageFormat.format(m_loader.getString(string), objectArray);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return m_loader.getString(string);
    }

    public static final String getString(String string) {
        return m_loader.getStringWithNoSubstitute(string);
    }

    public static final int getHeaderLineCount() {
        return m_headerLineCount;
    }

    private static final InputStream loadResource(String string) {
        InputStream inputStream = null;
        ClassLoader classLoader = SystemResourceFinder.getLoader1();
        if (classLoader != null) {
            inputStream = classLoader.getResourceAsStream(string);
        }
        if (inputStream != null) {
            return new BufferedInputStream(inputStream);
        }
        classLoader = SystemResourceFinder.getLoader2();
        if (classLoader != null) {
            inputStream = classLoader.getResourceAsStream(string);
        }
        if (inputStream != null) {
            return new BufferedInputStream(inputStream);
        }
        classLoader = SystemResourceFinder.getLoader3();
        if (classLoader != null) {
            inputStream = classLoader.getResourceAsStream(string);
        }
        if (inputStream != null) {
            return new BufferedInputStream(inputStream);
        }
        return null;
    }

    private static final ClassLoader getLoader1() {
        try {
            return Thread.currentThread().getContextClassLoader();
        }
        catch (Throwable throwable) {
            if (Trace.isTraceOn()) {
                Trace.log(7, "Couldn't get current thread's context class loader: " + throwable.toString());
            }
            return null;
        }
    }

    private static final ClassLoader getLoader2() {
        try {
            Class<?> clazz = Class.forName("com.ibm.as400.data.SystemResourceFinder");
            try {
                return clazz.getClassLoader();
            }
            catch (Throwable throwable) {
                if (Trace.isTraceOn()) {
                    Trace.log(7, "Couldn't get SystemResourceFinder class loader: " + throwable.toString());
                }
                return null;
            }
        }
        catch (Throwable throwable) {
            if (Trace.isTraceOn()) {
                Trace.log(7, "Couldn't get SystemResourceFinder class: " + throwable.toString());
            }
            return null;
        }
    }

    private static final ClassLoader getLoader3() {
        return new SystemClassLoader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized InputStream getPCMLHeader() {
        InputStream inputStream;
        block16: {
            Exception exception3;
            String string;
            block15: {
                string = m_pcmlHeaderName;
                inputStream = SystemResourceFinder.loadResource(string);
                if (inputStream == null) {
                    throw new MissingResourceException(SystemResourceFinder.format("PCML_DTD_NOT_FOUND", new Object[]{m_pcmlHeaderName}), m_pcmlHeaderName, "");
                }
                if (m_headerLineCount > 0) break block16;
                LineNumberReader lineNumberReader = null;
                try {
                    lineNumberReader = new LineNumberReader(new InputStreamReader(inputStream));
                    try {
                        String string2 = lineNumberReader.readLine();
                        while (string2 != null) {
                            ++m_headerLineCount;
                            string2 = lineNumberReader.readLine();
                        }
                    }
                    catch (IOException iOException) {
                        Trace.log(7, "Error when reading input stream in getPCMLHeader", (Throwable)iOException);
                    }
                    Object var5_5 = null;
                    if (lineNumberReader == null) break block15;
                }
                catch (Throwable throwable) {
                    Exception exception22;
                    Object var5_6 = null;
                    if (lineNumberReader != null) {
                        try {
                            lineNumberReader.close();
                            inputStream = null;
                        }
                        catch (Exception exception22) {
                            Trace.log(2, exception22);
                        }
                    }
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Exception exception22) {
                            Trace.log(2, exception22);
                        }
                    }
                    throw throwable;
                }
                try {
                    lineNumberReader.close();
                    inputStream = null;
                }
                catch (Exception exception3) {
                    Trace.log(2, exception3);
                }
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception3) {
                    Trace.log(2, exception3);
                }
            }
            inputStream = SystemResourceFinder.loadResource(string);
        }
        return inputStream;
    }

    public static synchronized InputStream getXPCMLTransformFile(String string) {
        String string2 = "com/ibm/as400/data/" + string;
        InputStream inputStream = SystemResourceFinder.loadResource(string2);
        if (inputStream == null) {
            if (Trace.isTraceOn()) {
                Trace.log(7, "XSL file not found.");
            }
            throw new MissingResourceException(SystemResourceFinder.format("XML_NOT_FOUND", new Object[]{string}), string, "");
        }
        return inputStream;
    }

    static synchronized InputStream getPCMLDocument(String string, ClassLoader classLoader) throws MissingResourceException {
        Object object;
        String string2 = null;
        if (string.endsWith(m_pcmlExtension) || string.endsWith(".pcmlsrc") || string.endsWith(".xpcml") || string.endsWith(".xpcmlsrc")) {
            object = string.substring(0, string.lastIndexOf(46));
            String string3 = string.substring(string.lastIndexOf(46));
            string2 = ((String)object).replace('.', '/') + string3;
        } else {
            string2 = string.replace('.', '/') + m_pcmlExtension;
        }
        object = null;
        if (classLoader != null) {
            object = classLoader.getResourceAsStream(string2);
            if (object != null) {
                return new BufferedInputStream((InputStream)object);
            }
            throw new MissingResourceException(SystemResourceFinder.format("PCML_NOT_FOUND", new Object[]{string}), string, "");
        }
        object = SystemResourceFinder.loadResource(string2);
        if (object != null) {
            return object;
        }
        throw new MissingResourceException(SystemResourceFinder.format("PCML_NOT_FOUND", new Object[]{string}), string, "");
    }

    static synchronized InputStream getSerializedPCMLDocument(String string, ClassLoader classLoader) throws MissingResourceException {
        String string2 = string.replace('.', '/') + m_pcmlSerializedExtension;
        InputStream inputStream = null;
        if (classLoader != null) {
            inputStream = classLoader.getResourceAsStream(string2);
            if (inputStream != null) {
                return new BufferedInputStream(inputStream);
            }
            throw new MissingResourceException(SystemResourceFinder.format("SERIALIZED_PCML_NOT_FOUND", new Object[]{string}), string, "");
        }
        inputStream = SystemResourceFinder.loadResource(string2);
        if (inputStream != null) {
            return inputStream;
        }
        throw new MissingResourceException(SystemResourceFinder.format("SERIALIZED_PCML_NOT_FOUND", new Object[]{string}), string, "");
    }

    public static synchronized InputStream getRFMLHeader() {
        String string = m_rfmlHeaderName;
        InputStream inputStream = SystemResourceFinder.loadResource(string);
        if (inputStream == null) {
            throw new MissingResourceException(SystemResourceFinder.format("DTD_NOT_FOUND", new Object[]{"RFML", m_rfmlHeaderName}), m_rfmlHeaderName, "");
        }
        return inputStream;
    }

    static synchronized InputStream getRFMLDocument(String string, ClassLoader classLoader) throws MissingResourceException {
        Object object;
        String string2 = null;
        if (string.endsWith(m_rfmlExtension) || string.endsWith(".rfmlsrc")) {
            object = string.substring(0, string.lastIndexOf(46));
            String string3 = string.substring(string.lastIndexOf(46));
            string2 = ((String)object).replace('.', '/') + string3;
        } else {
            string2 = string.replace('.', '/') + m_rfmlExtension;
        }
        object = null;
        if (classLoader != null) {
            object = classLoader.getResourceAsStream(string2);
            if (object != null) {
                return new BufferedInputStream((InputStream)object);
            }
            throw new MissingResourceException(SystemResourceFinder.format("XML_NOT_FOUND", new Object[]{"RFML", string}), string, "");
        }
        object = SystemResourceFinder.loadResource(string2);
        if (object != null) {
            return object;
        }
        throw new MissingResourceException(SystemResourceFinder.format("XML_NOT_FOUND", new Object[]{"RFML", string}), string, "");
    }

    static synchronized InputStream getSerializedRFMLDocument(String string, ClassLoader classLoader) throws MissingResourceException {
        String string2 = string.replace('.', '/') + m_rfmlSerializedExtension;
        InputStream inputStream = null;
        if (classLoader != null) {
            inputStream = classLoader.getResourceAsStream(string2);
            if (inputStream != null) {
                return new BufferedInputStream(inputStream);
            }
            throw new MissingResourceException(SystemResourceFinder.format("SERIALIZED_XML_NOT_FOUND", new Object[]{"RFML", string}), string, "");
        }
        inputStream = SystemResourceFinder.loadResource(string2);
        if (inputStream != null) {
            return inputStream;
        }
        throw new MissingResourceException(SystemResourceFinder.format("SERIALIZED_XML_NOT_FOUND", new Object[]{"RFML", string}), string, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean isXPCML(String string, ClassLoader classLoader) throws MissingResourceException, IOException {
        boolean bl;
        Object object;
        block17: {
            String string2 = null;
            if (string.endsWith(m_pcmlExtension) || string.endsWith(".pcmlsrc") || string.endsWith(".xpcml") || string.endsWith(".xpcmlsrc")) {
                String string3 = string.substring(0, string.lastIndexOf(46));
                object = string.substring(string.lastIndexOf(46));
                string2 = string3.replace('.', '/') + (String)object;
            } else {
                string2 = string.replace('.', '/') + m_pcmlExtension;
            }
            bl = false;
            object = null;
            BufferedReader bufferedReader = null;
            try {
                if (classLoader != null && (object = classLoader.getResourceAsStream(string2)) == null) {
                    throw new MissingResourceException(SystemResourceFinder.format("PCML_NOT_FOUND", new Object[]{string}), string, "");
                }
                if (object == null && (object = SystemResourceFinder.loadResource(string2)) == null) {
                    throw new MissingResourceException(SystemResourceFinder.format("PCML_NOT_FOUND", new Object[]{string}), string, "");
                }
                bufferedReader = new LineNumberReader(new InputStreamReader((InputStream)object));
                try {
                    String string4 = ((LineNumberReader)bufferedReader).readLine();
                    boolean bl2 = false;
                    while (string4 != null && !bl2) {
                        if (string4.indexOf("<xpcml") != -1) {
                            bl2 = true;
                            bl = true;
                            continue;
                        }
                        if (string4.indexOf("<pcml") != -1) {
                            bl2 = true;
                            bl = false;
                            continue;
                        }
                        string4 = ((LineNumberReader)bufferedReader).readLine();
                    }
                }
                catch (IOException iOException) {
                    Trace.log(7, "Error when reading input stream in isXPCML");
                    throw iOException;
                }
                Object var9_10 = null;
                if (bufferedReader == null) break block17;
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (object != null) {
                    ((InputStream)object).close();
                }
                throw throwable;
            }
            try {
                bufferedReader.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (object != null) {
            ((InputStream)object).close();
        }
        return bl;
    }

    static {
        m_loader = new ResourceLoader();
        m_loader.setResourceName("com.ibm.as400.data.DAMRI");
    }
}

