/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.ActionCompletedEvent;
import com.ibm.as400.access.ActionCompletedListener;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.Job;
import com.ibm.as400.access.RemoteCommandImpl;
import com.ibm.as400.access.SystemProperties;
import com.ibm.as400.access.Trace;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;

public class CommandCall
implements Serializable {
    private static final String CLASSNAME = "com.ibm.as400.access.CommandCall";
    static final long serialVersionUID = 4L;
    private static final int UNSPECIFIED = 0;
    private static final int SPECIFIED_BY_PROPERTY = 1;
    private static final int SPECIFIED_BY_SETTER = 2;
    public static final Boolean THREADSAFE_FALSE;
    public static final Boolean THREADSAFE_TRUE;
    public static final Boolean THREADSAFE_LOOKUP;
    private AS400 system_ = null;
    private String command_ = "";
    private AS400Message[] messageList_ = new AS400Message[0];
    private transient Boolean threadSafetyValue_ = THREADSAFE_FALSE;
    private boolean threadSafety_ = false;
    private transient boolean threadSafetyIsLookedUp_ = false;
    private int threadSafetyDetermined_ = 0;
    private int messageOption_ = 0;
    private transient RemoteCommandImpl impl_ = null;
    private transient Vector actionCompletedListeners_ = null;
    private transient PropertyChangeSupport propertyChangeListeners_ = null;
    private transient VetoableChangeSupport vetoableChangeListeners_ = null;

    public CommandCall() {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing CommandCall object.");
        }
        this.applyThreadSafetyProperty();
    }

    public CommandCall(AS400 aS400) {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing CommandCall object, system: " + aS400);
        }
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        this.system_ = aS400;
        this.applyThreadSafetyProperty();
    }

    public CommandCall(AS400 aS400, String string) {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing CommandCall object, system: " + aS400 + " command: " + string);
        }
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        if (string == null) {
            throw new NullPointerException("command");
        }
        this.system_ = aS400;
        this.command_ = string;
        this.applyThreadSafetyProperty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addActionCompletedListener(ActionCompletedListener actionCompletedListener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Adding action completed listener.");
        }
        if (actionCompletedListener == null) {
            throw new NullPointerException("listener");
        }
        CommandCall commandCall = this;
        synchronized (commandCall) {
            if (this.actionCompletedListeners_ == null) {
                this.actionCompletedListeners_ = new Vector();
            }
            this.actionCompletedListeners_.addElement(actionCompletedListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Adding property change listener.");
        }
        if (propertyChangeListener == null) {
            throw new NullPointerException("listener");
        }
        CommandCall commandCall = this;
        synchronized (commandCall) {
            if (this.propertyChangeListeners_ == null) {
                this.propertyChangeListeners_ = new PropertyChangeSupport(this);
            }
            this.propertyChangeListeners_.addPropertyChangeListener(propertyChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Adding vetoable change listener.");
        }
        if (vetoableChangeListener == null) {
            throw new NullPointerException("listener");
        }
        CommandCall commandCall = this;
        synchronized (commandCall) {
            if (this.vetoableChangeListeners_ == null) {
                this.vetoableChangeListeners_ = new VetoableChangeSupport(this);
            }
            this.vetoableChangeListeners_.addVetoableChangeListener(vetoableChangeListener);
        }
    }

    private synchronized void chooseImpl() throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException {
        if (this.system_ != null) {
            this.system_.signon(false);
        }
        if (this.impl_ == null) {
            if (this.system_ == null) {
                Trace.log(2, "Attempt to connect to command server before setting system.");
                throw new ExtendedIllegalStateException("system", 4);
            }
            this.impl_ = (RemoteCommandImpl)this.system_.loadImpl3("com.ibm.as400.access.RemoteCommandImplNative", "com.ibm.as400.access.RemoteCommandImplRemote", "com.ibm.as400.access.RemoteCommandImplProxy");
            this.impl_.setSystem(this.system_.getImpl());
        }
        if (this.threadSafetyValue_ == THREADSAFE_LOOKUP) {
            int n;
            this.threadSafetyValue_ = this.command_ == null || this.command_.length() == 0 ? THREADSAFE_FALSE : (!this.impl_.isNative() ? THREADSAFE_FALSE : ((n = this.impl_.getThreadsafeIndicator(this.command_)) == 1 ? THREADSAFE_TRUE : THREADSAFE_FALSE));
            this.threadSafety_ = this.threadSafetyValue_ == THREADSAFE_TRUE;
        }
    }

    private void fireActionCompleted() {
        Vector vector = (Vector)this.actionCompletedListeners_.clone();
        ActionCompletedEvent actionCompletedEvent = new ActionCompletedEvent(this);
        for (int i = 0; i < vector.size(); ++i) {
            ActionCompletedListener actionCompletedListener = (ActionCompletedListener)vector.elementAt(i);
            actionCompletedListener.actionCompleted(actionCompletedEvent);
        }
    }

    public String getCommand() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting command: " + this.command_);
        }
        return this.command_;
    }

    public int getMessageOption() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting message option:", this.messageOption_);
        }
        return this.messageOption_;
    }

    public AS400Message[] getMessageList() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting message list.");
        }
        return this.messageList_;
    }

    public AS400Message getMessageList(int n) {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting message from message list:", n);
        }
        return this.messageList_[n];
    }

    public Job getServerJob() throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting job.");
        }
        this.chooseImpl();
        String string = this.impl_.getJobInfo(this.threadSafetyValue_);
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing Job for job: " + string);
        }
        return new Job(this.system_, string.substring(0, 10).trim(), string.substring(10, 20).trim(), string.substring(20, 26).trim());
    }

    public AS400 getSystem() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting system: " + this.system_);
        }
        return this.system_;
    }

    public Thread getSystemThread() throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException {
        Thread thread;
        if (Trace.traceOn_) {
            Trace.log(1, "Getting system thread.");
        }
        this.chooseImpl();
        Thread thread2 = thread = this.impl_.isNative() ? Thread.currentThread() : null;
        if (Trace.traceOn_) {
            Trace.log(1, "System thread: " + thread);
        }
        return thread;
    }

    static final String getThreadSafetyProperty() {
        String string = SystemProperties.getProperty("com.ibm.as400.access.CommandCall.threadSafe");
        return string == null || string.length() == 0 ? null : string.toLowerCase();
    }

    private void applyThreadSafetyProperty() {
        String string = CommandCall.getThreadSafetyProperty();
        if (string == null) {
            if (Trace.traceOn_) {
                Trace.log(1, "Thread safe system property not set; thread safety property remains unspecified.");
            }
        } else {
            if (string.equals("true")) {
                this.threadSafetyValue_ = THREADSAFE_TRUE;
                this.threadSafetyDetermined_ = 1;
            } else if (string.equals("false")) {
                this.threadSafetyValue_ = THREADSAFE_FALSE;
                this.threadSafetyDetermined_ = 1;
            } else if (string.equals("lookup")) {
                this.threadSafetyValue_ = THREADSAFE_LOOKUP;
                this.threadSafetyDetermined_ = 1;
                this.threadSafetyIsLookedUp_ = true;
            } else if (Trace.traceOn_) {
                Trace.log(4, "Unrecognized value for CommandCall.threadSafe property: " + string + ". Defaulting to 'false'.");
            }
            this.threadSafety_ = this.threadSafetyValue_ == THREADSAFE_TRUE;
        }
    }

    public int getThreadsafeIndicator() throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException {
        if (this.command_ == null || this.command_.length() == 0) {
            Trace.log(2, "Attempt to retrieve Threadsafe indicator before setting command.");
            throw new ExtendedIllegalStateException("command", 4);
        }
        this.chooseImpl();
        return this.impl_.getThreadsafeIndicator(this.command_);
    }

    public boolean isStayOnThread() throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException {
        boolean bl;
        if (Trace.traceOn_) {
            Trace.log(1, "Checking if command will actually get run on the current thread.");
        }
        this.chooseImpl();
        boolean bl2 = bl = this.threadSafetyValue_ == THREADSAFE_TRUE && this.impl_.isNative();
        if (Trace.traceOn_) {
            Trace.log(1, "Will command actually get run on the current thread:", bl);
        }
        return bl;
    }

    public boolean isThreadSafe() throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException {
        if (Trace.traceOn_) {
            Trace.log(1, "Checking if command will be assumed thread-safe.");
        }
        this.chooseImpl();
        return this.threadSafetyValue_;
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "De-serializing CommandCall object.");
        }
        objectInputStream.defaultReadObject();
        this.threadSafetyIsLookedUp_ = false;
        if (this.threadSafetyDetermined_ == 3) {
            this.threadSafetyDetermined_ = 0;
        }
        if (this.threadSafetyDetermined_ == 2) {
            this.threadSafetyValue_ = this.threadSafety_ ? THREADSAFE_TRUE : THREADSAFE_FALSE;
        } else {
            this.threadSafetyValue_ = THREADSAFE_FALSE;
            this.threadSafety_ = false;
            this.threadSafetyIsLookedUp_ = false;
            String string = CommandCall.getThreadSafetyProperty();
            if (string == null) {
                this.threadSafetyDetermined_ = 0;
                if (Trace.traceOn_) {
                    Trace.log(1, "Thread safe system property not set, so thread safety property changed to unspecified.");
                }
            } else {
                this.applyThreadSafetyProperty();
            }
        }
    }

    public void removeActionCompletedListener(ActionCompletedListener actionCompletedListener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Removing action completed listener.");
        }
        if (actionCompletedListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.actionCompletedListeners_ != null) {
            this.actionCompletedListeners_.removeElement(actionCompletedListener);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Removing property change listener.");
        }
        if (propertyChangeListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.propertyChangeListeners_ != null) {
            this.propertyChangeListeners_.removePropertyChangeListener(propertyChangeListener);
        }
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Removing vetoable change listener.");
        }
        if (vetoableChangeListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.vetoableChangeListeners_ != null) {
            this.vetoableChangeListeners_.removeVetoableChangeListener(vetoableChangeListener);
        }
    }

    public boolean run() throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException {
        if (Trace.traceOn_) {
            Trace.log(3, "Running command: " + this.command_);
        }
        if (this.command_ == null || this.command_.length() == 0) {
            Trace.log(2, "Attempt to run before setting command.");
            throw new ExtendedIllegalStateException("command", 4);
        }
        this.chooseImpl();
        boolean bl = this.impl_.runCommand(this.command_, this.threadSafetyValue_, this.messageOption_);
        this.messageList_ = this.impl_.getMessageList();
        if (this.system_ != null) {
            for (int i = 0; i < this.messageList_.length; ++i) {
                this.messageList_[i].setSystem(this.system_);
            }
        }
        if (this.actionCompletedListeners_ != null) {
            this.fireActionCompleted();
        }
        return bl;
    }

    public boolean run(String string) throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, PropertyVetoException {
        this.setCommand(string);
        return this.run();
    }

    public boolean run(byte[] byArray) throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(3, "Running command:", byArray);
        }
        if (byArray == null) {
            throw new NullPointerException("command");
        }
        if (byArray.length == 0) {
            throw new ExtendedIllegalArgumentException("command.length (" + byArray.length + ")", 1);
        }
        this.chooseImpl();
        boolean bl = this.impl_.runCommand(byArray, this.threadSafetyValue_, this.messageOption_);
        this.messageList_ = this.impl_.getMessageList();
        if (this.system_ != null) {
            for (int i = 0; i < this.messageList_.length; ++i) {
                this.messageList_[i].setSystem(this.system_);
            }
        }
        if (this.actionCompletedListeners_ != null) {
            this.fireActionCompleted();
        }
        return bl;
    }

    public void setCommand(String string) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting command: " + string);
        }
        if (string == null) {
            throw new NullPointerException("command");
        }
        if (Trace.traceOn_ && string.length() == 0) {
            Trace.log(4, "Parameter 'command' is has length of 0.");
        }
        boolean bl = false;
        if (this.threadSafetyIsLookedUp_ && this.threadSafetyValue_ != THREADSAFE_LOOKUP && !CommandCall.firstToken(string).equalsIgnoreCase(CommandCall.firstToken(this.command_))) {
            bl = true;
        }
        String string2 = this.command_;
        String string3 = string;
        if (this.vetoableChangeListeners_ != null) {
            this.vetoableChangeListeners_.fireVetoableChange("command", string2, string3);
        }
        this.command_ = string3;
        if (this.propertyChangeListeners_ != null) {
            this.propertyChangeListeners_.firePropertyChange("command", string2, string3);
        }
        if (bl) {
            this.threadSafetyValue_ = THREADSAFE_LOOKUP;
            this.threadSafety_ = false;
        }
    }

    private static final String firstToken(String string) {
        String string2 = null;
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            string2 = stringTokenizer.nextToken();
        }
        catch (NoSuchElementException noSuchElementException) {
            string2 = "";
        }
        return string2;
    }

    public void setMessageOption(int n) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting message option:", n);
        }
        if (n < 0 || n > 2) {
            throw new ExtendedIllegalArgumentException("messageOption (" + n + ")", 2);
        }
        this.messageOption_ = n;
    }

    public void setSystem(AS400 aS400) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting system: " + aS400);
        }
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        if (this.impl_ != null) {
            Trace.log(2, "Cannot set property 'system' after connect.");
            throw new ExtendedIllegalStateException("system", 5);
        }
        AS400 aS4002 = this.system_;
        AS400 aS4003 = aS400;
        if (this.vetoableChangeListeners_ != null) {
            this.vetoableChangeListeners_.fireVetoableChange("system", aS4002, aS4003);
        }
        this.system_ = aS4003;
        if (this.propertyChangeListeners_ != null) {
            this.propertyChangeListeners_.firePropertyChange("system", aS4002, aS4003);
        }
    }

    public void setThreadSafe(boolean bl) {
        Boolean bl2;
        if (Trace.traceOn_) {
            Trace.log(1, "Setting thread safe: " + bl);
        }
        Boolean bl3 = bl2 = bl ? THREADSAFE_TRUE : THREADSAFE_FALSE;
        if (this.propertyChangeListeners_ != null) {
            Boolean bl4 = this.threadSafetyValue_;
            this.propertyChangeListeners_.firePropertyChange("threadSafe", bl4, bl2);
        }
        this.threadSafetyValue_ = bl2;
        this.threadSafety_ = bl;
        this.threadSafetyDetermined_ = 2;
        this.threadSafetyIsLookedUp_ = false;
    }

    public void setThreadSafe(Boolean bl) {
        Boolean bl2;
        if (Trace.traceOn_) {
            Trace.log(1, "Setting thread safe: " + bl);
        }
        if (bl.equals(THREADSAFE_TRUE)) {
            bl2 = THREADSAFE_TRUE;
            this.threadSafetyIsLookedUp_ = false;
        } else if (bl.equals(THREADSAFE_FALSE)) {
            bl2 = THREADSAFE_FALSE;
            this.threadSafetyIsLookedUp_ = false;
        } else {
            bl2 = THREADSAFE_LOOKUP;
            this.threadSafetyIsLookedUp_ = true;
        }
        if (this.propertyChangeListeners_ != null) {
            Boolean bl3 = this.threadSafetyValue_;
            this.propertyChangeListeners_.firePropertyChange("threadSafe", bl3, bl2);
        }
        this.threadSafetyValue_ = bl2;
        this.threadSafety_ = this.threadSafetyValue_ == THREADSAFE_TRUE;
        this.threadSafetyDetermined_ = 2;
    }

    public void suggestThreadsafe(boolean bl) {
        String string = CommandCall.getThreadSafetyProperty();
        if (string == null || string.equals("lookup")) {
            this.setThreadSafe((Boolean)bl);
        }
    }

    public String toString() {
        return "CommandCall (system: " + this.system_ + " command: " + this.command_ + "):" + super.toString();
    }

    static {
        if (Trace.traceOn_) {
            Trace.logLoadPath(CLASSNAME);
        }
        THREADSAFE_FALSE = Boolean.FALSE;
        THREADSAFE_TRUE = Boolean.TRUE;
        THREADSAFE_LOOKUP = null;
    }
}

