/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.IllegalPathNameException;
import com.ibm.as400.access.Trace;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.Serializable;
import java.util.EventListener;

public class QSYSObjectPathName
implements Serializable {
    static final long serialVersionUID = 4L;
    private String path_ = "";
    private String libraryName_ = "";
    private String objectName_ = "";
    private String memberName_ = "";
    private String objectType_ = "";
    private String aspName_ = "";
    private static QSYSObjectPathName verified_ = null;
    private transient PropertyChangeSupport propertyChangeListeners_ = null;
    private transient VetoableChangeSupport vetoableChangeListeners_ = null;

    public QSYSObjectPathName() {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing QSYSObjectPathName object.");
        }
    }

    public QSYSObjectPathName(String string) {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing QSYSObjectPathName object, path: " + string);
        }
        if (string == null) {
            Trace.log(2, "Parameter 'path' is null.");
            throw new NullPointerException("path");
        }
        this.parse(string);
    }

    QSYSObjectPathName(String string, String string2) {
        this(string);
        if (!this.objectType_.equals(string2.toUpperCase())) {
            Trace.log(2, "Object type is not valid, path: '" + string + "'");
            throw new IllegalPathNameException(string, 1);
        }
    }

    public QSYSObjectPathName(String string, String string2, String string3) {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing QSYSObjectPathName object, libraryName: " + string + " objectName: " + string2 + " objectType: " + string3);
        }
        QSYSObjectPathName.checkLibraryName(string);
        QSYSObjectPathName.checkObjectName(string2);
        QSYSObjectPathName.checkObjectType(string3);
        this.libraryName_ = QSYSObjectPathName.toQSYSName(string);
        this.objectName_ = QSYSObjectPathName.toQSYSName(string2);
        this.objectType_ = string3.toUpperCase();
        this.path_ = QSYSObjectPathName.buildPathName(this.libraryName_, this.objectName_, "", this.objectType_);
    }

    public QSYSObjectPathName(String string, String string2, String string3, String string4) {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing QSYSObjectPathName object, libraryName: " + string + " objectName: " + string2 + " memberName: " + string3 + " objectType: " + string4);
        }
        QSYSObjectPathName.checkLibraryName(string);
        QSYSObjectPathName.checkObjectName(string2);
        QSYSObjectPathName.checkMemberName(string3);
        QSYSObjectPathName.checkObjectTypeIsMember(string4);
        this.libraryName_ = QSYSObjectPathName.toQSYSName(string);
        this.objectName_ = QSYSObjectPathName.toQSYSName(string2);
        this.memberName_ = QSYSObjectPathName.toQSYSName(string3);
        this.objectType_ = "MBR";
        this.path_ = QSYSObjectPathName.buildPathName(this.libraryName_, this.objectName_, this.memberName_, this.objectType_);
    }

    public QSYSObjectPathName(String string, String string2, String string3, String string4, String string5) {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing QSYSObjectPathName object, libraryName: " + string2 + " objectName: " + string3 + " memberName: " + string4 + " objectType: " + string5);
        }
        QSYSObjectPathName.checkAspName(string);
        QSYSObjectPathName.checkLibraryName(string2);
        QSYSObjectPathName.checkObjectName(string3);
        QSYSObjectPathName.checkMemberName(string4);
        QSYSObjectPathName.checkObjectTypeIsMember(string5);
        this.libraryName_ = QSYSObjectPathName.toQSYSName(string2);
        this.objectName_ = QSYSObjectPathName.toQSYSName(string3);
        this.memberName_ = QSYSObjectPathName.toQSYSName(string4);
        this.objectType_ = "MBR";
        this.aspName_ = string;
        this.path_ = QSYSObjectPathName.buildPathName(this.aspName_, this.libraryName_, this.objectName_, this.memberName_, this.objectType_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Adding property change listener.");
        }
        QSYSObjectPathName.checkListener(propertyChangeListener);
        QSYSObjectPathName qSYSObjectPathName = this;
        synchronized (qSYSObjectPathName) {
            if (this.propertyChangeListeners_ == null) {
                this.propertyChangeListeners_ = new PropertyChangeSupport(this);
            }
            this.propertyChangeListeners_.addPropertyChangeListener(propertyChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Adding vetoable change listener.");
        }
        QSYSObjectPathName.checkListener(vetoableChangeListener);
        QSYSObjectPathName qSYSObjectPathName = this;
        synchronized (qSYSObjectPathName) {
            if (this.vetoableChangeListeners_ == null) {
                this.vetoableChangeListeners_ = new VetoableChangeSupport(this);
            }
            this.vetoableChangeListeners_.addVetoableChangeListener(vetoableChangeListener);
        }
    }

    private static String buildPathName(String string, String string2, String string3, String string4, String string5) {
        if (Trace.traceOn_) {
            Trace.log(1, "QSYSObjectPathName buildPathName(asp): aspName: " + string + " libraryName: " + string2 + " objectName: " + string3 + " memberName: " + string4 + " objectType: " + string5);
        }
        String string6 = QSYSObjectPathName.buildPathName(string2, string3, string4, string5);
        StringBuffer stringBuffer = new StringBuffer(75);
        if (!string6.equals("")) {
            if (!string.equals("")) {
                stringBuffer.append("/");
                stringBuffer.append(string);
            }
            stringBuffer.append(string6);
            if (Trace.traceOn_) {
                Trace.log(1, "QSYSObjectPathName buildPathName(asp): result: " + stringBuffer.toString());
            }
            return stringBuffer.toString();
        }
        if (Trace.traceOn_) {
            Trace.log(1, "QSYSObjectPathName buildPathName(asp): result: EMPTY STRING");
        }
        return "";
    }

    private static String buildPathName(String string, String string2, String string3, String string4) {
        if (Trace.traceOn_) {
            Trace.log(1, "QSYSObjectPathName buildPathName(): libraryName: " + string + " objectName: " + string2 + " memberName: " + string3 + " objectType: " + string4);
        }
        if (!(string.equals("") || string4.equals("") || string3.equals("") && string4.equals("MBR"))) {
            StringBuffer stringBuffer = new StringBuffer(64);
            stringBuffer.append("/QSYS.LIB");
            if (!string.equals("QSYS")) {
                stringBuffer.append("/");
                stringBuffer.append(QSYSObjectPathName.convertLibraryName(string));
                stringBuffer.append(".LIB");
            }
            if (!string2.equals("")) {
                stringBuffer.append("/");
                stringBuffer.append(QSYSObjectPathName.convertObjectName(string2));
                if (!string3.equals("")) {
                    stringBuffer.append(".FILE/");
                    stringBuffer.append(QSYSObjectPathName.convertMemberName(string3));
                    stringBuffer.append(".MBR");
                } else {
                    stringBuffer.append(".");
                    stringBuffer.append(string4);
                }
            }
            if (Trace.traceOn_) {
                Trace.log(1, "QSYSObjectPathName buildPathName(): result: " + stringBuffer.toString());
            }
            return stringBuffer.toString();
        }
        if (Trace.traceOn_) {
            Trace.log(1, "QSYSObjectPathName buildPathName(): result: EMPTY STRING");
        }
        return "";
    }

    static void checkObjectTypeIsMember(String string) {
        if (string == null) {
            Trace.log(2, "Parameter 'objectType' is null.");
            throw new NullPointerException("objectType");
        }
        if (!string.toUpperCase().equals("MBR")) {
            Trace.log(2, "Value of parameter 'objectType' is not valid: " + string);
            throw new ExtendedIllegalArgumentException("objectType (" + string + ")", 2);
        }
    }

    static void checkMemberName(String string) {
        if (string == null) {
            Trace.log(2, "Parameter 'memberName' is null.");
            throw new NullPointerException("memberName");
        }
        if (string.length() < 1 || string.length() > 10) {
            Trace.log(2, "Length of parameter 'memberName' is not valid: '" + string + "'");
            throw new ExtendedIllegalArgumentException("memberName (" + string + ")", 1);
        }
    }

    static void checkListener(EventListener eventListener) {
        if (eventListener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
    }

    static void checkAspName(String string) {
        if (string == null) {
            Trace.log(2, "Parameter 'aspName' is null.");
            throw new NullPointerException("aspName");
        }
        if (string.length() < 1 || string.length() > 10) {
            Trace.log(2, "Length of parameter 'aspName' is not valid: '" + string + "'");
            throw new ExtendedIllegalArgumentException("aspName (" + string + ")", 1);
        }
    }

    static void checkLibraryName(String string) {
        if (string == null) {
            Trace.log(2, "Parameter 'libraryName' is null.");
            throw new NullPointerException("libraryName");
        }
        if (string.length() < 1 || string.length() > 10) {
            Trace.log(2, "Length of parameter 'libraryName' is not valid: '" + string + "'");
            throw new ExtendedIllegalArgumentException("libraryName (" + string + ")", 1);
        }
    }

    static void checkObjectName(String string) {
        if (string == null) {
            Trace.log(2, "Parameter 'objectName' is null.");
            throw new NullPointerException("objectName");
        }
        if (string.length() < 1 || string.length() > 10) {
            Trace.log(2, "Length of parameter 'objectName' is not valid: '" + string + "'");
            throw new ExtendedIllegalArgumentException("objectName (" + string + ")", 1);
        }
    }

    static void checkObjectType(String string) {
        if (string == null) {
            Trace.log(2, "Parameter 'objectType' is null.");
            throw new NullPointerException("objectType");
        }
        if (string.length() < 1 || string.length() > 6) {
            Trace.log(2, "Length of parameter 'objectType' is not valid: '" + string + "'");
            throw new ExtendedIllegalArgumentException("objectType (" + string + ")", 1);
        }
    }

    private static String convertLibraryName(String string) {
        if (string.equals("*LIBL")) {
            return "%LIBL%";
        }
        if (string.equals("*CURLIB")) {
            return "%CURLIB%";
        }
        if (string.equals("*USRLIBL")) {
            return "%USRLIBL%";
        }
        if (string.equals("*ALL")) {
            return "%ALL%";
        }
        if (string.equals("*ALLUSR")) {
            return "%ALLUSR%";
        }
        return string;
    }

    private static String convertMemberName(String string) {
        if (string.equals("*FIRST")) {
            return "%FIRST%";
        }
        if (string.equals("*LAST")) {
            return "%LAST%";
        }
        if (string.equals("*FILE")) {
            return "%FILE%";
        }
        if (string.equals("*ALL")) {
            return "%ALL%";
        }
        if (string.equals("*NONE")) {
            return "%NONE%";
        }
        return string;
    }

    private static String convertObjectName(String string) {
        if (string.equals("*ALL")) {
            return "%ALL%";
        }
        return string;
    }

    public String getAspName() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting ASP name: " + this.aspName_);
        }
        return this.aspName_;
    }

    public String getLibraryName() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting library name: " + this.libraryName_);
        }
        return this.libraryName_;
    }

    public String getMemberName() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting member name: " + this.memberName_);
        }
        return this.memberName_;
    }

    public String getObjectName() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting object name: " + this.objectName_);
        }
        return this.objectName_;
    }

    public String getObjectType() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting object type: " + this.objectType_);
        }
        return this.objectType_;
    }

    public String getPath() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting path: " + this.path_);
        }
        return this.path_;
    }

    private void parse(String string) {
        int n;
        String string2 = QSYSObjectPathName.toQSYSName(string);
        int n2 = string2.indexOf("/QSYS.LIB");
        if (n2 == -1) {
            Trace.log(2, "Specified path does not include '/QSYS.LIB':", string);
            throw new IllegalPathNameException(string, 6);
        }
        if (n2 > 0) {
            this.aspName_ = string2.substring(1, n2);
        }
        if (string2.substring(n2).equals("/QSYS.LIB") || string2.substring(n2).equals("/QSYS.LIB/")) {
            this.libraryName_ = "QSYS";
            this.objectType_ = "LIB";
            this.path_ = QSYSObjectPathName.buildPathName(this.aspName_, this.libraryName_, this.objectName_, this.memberName_, this.objectType_);
            return;
        }
        int n3 = 10;
        if (!this.aspName_.equals("")) {
            n3 = n3 + 1 + this.aspName_.length();
        }
        if ((n = string2.indexOf(".LIB/", n3)) > n3) {
            this.libraryName_ = QSYSObjectPathName.toQSYSName(string.substring(n3, n));
            if (this.libraryName_.equals("QSYS")) {
                Trace.log(2, "Object in library QSYS specified incorrectly, path: '" + string + "'");
                throw new IllegalPathNameException(string, 7);
            }
            if (this.libraryName_.charAt(0) == '%') {
                if (this.libraryName_.equals("%LIBL%")) {
                    this.libraryName_ = "*LIBL";
                } else if (this.libraryName_.equals("%CURLIB%")) {
                    this.libraryName_ = "*CURLIB";
                } else if (this.libraryName_.equals("%USRLIBL%")) {
                    this.libraryName_ = "*USRLIBL";
                } else if (this.libraryName_.equals("%ALL%")) {
                    this.libraryName_ = "*ALL";
                } else if (this.libraryName_.equals("%ALLUSR%")) {
                    this.libraryName_ = "*ALLUSR";
                }
            }
            n3 = n + 5;
        } else if (n == -1) {
            this.libraryName_ = "QSYS";
        } else {
            Trace.log(2, "Length of the library name is not valid, path: '" + string + "'");
            throw new IllegalPathNameException(string, 2);
        }
        if (this.libraryName_.length() > 10) {
            Trace.log(2, "Length of the library name is not valid, path: '" + string + "'");
            throw new IllegalPathNameException(string, 2);
        }
        n = string2.lastIndexOf(46);
        if (n < n3 || string2.length() - n - 1 > 6) {
            Trace.log(2, "Length of the object type is not valid, path: '" + string + "'");
            throw new IllegalPathNameException(string, 5);
        }
        this.objectType_ = string2.substring(n + 1);
        if (this.objectType_.equals("MBR")) {
            int n4 = string2.lastIndexOf(".FILE/", n);
            if (n4 == -1 || n4 < n3) {
                Trace.log(2, "Member is not contained in a file, path: '" + string + "'");
                throw new IllegalPathNameException(string, 8);
            }
            if (n < (n4 += 6) || n - n4 > 10) {
                Trace.log(2, "Length of the member name is not valid, path: '" + string + "'");
                throw new IllegalPathNameException(string, 4);
            }
            this.memberName_ = QSYSObjectPathName.toQSYSName(string.substring(n4, n));
            if (this.memberName_.charAt(0) == '%') {
                if (this.memberName_.equals("%FIRST%")) {
                    this.memberName_ = "*FIRST";
                } else if (this.memberName_.equals("%LAST%")) {
                    this.memberName_ = "*LAST";
                } else if (this.memberName_.equals("%FILE%")) {
                    this.memberName_ = "*FILE";
                } else if (this.memberName_.equals("%ALL%")) {
                    this.memberName_ = "*ALL";
                } else if (this.memberName_.equals("%NONE%")) {
                    this.memberName_ = "*NONE";
                }
            }
            n = n4 - 6;
        }
        if (this.libraryName_.equals("QSYS") && string2.substring(n3, n).indexOf(47) != -1 && string2.charAt(n3) != '\"') {
            Trace.log(2, "Library not specified correctly, path: '" + string + "'");
            throw new IllegalPathNameException(string, 9);
        }
        if (n < n3 || n - n3 > 10) {
            Trace.log(2, "Length of the object name is not valid, path: '" + string + "'");
            throw new IllegalPathNameException(string, 3);
        }
        this.objectName_ = QSYSObjectPathName.toQSYSName(string.substring(n3, n));
        if (this.objectName_.equals("%ALL%")) {
            this.objectName_ = "*ALL";
        }
        this.path_ = QSYSObjectPathName.buildPathName(this.aspName_, this.libraryName_, this.objectName_, this.memberName_, this.objectType_);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Removing property change listener.");
        }
        QSYSObjectPathName.checkListener(propertyChangeListener);
        if (this.propertyChangeListeners_ != null) {
            this.propertyChangeListeners_.removePropertyChangeListener(propertyChangeListener);
        }
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Removing vetoable change listener.");
        }
        QSYSObjectPathName.checkListener(vetoableChangeListener);
        if (this.vetoableChangeListeners_ != null) {
            this.vetoableChangeListeners_.removeVetoableChangeListener(vetoableChangeListener);
        }
    }

    public void setAspName(String string) throws PropertyVetoException {
        QSYSObjectPathName.checkAspName(string);
        String string2 = QSYSObjectPathName.toQSYSName(string);
        String string3 = QSYSObjectPathName.buildPathName(string2, this.libraryName_, this.objectName_, this.memberName_, this.objectType_);
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            this.aspName_ = string2;
            this.path_ = string3;
        } else {
            String string4 = this.aspName_;
            String string5 = this.path_;
            if (this.vetoableChangeListeners_ != null) {
                this.vetoableChangeListeners_.fireVetoableChange("aspName", string4, string2);
                this.vetoableChangeListeners_.fireVetoableChange("path", string5, string3);
            }
            this.aspName_ = string2;
            this.path_ = string3;
            if (this.propertyChangeListeners_ != null) {
                this.propertyChangeListeners_.firePropertyChange("aspName", string4, string2);
                this.propertyChangeListeners_.firePropertyChange("path", string5, string3);
            }
        }
    }

    public void setLibraryName(String string) throws PropertyVetoException {
        QSYSObjectPathName.checkLibraryName(string);
        String string2 = QSYSObjectPathName.toQSYSName(string);
        String string3 = QSYSObjectPathName.buildPathName(string2, this.objectName_, this.memberName_, this.objectType_);
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            this.libraryName_ = string2;
            this.path_ = string3;
        } else {
            String string4 = this.libraryName_;
            String string5 = this.path_;
            if (this.vetoableChangeListeners_ != null) {
                this.vetoableChangeListeners_.fireVetoableChange("libraryName", string4, string2);
                this.vetoableChangeListeners_.fireVetoableChange("path", string5, string3);
            }
            this.libraryName_ = string2;
            this.path_ = string3;
            if (this.propertyChangeListeners_ != null) {
                this.propertyChangeListeners_.firePropertyChange("libraryName", string4, string2);
                this.propertyChangeListeners_.firePropertyChange("path", string5, string3);
            }
        }
    }

    public void setMemberName(String string) throws PropertyVetoException {
        if (string == null) {
            Trace.log(2, "Parameter 'memberName' is null.");
            throw new NullPointerException("memberName");
        }
        if (string.length() > 10) {
            Trace.log(2, "Length of parameter 'memberName' is not valid: '" + string + "'");
            throw new ExtendedIllegalArgumentException("memberName (" + string + ")", 1);
        }
        String string2 = QSYSObjectPathName.toQSYSName(string);
        String string3 = string.length() != 0 ? "MBR" : this.objectType_;
        String string4 = QSYSObjectPathName.buildPathName(this.libraryName_, this.objectName_, string2, string3);
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            this.memberName_ = string2;
            this.objectType_ = string3;
            this.path_ = string4;
        } else {
            String string5 = this.memberName_;
            String string6 = this.objectType_;
            String string7 = this.path_;
            if (this.vetoableChangeListeners_ != null) {
                this.vetoableChangeListeners_.fireVetoableChange("memberName", string5, string2);
                this.vetoableChangeListeners_.fireVetoableChange("objectType", string6, string3);
                this.vetoableChangeListeners_.fireVetoableChange("path", string7, string4);
            }
            this.memberName_ = string2;
            this.objectType_ = string3;
            this.path_ = string4;
            if (this.propertyChangeListeners_ != null) {
                this.propertyChangeListeners_.firePropertyChange("memberName", string5, string2);
                this.propertyChangeListeners_.firePropertyChange("objectType", string6, string3);
                this.propertyChangeListeners_.firePropertyChange("path", string7, string4);
            }
        }
    }

    public void setObjectName(String string) throws PropertyVetoException {
        QSYSObjectPathName.checkObjectName(string);
        String string2 = QSYSObjectPathName.toQSYSName(string);
        String string3 = QSYSObjectPathName.buildPathName(this.libraryName_, string2, this.memberName_, this.objectType_);
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            this.objectName_ = string2;
            this.path_ = string3;
        } else {
            String string4 = this.objectName_;
            String string5 = this.path_;
            if (this.vetoableChangeListeners_ != null) {
                this.vetoableChangeListeners_.fireVetoableChange("objectName", string4, string2);
                this.vetoableChangeListeners_.fireVetoableChange("path", string5, string3);
            }
            this.objectName_ = string2;
            this.path_ = string3;
            if (this.propertyChangeListeners_ != null) {
                this.propertyChangeListeners_.firePropertyChange("objectName", string4, string2);
                this.propertyChangeListeners_.firePropertyChange("path", string5, string3);
            }
        }
    }

    public void setObjectType(String string) throws PropertyVetoException {
        QSYSObjectPathName.checkObjectType(string);
        String string2 = string.toUpperCase();
        String string3 = string2.equals("MBR") ? this.memberName_ : "";
        String string4 = QSYSObjectPathName.buildPathName(this.libraryName_, this.objectName_, string3, string2);
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            this.memberName_ = string3;
            this.objectType_ = string2;
            this.path_ = string4;
        } else {
            String string5 = this.memberName_;
            String string6 = this.objectType_;
            String string7 = this.path_;
            if (this.vetoableChangeListeners_ != null) {
                this.vetoableChangeListeners_.fireVetoableChange("memberName", string5, string3);
                this.vetoableChangeListeners_.fireVetoableChange("objectType", string6, string2);
                this.vetoableChangeListeners_.fireVetoableChange("path", string7, string4);
            }
            this.objectType_ = string2;
            this.memberName_ = string3;
            this.path_ = string4;
            if (this.propertyChangeListeners_ != null) {
                this.propertyChangeListeners_.firePropertyChange("memberName", string5, string3);
                this.propertyChangeListeners_.firePropertyChange("objectType", string6, string2);
                this.propertyChangeListeners_.firePropertyChange("path", string7, string4);
            }
        }
    }

    public void setPath(String string) throws PropertyVetoException {
        QSYSObjectPathName qSYSObjectPathName = new QSYSObjectPathName(string);
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            this.path_ = qSYSObjectPathName.path_;
            this.libraryName_ = qSYSObjectPathName.libraryName_;
            this.objectName_ = qSYSObjectPathName.objectName_;
            this.memberName_ = qSYSObjectPathName.memberName_;
            this.objectType_ = qSYSObjectPathName.objectType_;
        } else {
            String string2 = qSYSObjectPathName.path_;
            String string3 = qSYSObjectPathName.libraryName_;
            String string4 = qSYSObjectPathName.objectName_;
            String string5 = qSYSObjectPathName.memberName_;
            String string6 = qSYSObjectPathName.objectType_;
            String string7 = this.path_;
            String string8 = this.libraryName_;
            String string9 = this.objectName_;
            String string10 = this.memberName_;
            String string11 = this.objectType_;
            if (this.vetoableChangeListeners_ != null) {
                this.vetoableChangeListeners_.fireVetoableChange("path", string7, string2);
                this.vetoableChangeListeners_.fireVetoableChange("libraryName", string8, string3);
                this.vetoableChangeListeners_.fireVetoableChange("objectName", string9, string4);
                this.vetoableChangeListeners_.fireVetoableChange("memberName", string10, string5);
                this.vetoableChangeListeners_.fireVetoableChange("objectType", string11, string6);
            }
            this.path_ = string2;
            this.libraryName_ = string3;
            this.objectName_ = string4;
            this.memberName_ = string5;
            this.objectType_ = string6;
            if (this.propertyChangeListeners_ != null) {
                this.propertyChangeListeners_.firePropertyChange("path", string7, string2);
                this.propertyChangeListeners_.firePropertyChange("libraryName", string8, string3);
                this.propertyChangeListeners_.firePropertyChange("objectName", string9, string4);
                this.propertyChangeListeners_.firePropertyChange("memberName", string10, string5);
                this.propertyChangeListeners_.firePropertyChange("objectType", string11, string6);
            }
        }
    }

    public static String toPath(String string, String string2, String string3) {
        QSYSObjectPathName.checkLibraryName(string);
        QSYSObjectPathName.checkObjectName(string2);
        QSYSObjectPathName.checkObjectType(string3);
        string = QSYSObjectPathName.toQSYSName(string);
        string2 = QSYSObjectPathName.toQSYSName(string2);
        string3 = string3.toUpperCase();
        return QSYSObjectPathName.buildPathName(string, string2, "", string3);
    }

    public static String toPath(String string, String string2, String string3, String string4) {
        QSYSObjectPathName.checkLibraryName(string);
        QSYSObjectPathName.checkObjectName(string2);
        QSYSObjectPathName.checkMemberName(string3);
        QSYSObjectPathName.checkObjectTypeIsMember(string4);
        string = QSYSObjectPathName.toQSYSName(string);
        string2 = QSYSObjectPathName.toQSYSName(string2);
        string3 = QSYSObjectPathName.toQSYSName(string3);
        string4 = string4.toUpperCase();
        return QSYSObjectPathName.buildPathName(string, string2, string3, string4);
    }

    public static String toPath(String string, String string2, String string3, String string4, String string5) {
        QSYSObjectPathName.checkAspName(string);
        QSYSObjectPathName.checkLibraryName(string2);
        QSYSObjectPathName.checkObjectName(string3);
        QSYSObjectPathName.checkMemberName(string4);
        QSYSObjectPathName.checkObjectTypeIsMember(string5);
        string2 = QSYSObjectPathName.toQSYSName(string2);
        string3 = QSYSObjectPathName.toQSYSName(string3);
        string4 = QSYSObjectPathName.toQSYSName(string4);
        string5 = string5.toUpperCase();
        string = string.toUpperCase();
        return QSYSObjectPathName.buildPathName(string, string2, string3, string4, string5);
    }

    public static final String toQSYSName(String string) {
        if (string.indexOf(224) == -1 && string.indexOf(34) == -1) {
            return string.toUpperCase();
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '\"') {
                boolean bl2 = bl = !bl;
            }
            if (!bl && c != '\u00e0') {
                stringBuffer.append(Character.toUpperCase(c));
                continue;
            }
            stringBuffer.append(string.charAt(i));
        }
        return stringBuffer.toString();
    }

    public String toQualifiedObjectName() {
        StringBuffer stringBuffer = new StringBuffer("                    ");
        if (this.objectName_.length() > 10) {
            if (Trace.traceOn_) {
                Trace.log(4, "Truncating object name to 10 characters:", this.objectName_);
            }
            stringBuffer.replace(0, 10, this.objectName_.substring(0, 10));
        } else {
            stringBuffer.replace(0, this.objectName_.length(), this.objectName_);
        }
        if (this.libraryName_.length() > 10) {
            if (Trace.traceOn_) {
                Trace.log(4, "Truncating library name to 10 characters:", this.libraryName_);
            }
            stringBuffer.replace(10, 20, this.libraryName_.substring(0, 10));
        } else {
            stringBuffer.replace(10, this.libraryName_.length() + 10, this.libraryName_);
        }
        return stringBuffer.toString();
    }

    static final void validatePath(String string, String string2) {
        verified_ = new QSYSObjectPathName(string, string2);
    }
}

