/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400JDBCClob;
import com.ibm.as400.access.AS400JDBCDriver;
import com.ibm.as400.access.AS400PackedDecimal;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDProperties;
import com.ibm.as400.access.JDUtilities;
import com.ibm.as400.access.SQLConversionSettings;
import com.ibm.as400.access.SQLData;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

final class SQLDecimal2
implements SQLData {
    private static final String copyright = "Copyright (C) 1997-2003 International Business Machines Corporation and others.";
    private SQLConversionSettings settings_;
    private int precision_;
    private int scale_;
    private AS400PackedDecimal typeConverter_;
    private double value_;
    private int truncated_;
    private JDProperties properties_;
    private int vrm_;

    SQLDecimal2(int n, int n2, SQLConversionSettings sQLConversionSettings, int n3, JDProperties jDProperties) {
        this.settings_ = sQLConversionSettings;
        this.precision_ = n;
        this.scale_ = n2;
        this.typeConverter_ = new AS400PackedDecimal(this.precision_, this.scale_);
        this.value_ = 0.0;
        this.truncated_ = 0;
        this.vrm_ = n3;
        this.properties_ = jDProperties;
    }

    public Object clone() {
        return new SQLDecimal2(this.precision_, this.scale_, this.settings_, this.vrm_, this.properties_);
    }

    public void convertFromRawBytes(byte[] byArray, int n, ConvTable convTable) throws SQLException {
        this.value_ = this.typeConverter_.toDouble(byArray, n);
    }

    public void convertToRawBytes(byte[] byArray, int n, ConvTable convTable) throws SQLException {
        this.typeConverter_.toBytes(this.value_, byArray, n);
    }

    public void set(Object object, Calendar calendar, int n) throws SQLException {
        if (object instanceof String) {
            try {
                this.value_ = Double.valueOf((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                JDError.throwSQLException((Object)this, "07006", numberFormatException);
            }
        } else if (object instanceof Number) {
            this.value_ = ((Number)object).doubleValue();
        } else if (object instanceof Boolean) {
            this.value_ = (Boolean)object != false ? 1.0 : 0.0;
        } else {
            JDError.throwSQLException(this, "07006");
        }
    }

    public int getSQLType() {
        return 14;
    }

    public String getCreateParameters() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(AS400JDBCDriver.getResource("PRECISION"));
        stringBuffer.append(",");
        stringBuffer.append(AS400JDBCDriver.getResource("SCALE"));
        return stringBuffer.toString();
    }

    public int getDisplaySize() {
        return this.precision_ + 2;
    }

    public String getJavaClassName() {
        return "java.math.BigDecimal";
    }

    public String getLiteralPrefix() {
        return null;
    }

    public String getLiteralSuffix() {
        return null;
    }

    public String getLocalName() {
        return "DECIMAL";
    }

    public int getMaximumPrecision() {
        if (this.vrm_ >= JDUtilities.vrm530) {
            return this.properties_.getInt(53);
        }
        return 31;
    }

    public int getMaximumScale() {
        if (this.vrm_ >= JDUtilities.vrm530) {
            return this.properties_.getInt(54);
        }
        return 31;
    }

    public int getMinimumScale() {
        return 0;
    }

    public int getNativeType() {
        return 484;
    }

    public int getPrecision() {
        return this.precision_;
    }

    public int getRadix() {
        return 10;
    }

    public int getScale() {
        return this.scale_;
    }

    public int getType() {
        return 3;
    }

    public String getTypeName() {
        return "DECIMAL";
    }

    public boolean isSigned() {
        return true;
    }

    public boolean isText() {
        return false;
    }

    public int getActualSize() {
        return this.precision_;
    }

    public int getTruncated() {
        return this.truncated_;
    }

    public InputStream getAsciiStream() throws SQLException {
        this.truncated_ = 0;
        try {
            return new ByteArrayInputStream(ConvTable.getTable(819, null).stringToByteArray(this.getString()));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            JDError.throwSQLException((Object)this, "HY000", unsupportedEncodingException);
            return null;
        }
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        this.truncated_ = 0;
        return new BigDecimal(this.value_);
    }

    public InputStream getBinaryStream() throws SQLException {
        JDError.throwSQLException(this, "07006");
        return null;
    }

    public Blob getBlob() throws SQLException {
        JDError.throwSQLException(this, "07006");
        return null;
    }

    public boolean getBoolean() throws SQLException {
        this.truncated_ = 0;
        return this.value_ != 0.0;
    }

    public byte getByte() throws SQLException {
        this.truncated_ = 0;
        if (this.value_ > 127.0 || this.value_ < -128.0) {
            this.truncated_ = this.value_ > 32767.0 || this.value_ < -32768.0 ? (this.value_ > 2.147483647E9 || this.value_ < -2.147483648E9 ? 7 : 3) : 1;
        }
        return (byte)this.value_;
    }

    public byte[] getBytes() throws SQLException {
        JDError.throwSQLException(this, "07006");
        return null;
    }

    public Reader getCharacterStream() throws SQLException {
        this.truncated_ = 0;
        return new StringReader(this.getString());
    }

    public Clob getClob() throws SQLException {
        this.truncated_ = 0;
        String string = this.getString();
        return new AS400JDBCClob(string, string.length());
    }

    public Date getDate(Calendar calendar) throws SQLException {
        JDError.throwSQLException(this, "07006");
        return null;
    }

    public double getDouble() throws SQLException {
        this.truncated_ = 0;
        return this.value_;
    }

    public float getFloat() throws SQLException {
        this.truncated_ = 0;
        if (this.value_ > 3.4028234663852886E38 || this.value_ < -3.4028234663852886E38) {
            this.truncated_ = 4;
        }
        return (float)this.value_;
    }

    public int getInt() throws SQLException {
        this.truncated_ = 0;
        if (this.value_ > 2.147483647E9 || this.value_ < -2.147483648E9) {
            this.truncated_ = 4;
        }
        return (int)this.value_;
    }

    public long getLong() throws SQLException {
        this.truncated_ = 0;
        if (this.value_ > 9.223372036854776E18 || this.value_ < -9.223372036854776E18) {
            this.truncated_ = 1;
        }
        return (long)this.value_;
    }

    public Object getObject() throws SQLException {
        this.truncated_ = 0;
        return new Double(this.value_);
    }

    public short getShort() throws SQLException {
        this.truncated_ = 0;
        if (this.value_ > 32767.0 || this.value_ < -32768.0) {
            this.truncated_ = this.value_ > 2.147483647E9 || this.value_ < -2.147483648E9 ? 6 : 2;
        }
        return (short)this.value_;
    }

    public String getString() throws SQLException {
        this.truncated_ = 0;
        String string = Double.toString(this.value_);
        int n = string.indexOf(46);
        if (n == -1) {
            return string;
        }
        return string.substring(0, n) + this.settings_.getDecimalSeparator() + string.substring(n + 1);
    }

    public Time getTime(Calendar calendar) throws SQLException {
        JDError.throwSQLException(this, "07006");
        return null;
    }

    public Timestamp getTimestamp(Calendar calendar) throws SQLException {
        JDError.throwSQLException(this, "07006");
        return null;
    }

    public InputStream getUnicodeStream() throws SQLException {
        this.truncated_ = 0;
        try {
            return new ByteArrayInputStream(ConvTable.getTable(13488, null).stringToByteArray(this.getString()));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            JDError.throwSQLException((Object)this, "HY000", unsupportedEncodingException);
            return null;
        }
    }

    public Array getArray() throws SQLException {
        JDError.throwSQLException(this, "07006");
        return null;
    }
}

