/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.SQLConversionSettings;
import com.ibm.as400.access.SQLData;
import com.ibm.as400.access.SQLDataFactory;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

final class SQLReal
implements SQLData {
    private static final String copyright = "Copyright (C) 1997-2003 International Business Machines Corporation and others.";
    private SQLConversionSettings settings_;
    private int truncated_;
    private float value_;

    SQLReal(SQLConversionSettings sQLConversionSettings) {
        this.settings_ = sQLConversionSettings;
        this.truncated_ = 0;
        this.value_ = 0.0f;
    }

    public Object clone() {
        return new SQLReal(this.settings_);
    }

    public void convertFromRawBytes(byte[] byArray, int n, ConvTable convTable) throws SQLException {
        this.value_ = BinaryConverter.byteArrayToFloat(byArray, n);
    }

    public void convertToRawBytes(byte[] byArray, int n, ConvTable convTable) throws SQLException {
        BinaryConverter.floatToByteArray(this.value_, byArray, n);
    }

    public void set(Object object, Calendar calendar, int n) throws SQLException {
        this.truncated_ = 0;
        if (object instanceof String) {
            try {
                this.value_ = Float.valueOf((String)object).floatValue();
            }
            catch (NumberFormatException numberFormatException) {
                JDError.throwSQLException(this, "07006");
            }
        } else if (object instanceof Number) {
            this.value_ = ((Number)object).floatValue();
        } else if (object instanceof Boolean) {
            this.value_ = (Boolean)object == true ? 1.0f : 0.0f;
        } else {
            JDError.throwSQLException(this, "07006");
        }
    }

    public int getSQLType() {
        return 24;
    }

    public String getCreateParameters() {
        return null;
    }

    public int getDisplaySize() {
        return 13;
    }

    public String getJavaClassName() {
        return "java.lang.Float";
    }

    public String getLiteralPrefix() {
        return null;
    }

    public String getLiteralSuffix() {
        return null;
    }

    public String getLocalName() {
        return "REAL";
    }

    public int getMaximumPrecision() {
        return 24;
    }

    public int getMaximumScale() {
        return 0;
    }

    public int getMinimumScale() {
        return 0;
    }

    public int getNativeType() {
        return 480;
    }

    public int getPrecision() {
        return 24;
    }

    public int getRadix() {
        return 2;
    }

    public int getScale() {
        return 0;
    }

    public int getType() {
        return 7;
    }

    public String getTypeName() {
        return "REAL";
    }

    public boolean isSigned() {
        return true;
    }

    public boolean isText() {
        return false;
    }

    public int getActualSize() {
        return SQLDataFactory.getPrecision(Float.toString(this.value_));
    }

    public int getTruncated() {
        return this.truncated_;
    }

    public InputStream getAsciiStream() throws SQLException {
        JDError.throwSQLException(this, "07006");
        return null;
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        this.truncated_ = 0;
        BigDecimal bigDecimal = null;
        String string = Float.toString(this.value_);
        int n2 = string.indexOf("E");
        if (n2 == -1) {
            bigDecimal = new BigDecimal(string);
        } else {
            String string2 = string.substring(0, n2);
            int n3 = Integer.parseInt(string.substring(n2 + 1));
            bigDecimal = new BigDecimal(string2);
            bigDecimal = bigDecimal.movePointRight(n3);
        }
        if (n >= 0) {
            if (n >= bigDecimal.scale()) {
                this.truncated_ = 0;
                return bigDecimal.setScale(n);
            }
            this.truncated_ = bigDecimal.scale() - n;
            return bigDecimal.setScale(n, 4);
        }
        return bigDecimal;
    }

    public InputStream getBinaryStream() throws SQLException {
        JDError.throwSQLException(this, "07006");
        return null;
    }

    public Blob getBlob() throws SQLException {
        JDError.throwSQLException(this, "07006");
        return null;
    }

    public boolean getBoolean() throws SQLException {
        this.truncated_ = 0;
        return this.value_ != 0.0f;
    }

    public byte getByte() throws SQLException {
        this.truncated_ = 0;
        if (this.value_ > 127.0f || this.value_ < -128.0f) {
            this.truncated_ = this.value_ > 32767.0f || this.value_ < -32768.0f ? 3 : 1;
        }
        return (byte)this.value_;
    }

    public byte[] getBytes() throws SQLException {
        JDError.throwSQLException(this, "07006");
        return null;
    }

    public Reader getCharacterStream() throws SQLException {
        JDError.throwSQLException(this, "07006");
        return null;
    }

    public Clob getClob() throws SQLException {
        JDError.throwSQLException(this, "07006");
        return null;
    }

    public Date getDate(Calendar calendar) throws SQLException {
        JDError.throwSQLException(this, "07006");
        return null;
    }

    public double getDouble() throws SQLException {
        this.truncated_ = 0;
        return this.value_;
    }

    public float getFloat() throws SQLException {
        this.truncated_ = 0;
        return this.value_;
    }

    public int getInt() throws SQLException {
        this.truncated_ = 0;
        if (this.value_ > 2.1474836E9f || this.value_ < -2.1474836E9f) {
            this.truncated_ = 4;
        }
        return (int)this.value_;
    }

    public long getLong() throws SQLException {
        this.truncated_ = 0;
        if (this.value_ > 9.223372E18f || this.value_ < -9.223372E18f) {
            this.truncated_ = 8;
        }
        return (long)this.value_;
    }

    public Object getObject() throws SQLException {
        this.truncated_ = 0;
        return new Float(this.value_);
    }

    public short getShort() throws SQLException {
        this.truncated_ = 0;
        if (this.value_ > 32767.0f || this.value_ < -32768.0f) {
            this.truncated_ = 2;
        }
        return (short)this.value_;
    }

    public String getString() throws SQLException {
        this.truncated_ = 0;
        String string = Float.toString(this.value_);
        int n = string.indexOf(46);
        if (n == -1) {
            return string;
        }
        return string.substring(0, n) + this.settings_.getDecimalSeparator() + string.substring(n + 1);
    }

    public Time getTime(Calendar calendar) throws SQLException {
        JDError.throwSQLException(this, "07006");
        return null;
    }

    public Timestamp getTimestamp(Calendar calendar) throws SQLException {
        JDError.throwSQLException(this, "07006");
        return null;
    }

    public InputStream getUnicodeStream() throws SQLException {
        JDError.throwSQLException(this, "07006");
        return null;
    }

    public Array getArray() throws SQLException {
        JDError.throwSQLException(this, "07006");
        return null;
    }
}

