/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400JDBCBlob;
import com.ibm.as400.access.AS400JDBCBlobLocator;
import com.ibm.as400.access.AS400JDBCClob;
import com.ibm.as400.access.AS400JDBCClobLocator;
import com.ibm.as400.access.AS400JDBCConnection;
import com.ibm.as400.access.AS400JDBCDriver;
import com.ibm.as400.access.AS400JDBCInputStream;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.ConvTableReader;
import com.ibm.as400.access.DBLobData;
import com.ibm.as400.access.ExtendedIOException;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDLobLocator;
import com.ibm.as400.access.JDUtilities;
import com.ibm.as400.access.ReaderInputStream;
import com.ibm.as400.access.SQLConversionSettings;
import com.ibm.as400.access.SQLLocator;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

final class SQLXMLLocator
implements SQLLocator {
    private static final String copyright = "Copyright (C) 1997-2006 International Business Machines Corporation and others.";
    private AS400JDBCConnection connection_;
    private ConvTable converter_;
    private ConvTable unicodeConverter_;
    private ConvTable unicodeUtf8Converter_;
    private int id_;
    private JDLobLocator locator_;
    private int maxLength_;
    private SQLConversionSettings settings_;
    private int truncated_;
    private int columnIndex_;
    private byte[] valueBlob_;
    private String valueClob_;
    private Object savedObject_;
    private int scale_;
    private int xmlType_;

    SQLXMLLocator(AS400JDBCConnection aS400JDBCConnection, int n, int n2, SQLConversionSettings sQLConversionSettings, ConvTable convTable, int n3, int n4) {
        this.connection_ = aS400JDBCConnection;
        n2 = 0x7FFFFFFE;
        this.id_ = n;
        this.locator_ = n4 == 1 ? new JDLobLocator(aS400JDBCConnection, n, n2, false) : new JDLobLocator(aS400JDBCConnection, n, n2, false);
        this.maxLength_ = n2;
        this.settings_ = sQLConversionSettings;
        this.truncated_ = 0;
        this.converter_ = convTable;
        this.columnIndex_ = n3;
        this.xmlType_ = n4;
        try {
            this.unicodeConverter_ = aS400JDBCConnection.getConverter(1200);
            this.unicodeUtf8Converter_ = aS400JDBCConnection.getConverter(1208);
        }
        catch (SQLException sQLException) {
            this.unicodeConverter_ = aS400JDBCConnection.converter_;
        }
    }

    public Object clone() {
        return new SQLXMLLocator(this.connection_, this.id_, this.maxLength_, this.settings_, this.converter_, this.columnIndex_, this.xmlType_);
    }

    public void setHandle(int n) {
        this.locator_.setHandle(n);
    }

    public int getHandle() {
        return this.locator_.getHandle();
    }

    public void convertFromRawBytes(byte[] byArray, int n, ConvTable convTable) throws SQLException {
        int n2 = BinaryConverter.byteArrayToInt(byArray, n);
        this.locator_.setHandle(n2);
        this.locator_.setColumnIndex(this.columnIndex_);
    }

    public void convertToRawBytes(byte[] byArray, int n, ConvTable convTable) throws SQLException {
        BinaryConverter.intToByteArray(this.locator_.getHandle(), byArray, n);
        if (this.savedObject_ != null) {
            this.writeToServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToServer() throws SQLException {
        if (this.savedObject_ instanceof byte[]) {
            byte[] byArray = (byte[])this.savedObject_;
            this.locator_.writeData(0L, byArray, true);
        } else if (this.savedObject_ instanceof InputStream) {
            int n = this.scale_;
            if (n == 0) {
                this.locator_.writeData(0L, new byte[0], 0, 0, true);
            } else if (n > 0) {
                InputStream inputStream = (InputStream)this.savedObject_;
                int n2 = n < 1000000 ? n : 1000000;
                byte[] byArray = new byte[n2];
                try {
                    int n3 = 0;
                    int n4 = inputStream.read(byArray, 0, n2);
                    while (n4 > -1 && n3 < n) {
                        if (this.xmlType_ == 1) {
                            this.locator_.writeData(n3 / 2, byArray, 0, n4, true);
                        } else {
                            this.locator_.writeData(n3, byArray, 0, n4, true);
                        }
                        int n5 = n - (n3 += n4);
                        if (n5 < n2) {
                            n2 = n5;
                        }
                        n4 = inputStream.read(byArray, 0, n2);
                    }
                    if (n3 < n) {
                        JDError.throwSQLException(this, "07006");
                    }
                }
                catch (IOException iOException) {
                    JDError.throwSQLException((Object)this, "HY000", iOException);
                }
            } else if (n == -2) {
                InputStream inputStream = (InputStream)this.savedObject_;
                int n6 = 1000000;
                byte[] byArray = new byte[n6];
                try {
                    int n7 = 0;
                    int n8 = inputStream.read(byArray, 0, n6);
                    while (n8 > -1) {
                        if (this.xmlType_ == 1) {
                            this.locator_.writeData(n7 / 2, byArray, 0, n8, true);
                        } else {
                            this.locator_.writeData(n7, byArray, 0, n8, true);
                        }
                        n7 += n8;
                        n8 = inputStream.read(byArray, 0, n6);
                    }
                }
                catch (IOException iOException) {
                    JDError.throwSQLException((Object)this, "HY000", iOException);
                }
            } else {
                JDError.throwSQLException(this, "07006");
            }
        } else if (this.savedObject_ instanceof Blob) {
            Blob blob;
            boolean bl = false;
            if (this.savedObject_ instanceof AS400JDBCBlobLocator) {
                blob = (AS400JDBCBlobLocator)this.savedObject_;
                AS400JDBCBlobLocator aS400JDBCBlobLocator = blob;
                synchronized (aS400JDBCBlobLocator) {
                    if (((AS400JDBCBlobLocator)blob).savedObject_ != null) {
                        this.savedObject_ = ((AS400JDBCBlobLocator)blob).savedObject_;
                        this.scale_ = ((AS400JDBCBlobLocator)blob).savedScale_;
                        ((AS400JDBCBlobLocator)blob).savedObject_ = null;
                        this.writeToServer();
                        return;
                    }
                }
            }
            if (!bl) {
                blob = (Blob)this.savedObject_;
                int n = (int)blob.length();
                byte[] byArray = blob.getBytes(1L, n);
                this.locator_.writeData(0L, byArray, 0, n, true);
            }
        } else if (this.savedObject_ instanceof String) {
            byte[] byArray;
            String string = (String)this.savedObject_;
            if (JDUtilities.hasXMLDeclaration(string)) {
                string = JDUtilities.handleXMLDeclarationEncoding(string);
                byArray = this.unicodeConverter_.stringToByteArray(string);
            } else {
                byArray = this.unicodeUtf8Converter_.stringToByteArray(string);
            }
            this.locator_.writeData(0L, byArray, true);
        } else if (this.savedObject_ instanceof Reader) {
            int n = this.scale_;
            if (n == 0) {
                this.locator_.writeData(0L, new byte[0], 0, 0, true);
            } else if (n > 0) {
                byte[] byArray = null;
                try {
                    int n9;
                    int n10 = n < 1000000 ? n : 1000000;
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    ReaderInputStream readerInputStream = new ReaderInputStream((Reader)this.savedObject_, this.unicodeUtf8Converter_.getCcsid(), null, n10);
                    byte[] byArray2 = new byte[n10];
                    int n11 = 0;
                    int n12 = readerInputStream.read(byArray2, 0, n10);
                    while (n12 > -1 && n11 < n) {
                        byteArrayOutputStream.write(byArray2, 0, n12);
                        n9 = n - (n11 += n12);
                        if (n9 < n10) {
                            n10 = n9;
                        }
                        n12 = readerInputStream.read(byArray2, 0, n10);
                    }
                    byArray = byteArrayOutputStream.toByteArray();
                    if (byArray.length < n) {
                        JDError.throwSQLException(this, "07006");
                    }
                    n9 = byArray.length;
                    if (byArray.length > this.maxLength_) {
                        byte[] byArray3 = new byte[this.maxLength_];
                        System.arraycopy(byArray, 0, byArray3, 0, this.maxLength_);
                        byArray = byArray3;
                    }
                    readerInputStream.close();
                    this.locator_.writeData(0L, byArray, true);
                }
                catch (ExtendedIOException extendedIOException) {
                    JDError.throwSQLException((Object)this, "07006", extendedIOException);
                }
                catch (IOException iOException) {
                    JDError.throwSQLException("HY000", iOException);
                }
            } else if (n == -2) {
                byte[] byArray = null;
                try {
                    int n13 = 1000000;
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    ReaderInputStream readerInputStream = new ReaderInputStream((Reader)this.savedObject_, this.unicodeUtf8Converter_.getCcsid(), null, n13);
                    byte[] byArray4 = new byte[n13];
                    int n14 = 0;
                    int n15 = readerInputStream.read(byArray4, 0, n13);
                    while (n15 > -1) {
                        byteArrayOutputStream.write(byArray4, 0, n15);
                        n14 += n15;
                        n15 = readerInputStream.read(byArray4, 0, n13);
                    }
                    byArray = byteArrayOutputStream.toByteArray();
                    int n16 = byArray.length;
                    if (byArray.length > this.maxLength_) {
                        byte[] byArray5 = new byte[this.maxLength_];
                        System.arraycopy(byArray, 0, byArray5, 0, this.maxLength_);
                        byArray = byArray5;
                    }
                    readerInputStream.close();
                    this.locator_.writeData(0L, byArray, true);
                }
                catch (ExtendedIOException extendedIOException) {
                    JDError.throwSQLException((Object)this, "07006", extendedIOException);
                }
                catch (IOException iOException) {
                    JDError.throwSQLException("HY000", iOException);
                }
            } else {
                JDError.throwSQLException(this, "07006");
            }
        } else if (this.savedObject_ instanceof Clob) {
            Clob clob;
            boolean bl = false;
            if (this.savedObject_ instanceof AS400JDBCClobLocator) {
                clob = (AS400JDBCClobLocator)this.savedObject_;
                AS400JDBCClobLocator aS400JDBCClobLocator = clob;
                synchronized (aS400JDBCClobLocator) {
                    if (((AS400JDBCClobLocator)clob).savedObject_ != null) {
                        this.savedObject_ = ((AS400JDBCClobLocator)clob).savedObject_;
                        this.scale_ = ((AS400JDBCClobLocator)clob).savedScale_;
                        ((AS400JDBCClobLocator)clob).savedObject_ = null;
                        this.writeToServer();
                        return;
                    }
                }
            }
            if (!bl) {
                clob = (Clob)this.savedObject_;
                int n = (int)clob.length();
                String string = clob.getSubString(1L, n);
                byte[] byArray = JDUtilities.hasXMLDeclaration(string) ? this.unicodeConverter_.stringToByteArray(JDUtilities.handleXMLDeclarationEncoding(string)) : this.unicodeUtf8Converter_.stringToByteArray(string);
                this.locator_.writeData(0L, byArray, 0, byArray.length, true);
                bl = true;
            } else {
                JDError.throwSQLException(this, "07006");
            }
        } else {
            JDError.throwSQLException(this, "07006");
        }
    }

    public void set(Object object, Calendar calendar, int n) throws SQLException {
        this.savedObject_ = object;
        if (object instanceof ConvTableReader) {
            ((ConvTableReader)this.savedObject_).isXML_ = true;
            this.scale_ = -2;
        } else if (n != -1) {
            this.scale_ = n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doConversion() throws SQLException {
        block36: {
            this.valueClob_ = null;
            this.valueBlob_ = null;
            int n = this.scale_;
            if (n == -1) {
                try {
                    n = (int)this.locator_.getLength();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.savedObject_ instanceof String) {
                this.valueClob_ = (String)this.savedObject_;
                break block36;
            }
            if (this.savedObject_ instanceof Reader) {
                if (n >= 0) {
                    try {
                        int n2 = n < 1000000 ? n : 1000000;
                        Reader reader = (Reader)this.savedObject_;
                        StringBuffer stringBuffer = new StringBuffer();
                        char[] cArray = new char[n2];
                        int n3 = 0;
                        int n4 = reader.read(cArray, 0, n2);
                        while (n4 > -1 && n3 < n) {
                            stringBuffer.append(cArray, 0, n4);
                            int n5 = n - (n3 += n4);
                            if (n5 < n2) {
                                n2 = n5;
                            }
                            n4 = reader.read(cArray, 0, n2);
                        }
                        this.valueClob_ = stringBuffer.toString();
                        if (this.valueClob_.length() < n) {
                            JDError.throwSQLException(this, "07006");
                        }
                        break block36;
                    }
                    catch (IOException iOException) {
                        JDError.throwSQLException((Object)this, "HY000", iOException);
                    }
                    break block36;
                }
                if (n == -2) {
                    try {
                        int n6 = 1000000;
                        Reader reader = (Reader)this.savedObject_;
                        StringBuffer stringBuffer = new StringBuffer();
                        char[] cArray = new char[n6];
                        int n7 = 0;
                        int n8 = reader.read(cArray, 0, n6);
                        while (n8 > -1) {
                            stringBuffer.append(cArray, 0, n8);
                            n7 += n8;
                            n8 = reader.read(cArray, 0, n6);
                        }
                        this.valueClob_ = stringBuffer.toString();
                    }
                    catch (IOException iOException) {
                        JDError.throwSQLException((Object)this, "HY000", iOException);
                    }
                } else {
                    JDError.throwSQLException(this, "07006");
                }
                break block36;
            }
            if (this.savedObject_ instanceof Clob) {
                Clob clob = (Clob)this.savedObject_;
                this.valueClob_ = clob.getSubString(1L, (int)clob.length());
                break block36;
            }
            if (this.savedObject_ instanceof byte[]) {
                this.valueBlob_ = (byte[])this.savedObject_;
                int n9 = this.valueBlob_.length;
                if (n9 > this.maxLength_) {
                    byte[] byArray = new byte[this.maxLength_];
                    System.arraycopy(this.valueBlob_, 0, byArray, 0, this.maxLength_);
                    this.valueBlob_ = byArray;
                }
                break block36;
            }
            if (this.savedObject_ instanceof Blob) {
                int n10;
                Blob blob = (Blob)this.savedObject_;
                int n11 = (int)blob.length();
                int n12 = n10 = n11 < 0 ? Integer.MAX_VALUE : n11;
                if (n10 > this.maxLength_) {
                    n10 = this.maxLength_;
                }
                this.valueBlob_ = blob.getBytes(1L, n10);
                break block36;
            }
            if (this.savedObject_ instanceof InputStream) {
                int n13 = this.scale_;
                if (n13 >= 0) {
                    int n14;
                    InputStream inputStream = (InputStream)this.savedObject_;
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    int n15 = n13 < 1000000 ? n13 : 1000000;
                    byte[] byArray = new byte[n15];
                    try {
                        int n16 = 0;
                        int n17 = inputStream.read(byArray, 0, n15);
                        while (n17 > -1 && n16 < n13) {
                            byteArrayOutputStream.write(byArray, 0, n17);
                            int n18 = n13 - (n16 += n17);
                            if (n18 < n15) {
                                n15 = n18;
                            }
                            n17 = inputStream.read(byArray, 0, n15);
                        }
                    }
                    catch (IOException iOException) {
                        JDError.throwSQLException("HY000", iOException);
                    }
                    this.valueBlob_ = byteArrayOutputStream.toByteArray();
                    if (this.valueBlob_.length < n13) {
                        JDError.throwSQLException(this, "07006");
                    }
                    if ((n14 = this.valueBlob_.length) > this.maxLength_) {
                        byte[] byArray2 = new byte[this.maxLength_];
                        System.arraycopy(this.valueBlob_, 0, byArray2, 0, this.maxLength_);
                        this.valueBlob_ = byArray2;
                    }
                    break block36;
                }
                if (n13 == -2) {
                    InputStream inputStream = (InputStream)this.savedObject_;
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    int n19 = 1000000;
                    byte[] byArray = new byte[n19];
                    try {
                        int n20 = 0;
                        int n21 = inputStream.read(byArray, 0, n19);
                        while (n21 > -1) {
                            byteArrayOutputStream.write(byArray, 0, n21);
                            n20 += n21;
                            n21 = inputStream.read(byArray, 0, n19);
                        }
                    }
                    catch (IOException iOException) {
                        JDError.throwSQLException("HY000", iOException);
                    }
                    this.valueBlob_ = byteArrayOutputStream.toByteArray();
                    int n22 = this.valueBlob_.length;
                    if (n22 > this.maxLength_) {
                        byte[] byArray3 = new byte[this.maxLength_];
                        System.arraycopy(this.valueBlob_, 0, byArray3, 0, this.maxLength_);
                        this.valueBlob_ = byArray3;
                    }
                    break block36;
                }
                JDError.throwSQLException("07006");
                break block36;
            }
            JDError.throwSQLException("07006");
        }
    }

    public int getSQLType() {
        return 40;
    }

    public String getCreateParameters() {
        return AS400JDBCDriver.getResource("MAXLENGTH");
    }

    public int getDisplaySize() {
        return this.maxLength_;
    }

    public String getJavaClassName() {
        return "com.ibm.as400.access.AS400JDBCSQLXML";
    }

    public String getLiteralPrefix() {
        return null;
    }

    public String getLiteralSuffix() {
        return null;
    }

    public String getLocalName() {
        return "SQLXML";
    }

    public int getMaximumPrecision() {
        return 0x7FFFFFFE;
    }

    public int getMaximumScale() {
        return 0;
    }

    public int getMinimumScale() {
        return 0;
    }

    public int getNativeType() {
        return 2452;
    }

    public int getPrecision() {
        return this.maxLength_;
    }

    public int getRadix() {
        return 0;
    }

    public int getScale() {
        return 0;
    }

    public int getType() {
        return 2009;
    }

    public String getTypeName() {
        return "SQLXML";
    }

    public boolean isSigned() {
        return false;
    }

    public boolean isText() {
        return true;
    }

    public int getActualSize() {
        return this.maxLength_;
    }

    public int getTruncated() {
        return this.truncated_;
    }

    public InputStream getAsciiStream() throws SQLException {
        this.truncated_ = 0;
        try {
            if (this.savedObject_ != null) {
                this.doConversion();
                this.truncated_ = 0;
                return new ByteArrayInputStream(ConvTable.getTable(819, null).stringToByteArray(this.valueClob_));
            }
            ConvTableReader convTableReader = new ConvTableReader((InputStream)new AS400JDBCInputStream(new JDLobLocator(this.locator_)), this.converter_.getCcsid(), true);
            return new ReaderInputStream((Reader)convTableReader, 819);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            JDError.throwSQLException((Object)this, "HY000", unsupportedEncodingException);
            return null;
        }
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        JDError.throwSQLException(this, "07006");
        return null;
    }

    public InputStream getBinaryStream() throws SQLException {
        this.truncated_ = 0;
        return new AS400JDBCInputStream(new JDLobLocator(this.locator_));
    }

    public Blob getBlob() throws SQLException {
        if (this.savedObject_ != null) {
            this.doConversion();
            this.truncated_ = 0;
            return new AS400JDBCBlob(this.valueBlob_, this.maxLength_);
        }
        this.truncated_ = 0;
        return new AS400JDBCBlobLocator(new JDLobLocator(this.locator_), this.savedObject_, this.scale_);
    }

    public boolean getBoolean() throws SQLException {
        JDError.throwSQLException(this, "07006");
        return false;
    }

    public byte getByte() throws SQLException {
        JDError.throwSQLException(this, "07006");
        return -1;
    }

    public byte[] getBytes() throws SQLException {
        if (this.savedObject_ != null) {
            this.doConversion();
            this.truncated_ = 0;
            return this.valueBlob_;
        }
        int n = (int)this.locator_.getLength();
        if (n == 0) {
            return new byte[0];
        }
        DBLobData dBLobData = this.locator_.retrieveData(0L, n);
        int n2 = dBLobData.getLength();
        byte[] byArray = new byte[n2];
        System.arraycopy(dBLobData.getRawBytes(), dBLobData.getOffset(), byArray, 0, n2);
        this.truncated_ = 0;
        return byArray;
    }

    public Reader getCharacterStream() throws SQLException {
        this.truncated_ = 0;
        try {
            if (this.savedObject_ != null) {
                this.doConversion();
                this.truncated_ = 0;
                return new StringReader(this.valueClob_);
            }
            return new ConvTableReader((InputStream)new AS400JDBCInputStream(new JDLobLocator(this.locator_)), this.converter_.getCcsid(), true);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            JDError.throwSQLException((Object)this, "HY000", unsupportedEncodingException);
            return null;
        }
    }

    public Clob getClob() throws SQLException {
        this.truncated_ = 0;
        if (this.savedObject_ != null) {
            this.doConversion();
            this.truncated_ = 0;
            return new AS400JDBCClob(this.valueClob_, this.maxLength_);
        }
        return new AS400JDBCClobLocator(new JDLobLocator(this.locator_), this.converter_, this.savedObject_, this.scale_, true);
    }

    public Date getDate(Calendar calendar) throws SQLException {
        JDError.throwSQLException(this, "07006");
        return null;
    }

    public double getDouble() throws SQLException {
        JDError.throwSQLException(this, "07006");
        return -1.0;
    }

    public float getFloat() throws SQLException {
        JDError.throwSQLException(this, "07006");
        return -1.0f;
    }

    public int getInt() throws SQLException {
        JDError.throwSQLException(this, "07006");
        return -1;
    }

    public long getLong() throws SQLException {
        JDError.throwSQLException(this, "07006");
        return -1L;
    }

    public Object getObject() throws SQLException {
        this.truncated_ = 0;
        return this.getClob();
    }

    public short getShort() throws SQLException {
        JDError.throwSQLException(this, "07006");
        return -1;
    }

    public String getString() throws SQLException {
        if (this.savedObject_ != null) {
            this.doConversion();
            this.truncated_ = 0;
            return this.valueClob_;
        }
        DBLobData dBLobData = this.locator_.retrieveData(0L, this.locator_.getMaxLength());
        String string = this.converter_.byteArrayToString(dBLobData.getRawBytes(), dBLobData.getOffset(), dBLobData.getLength());
        string = JDUtilities.stripXMLDeclaration(string);
        this.truncated_ = 0;
        return string;
    }

    public Time getTime(Calendar calendar) throws SQLException {
        JDError.throwSQLException(this, "07006");
        return null;
    }

    public Timestamp getTimestamp(Calendar calendar) throws SQLException {
        JDError.throwSQLException(this, "07006");
        return null;
    }

    public InputStream getUnicodeStream() throws SQLException {
        this.truncated_ = 0;
        try {
            if (this.savedObject_ != null) {
                this.doConversion();
                this.truncated_ = 0;
                return new ReaderInputStream((Reader)new StringReader(this.valueClob_), 13488);
            }
            return new ReaderInputStream((Reader)new ConvTableReader((InputStream)new AS400JDBCInputStream(new JDLobLocator(this.locator_)), this.converter_.getCcsid(), true), 13488);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            JDError.throwSQLException("HY000", unsupportedEncodingException);
            return null;
        }
    }

    public Reader getNCharacterStream() throws SQLException {
        this.truncated_ = 0;
        if (this.savedObject_ != null) {
            this.doConversion();
            this.truncated_ = 0;
            return new StringReader(this.valueClob_);
        }
        try {
            return new ConvTableReader((InputStream)new AS400JDBCInputStream(new JDLobLocator(this.locator_)), this.converter_.getCcsid(), true);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            JDError.throwSQLException((Object)this, "HY000", unsupportedEncodingException);
            return null;
        }
    }

    public Array getArray() throws SQLException {
        JDError.throwSQLException(this, "07006");
        return null;
    }
}

