/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400ImplRemote;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ClientAccessDataStream;
import com.ibm.as400.access.ConnectionDroppedException;
import com.ibm.as400.access.ConverterImplRemote;
import com.ibm.as400.access.Trace;
import java.io.IOException;
import java.io.InputStream;
import java.util.GregorianCalendar;

class SignonInfoRep
extends ClientAccessDataStream {
    SignonInfoRep() {
    }

    public Object getNewDataStream() {
        return new SignonInfoRep();
    }

    int getRC() {
        return this.get32bit(20);
    }

    GregorianCalendar getCurrentSignonDate() {
        return this.getDate(4358);
    }

    GregorianCalendar getLastSignonDate() {
        return this.getDate(4359);
    }

    GregorianCalendar getExpirationDate() {
        return this.getDate(4360);
    }

    GregorianCalendar getDate(int n) {
        GregorianCalendar gregorianCalendar = null;
        for (int i = 24; i < this.data_.length - 1; i += this.get32bit(i)) {
            if (this.get16bit(i + 4) != n) {
                continue;
            }
            gregorianCalendar = new GregorianCalendar(this.get16bit(i + 6), this.data_[i + 8] - 1, this.data_[i + 9], this.data_[i + 10], this.data_[i + 11], this.data_[i + 12]);
            break;
        }
        return gregorianCalendar;
    }

    int getServerCCSID() {
        int n = 0;
        for (int i = 24; i < this.data_.length - 1; i += this.get32bit(i)) {
            if (this.get16bit(i + 4) != 4372) {
                continue;
            }
            n = this.get32bit(i + 6);
            break;
        }
        return n;
    }

    byte[] getUserIdBytes() {
        for (int i = 24; i < this.data_.length - 1; i += this.get32bit(i)) {
            if (this.get16bit(i + 4) != 4356) {
                continue;
            }
            byte[] byArray = new byte[]{64, 64, 64, 64, 64, 64, 64, 64, 64, 64};
            System.arraycopy(this.data_, i + 10, byArray, 0, this.get32bit(i) - 10);
            return byArray;
        }
        return null;
    }

    AS400Message[] getErrorMessages(ConverterImplRemote converterImplRemote) throws IOException {
        return AS400ImplRemote.parseMessages(this.data_, 24, converterImplRemote);
    }

    void read(InputStream inputStream) throws IOException {
        byte[] byArray;
        if (Trace.traceOn_) {
            Trace.log(1, "Receiving retrieve signon information reply...");
        }
        if (this.readFromStream(inputStream, byArray = new byte[20], 0, 20) < 20) {
            if (Trace.traceOn_) {
                Trace.log(2, "Failed to read all of the retrieve signon information reply header.");
            }
            throw new ConnectionDroppedException(2);
        }
        this.data_ = new byte[BinaryConverter.byteArrayToInt(byArray, 0)];
        System.arraycopy(byArray, 0, this.data_, 0, 20);
        this.readAfterHeader(inputStream);
    }

    public int hashCode() {
        return 61444;
    }
}

