/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Bin4;
import com.ibm.as400.access.AS400ByteArray;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.CommandCall;
import com.ibm.as400.access.ConnectionDroppedException;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.HexFieldDescription;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.PoolInformationFormat;
import com.ibm.as400.access.PoolInformationFormat0400;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.Record;
import com.ibm.as400.access.ResourceBundleLoader;
import com.ibm.as400.access.SSTS0300Format;
import com.ibm.as400.access.SSTS0400Format;
import com.ibm.as400.access.Subsystem;
import com.ibm.as400.access.SystemStatusFormat;
import com.ibm.as400.access.Trace;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;

public class SystemPool {
    private static final boolean DEBUG = false;
    public static final float CALCULATE = -2.0f;
    private static final Float CALCULATE_FLOAT = new Float(-2.0f);
    public static final int CALCULATE_INT = -2;
    private static final Integer CALCULATE_INTEGER = new Integer(-2);
    private static final Integer NO_CHANGE = new Integer(-1);
    private static final String DEFAULT = "*DFT";
    private AS400 system_;
    private String poolName_;
    private Integer poolIdentifier_;
    private boolean indicatedSharedPool_;
    private String subsystemLibrary_;
    private String subsystemName_;
    private int poolSequenceNumber_;
    private transient boolean connected_;
    private boolean cacheChanges_ = false;
    private transient PropertyChangeSupport changes_;
    private transient VetoableChangeSupport vetos_;
    private SystemStatusFormat systemStatusFormat_;
    private PoolInformationFormat poolFormat_;
    private Record poolRecord_;
    private transient Hashtable changesTable_;
    private static final String TEN_BLANKS = "          ";
    static /* synthetic */ Class class$com$ibm$as400$access$SSTS0400Format;
    static /* synthetic */ Class class$com$ibm$as400$access$SSTS0300Format;

    public SystemPool() {
    }

    public SystemPool(AS400 aS400, String string) {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        if (string == null) {
            throw new NullPointerException("poolName");
        }
        if (Trace.isTraceOn() && !SystemPool.isValidNameForSharedPool(string)) {
            Trace.log(4, "Invalid name for shared pool: " + string);
        }
        this.system_ = aS400;
        this.poolName_ = string.trim();
        this.indicatedSharedPool_ = true;
    }

    public SystemPool(Subsystem subsystem, int n) {
        if (subsystem == null) {
            throw new NullPointerException("subsystem");
        }
        if (n < 1 || n > 10) {
            throw new ExtendedIllegalArgumentException("sequenceNumber (" + n + ")", 4);
        }
        this.system_ = subsystem.getSystem();
        this.poolName_ = Integer.toString(n);
        this.subsystemLibrary_ = subsystem.getLibrary();
        this.subsystemName_ = subsystem.getName();
        this.poolSequenceNumber_ = n;
        this.indicatedSharedPool_ = false;
    }

    public SystemPool(Subsystem subsystem, int n, int n2, int n3) {
        this(subsystem, n);
        this.cacheChanges_ = true;
        try {
            this.set("poolSize", new Integer(n2));
            this.set("activityLevel", new Integer(n3));
        }
        catch (Exception exception) {
            Trace.log(2, exception);
            throw new InternalErrorException(10);
        }
        this.cacheChanges_ = false;
    }

    public SystemPool(AS400 aS400, String string, int n) {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        if (string == null) {
            throw new NullPointerException("poolName");
        }
        if (n < 1 || n > 64) {
            throw new ExtendedIllegalArgumentException("poolIdentifier (" + n + ")", 4);
        }
        this.system_ = aS400;
        this.poolName_ = string.trim();
        this.poolIdentifier_ = new Integer(n);
        this.indicatedSharedPool_ = true;
        if (Trace.isTraceOn() && !SystemPool.isValidNameForSharedPool(string)) {
            Trace.log(4, "Invalid name for shared pool: " + string);
        }
    }

    public SystemPool(AS400 aS400, int n) {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        if (n < 1 || n > 64) {
            throw new ExtendedIllegalArgumentException("poolIdentifier (" + n + ")", 4);
        }
        this.system_ = aS400;
        this.poolIdentifier_ = new Integer(n);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.changes_ == null) {
            this.changes_ = new PropertyChangeSupport(this);
        }
        this.changes_.addPropertyChangeListener(propertyChangeListener);
    }

    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (vetoableChangeListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.vetos_ == null) {
            this.vetos_ = new VetoableChangeSupport(this);
        }
        this.vetos_.addVetoableChangeListener(vetoableChangeListener);
    }

    private static final Integer convertToHundredths(Object object) {
        float f = ((Float)object).floatValue();
        Integer n = f <= 0.0f ? new Integer((int)f) : new Integer((int)(f * 100.0f));
        return n;
    }

    public synchronized void commitCache() throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, UnsupportedEncodingException {
        int n;
        block42: {
            if (this.changesTable_ == null || this.changesTable_.isEmpty()) {
                return;
            }
            if (!this.connected_) {
                this.connect();
            }
            n = 0;
            try {
                n = this.getIdentifier();
            }
            catch (ObjectDoesNotExistException objectDoesNotExistException) {
                n = 0;
                if (!Trace.isTraceOn()) break block42;
                Trace.log(1, "No pool identifier is assigned to pool.", (Throwable)objectDoesNotExistException);
            }
        }
        String string = null;
        if (n == 0) {
            StringBuffer stringBuffer = new StringBuffer("QSYS/CHGSHRPOOL POOL(" + this.poolName_ + ")");
            Object object = this.changesTable_.get("poolSize");
            if (object != null) {
                stringBuffer.append(" SIZE(" + object.toString() + ")");
            }
            if ((object = this.changesTable_.get("activityLevel")) != null) {
                if (object.equals(CALCULATE_INTEGER)) {
                    object = "*SAME";
                    if (Trace.isTraceOn()) {
                        Trace.log(4, "Setting activityLevel to SAME.");
                    }
                }
                stringBuffer.append(" ACTLVL(" + object.toString() + ")");
            }
            if ((object = this.changesTable_.get("pagingOption")) != null) {
                stringBuffer.append(" PAGING(" + object.toString() + ")");
            }
            if ((object = this.changesTable_.get("priority")) != null) {
                if (object.equals(CALCULATE_INTEGER)) {
                    object = DEFAULT;
                    if (Trace.isTraceOn()) {
                        Trace.log(4, "Setting priority to DEFAULT.");
                    }
                }
                stringBuffer.append(" PTY(" + object.toString() + ")");
            }
            if ((object = this.changesTable_.get("minimumPoolSize")) != null) {
                if (object.equals(CALCULATE_FLOAT)) {
                    object = DEFAULT;
                    if (Trace.isTraceOn()) {
                        Trace.log(4, "Setting minimumPoolSize to DEFAULT.");
                    }
                }
                stringBuffer.append(" MINPCT(" + object.toString() + ")");
            }
            if ((object = this.changesTable_.get("maximumPoolSize")) != null) {
                if (object.equals(CALCULATE_FLOAT)) {
                    object = DEFAULT;
                    if (Trace.isTraceOn()) {
                        Trace.log(4, "Setting maximumPoolSize to DEFAULT.");
                    }
                }
                stringBuffer.append(" MAXPCT(" + object.toString() + ")");
            }
            if ((object = this.changesTable_.get("minimumFaults")) != null) {
                if (object.equals(CALCULATE_FLOAT)) {
                    object = DEFAULT;
                    if (Trace.isTraceOn()) {
                        Trace.log(4, "Setting minimumFaults to DEFAULT.");
                    }
                }
                stringBuffer.append(" MINFAULT(" + object.toString() + ")");
            }
            if ((object = this.changesTable_.get("perThreadFaults")) != null) {
                if (object.equals(CALCULATE_FLOAT)) {
                    object = DEFAULT;
                    if (Trace.isTraceOn()) {
                        Trace.log(4, "Setting perThreadFaults to DEFAULT.");
                    }
                }
                stringBuffer.append(" JOBFAULT(" + object.toString() + ")");
            }
            if ((object = this.changesTable_.get("maximumFaults")) != null) {
                if (object.equals(CALCULATE_FLOAT)) {
                    object = DEFAULT;
                    if (Trace.isTraceOn()) {
                        Trace.log(4, "Setting maximumFaults to DEFAULT.");
                    }
                }
                stringBuffer.append(" MAXFAULT(" + object.toString() + ")");
            }
            CommandCall commandCall = new CommandCall(this.system_, stringBuffer.toString());
            commandCall.suggestThreadsafe(false);
            if (!commandCall.run()) {
                throw new AS400Exception(commandCall.getMessageList());
            }
            string = (String)this.changesTable_.get("messageLogging");
        } else {
            QSYSObjectPathName qSYSObjectPathName = new QSYSObjectPathName("QSYS", "QUSCHGPA", "PGM");
            AS400Bin4 aS400Bin4 = new AS400Bin4();
            ProgramParameter[] programParameterArray = new ProgramParameter[12];
            programParameterArray[0] = new ProgramParameter(aS400Bin4.toBytes(this.getIdentifier()));
            Object object = this.changesTable_.get("poolSize");
            if (object == null) {
                object = NO_CHANGE;
            }
            programParameterArray[1] = new ProgramParameter(aS400Bin4.toBytes(object));
            object = this.changesTable_.get("activityLevel");
            if (object == null) {
                object = NO_CHANGE;
            }
            programParameterArray[2] = new ProgramParameter(aS400Bin4.toBytes(object));
            object = this.changesTable_.get("messageLogging");
            if (object == null) {
                object = "Y";
            }
            AS400Text aS400Text = new AS400Text(1, this.system_.getCcsid(), this.system_);
            programParameterArray[3] = new ProgramParameter(aS400Text.toBytes(object));
            byte[] byArray = new byte[32];
            programParameterArray[4] = new ProgramParameter(byArray, 0);
            object = this.changesTable_.get("pagingOption");
            if (object == null) {
                object = "*SAME";
            }
            AS400Text aS400Text2 = new AS400Text(10, this.system_.getCcsid(), this.system_);
            programParameterArray[5] = new ProgramParameter(aS400Text2.toBytes(object));
            object = this.changesTable_.get("priority");
            if (object == null) {
                object = NO_CHANGE;
            }
            programParameterArray[6] = new ProgramParameter(aS400Bin4.toBytes(object));
            object = this.changesTable_.get("minimumPoolSize");
            object = object == null ? NO_CHANGE : (object.equals(CALCULATE_FLOAT) ? CALCULATE_INTEGER : SystemPool.convertToHundredths(object));
            programParameterArray[7] = new ProgramParameter(aS400Bin4.toBytes(object));
            object = this.changesTable_.get("maximumPoolSize");
            object = object == null ? NO_CHANGE : (object.equals(CALCULATE_FLOAT) ? CALCULATE_INTEGER : SystemPool.convertToHundredths(object));
            programParameterArray[8] = new ProgramParameter(aS400Bin4.toBytes(object));
            object = this.changesTable_.get("minimumFaults");
            object = object == null ? NO_CHANGE : (object.equals(CALCULATE_FLOAT) ? CALCULATE_INTEGER : SystemPool.convertToHundredths(object));
            programParameterArray[9] = new ProgramParameter(aS400Bin4.toBytes(object));
            object = this.changesTable_.get("perThreadFaults");
            object = object == null ? NO_CHANGE : (object.equals(CALCULATE_FLOAT) ? CALCULATE_INTEGER : SystemPool.convertToHundredths(object));
            programParameterArray[10] = new ProgramParameter(aS400Bin4.toBytes(object));
            object = this.changesTable_.get("maximumFaults");
            object = object == null ? NO_CHANGE : (object.equals(CALCULATE_FLOAT) ? CALCULATE_INTEGER : SystemPool.convertToHundredths(object));
            programParameterArray[11] = new ProgramParameter(aS400Bin4.toBytes(object));
            ProgramCall programCall = new ProgramCall(this.system_);
            try {
                programCall.setProgram(qSYSObjectPathName.getPath(), programParameterArray);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            if (Trace.isTraceOn()) {
                Trace.log(1, "Setting system pool information.");
            }
            if (!programCall.run()) {
                AS400Message[] aS400MessageArray = programCall.getMessageList();
                if (Trace.isTraceOn()) {
                    Trace.log(2, "Error setting system pool information:");
                    for (int i = 0; i < aS400MessageArray.length; ++i) {
                        Trace.log(2, aS400MessageArray[i].toString());
                    }
                }
                throw new AS400Exception(aS400MessageArray);
            }
        }
        this.changesTable_.clear();
        if (string != null) {
            this.changesTable_.put("messageLogging", string);
            Trace.log(2, "Unable to update 'message logging' attribute, since shared pool " + this.poolName_ + " is not in use.  The change remains pending.");
        }
    }

    private void connect() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, UnsupportedEncodingException {
        if (this.system_ == null) {
            Trace.log(2, "Attempt to connect before setting system.");
            throw new ExtendedIllegalStateException("system", 4);
        }
        this.connected_ = true;
    }

    public boolean equals(Object object) {
        try {
            SystemPool systemPool = (SystemPool)object;
            if (this.system_ == null ? systemPool.getSystem() != null : !this.system_.equals(systemPool.getSystem())) {
                return false;
            }
            if (this.poolName_ == null ? systemPool.getName() != null : !this.poolName_.equals(systemPool.getName())) {
                return false;
            }
            if (this.subsystemLibrary_ == null ? systemPool.getSubsystemLibrary() != null : !this.subsystemLibrary_.equals(systemPool.getSubsystemLibrary())) {
                return false;
            }
            if (this.subsystemName_ == null ? systemPool.getSubsystemName() != null : !this.subsystemName_.equals(systemPool.getSubsystemName())) {
                return false;
            }
            return this.poolIdentifier_ == null || this.poolIdentifier_ == 0 || systemPool.getIdentifier() == 0 || this.poolIdentifier_.intValue() == systemPool.getIdentifier();
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public int hashCode() {
        int n = 0;
        if (this.system_ != null) {
            n += this.system_.hashCode();
        }
        if (this.poolName_ != null) {
            n += this.poolName_.hashCode();
        }
        if (this.subsystemLibrary_ != null) {
            n += this.subsystemLibrary_.hashCode();
        }
        if (this.subsystemName_ != null) {
            n += this.subsystemName_.hashCode();
        }
        if (this.poolIdentifier_ != null) {
            n += this.poolIdentifier_.hashCode();
        }
        return n;
    }

    private Object get(String string) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, UnsupportedEncodingException {
        Object object = null;
        if (!this.cacheChanges_) {
            this.refreshCache();
        } else if (this.changesTable_ != null) {
            object = this.changesTable_.get(string);
        }
        if (object == null) {
            this.retrieveInformation();
            object = this.poolRecord_.getField(string);
        }
        return object;
    }

    public float getActiveToIneligible() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, UnsupportedEncodingException {
        return ((Integer)this.get("activeToIneligible")).floatValue() / 10.0f;
    }

    public float getActiveToWait() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, UnsupportedEncodingException {
        return ((Integer)this.get("activeToWait")).floatValue() / 10.0f;
    }

    public float getDatabaseFaults() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, UnsupportedEncodingException {
        return ((Integer)this.get("databaseFaults")).floatValue() / 10.0f;
    }

    public float getDatabasePages() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, UnsupportedEncodingException {
        return ((Integer)this.get("databasePages")).floatValue() / 10.0f;
    }

    public String getDescription() {
        if (this.poolName_ == null) {
            return "";
        }
        if (this.poolName_.equals("*MACHINE")) {
            return ResourceBundleLoader.getText("SYSTEM_POOL_MACHINE");
        }
        if (this.poolName_.equals("*BASE")) {
            return ResourceBundleLoader.getText("SYSTEM_POOL_BASE");
        }
        if (this.poolName_.equals("*INTERACT")) {
            return ResourceBundleLoader.getText("SYSTEM_POOL_INTERACT");
        }
        if (this.poolName_.equals("*SPOOL")) {
            return ResourceBundleLoader.getText("SYSTEM_POOL_SPOOL");
        }
        return ResourceBundleLoader.getText("SYSTEM_POOL_OTHER");
    }

    public int getMaximumActiveThreads() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, UnsupportedEncodingException {
        return this.getActivityLevel();
    }

    public int getActivityLevel() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, UnsupportedEncodingException {
        return (Integer)this.get("activityLevel");
    }

    public float getNonDatabaseFaults() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, UnsupportedEncodingException {
        return ((Integer)this.get("nonDatabaseFaults")).floatValue() / 10.0f;
    }

    public float getNonDatabasePages() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, UnsupportedEncodingException {
        return ((Integer)this.get("nonDatabasePages")).floatValue() / 10.0f;
    }

    public String getPagingOption() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, UnsupportedEncodingException {
        return ((String)this.get("pagingOption")).trim();
    }

    public int getPoolIdentifier() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, UnsupportedEncodingException {
        return this.getIdentifier();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getIdentifier() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, UnsupportedEncodingException {
        if (this.poolIdentifier_ == null) {
            SystemPool systemPool = this;
            synchronized (systemPool) {
                if (this.poolIdentifier_ == null) {
                    boolean bl = this.cacheChanges_;
                    this.cacheChanges_ = true;
                    this.poolIdentifier_ = (Integer)this.get("poolIdentifier");
                    this.cacheChanges_ = bl;
                }
            }
        }
        return this.poolIdentifier_ == null ? 0 : this.poolIdentifier_;
    }

    public String getPoolName() {
        return this.getName();
    }

    public String getName() {
        if (this.poolName_ != null) {
            return this.poolName_;
        }
        try {
            this.poolName_ = ((String)this.get("poolName")).trim();
            return this.poolName_;
        }
        catch (Exception exception) {
            if (Trace.isTraceOn()) {
                Trace.log(2, "Unable to get pool name.", (Throwable)exception);
            }
            return null;
        }
    }

    public int getPoolSize() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, UnsupportedEncodingException {
        return this.getSize();
    }

    public int getSize() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, UnsupportedEncodingException {
        return (Integer)this.get("poolSize");
    }

    public int getReservedSize() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, UnsupportedEncodingException {
        return (Integer)this.get("reservedSize");
    }

    public String getSubsystemLibrary() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, UnsupportedEncodingException {
        return ((String)this.get("subsystemLibraryName")).trim();
    }

    public String getSubsystemName() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, UnsupportedEncodingException {
        return ((String)this.get("subsystemName")).trim();
    }

    public AS400 getSystem() {
        return this.system_;
    }

    public float getWaitToIneligible() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, UnsupportedEncodingException {
        return ((Integer)this.get("waitToIneligible")).floatValue() / 10.0f;
    }

    public boolean isCaching() {
        return this.cacheChanges_;
    }

    public boolean isShared() {
        return (this.indicatedSharedPool_ || SystemPool.isValidNameForSharedPool(this.poolName_)) && this.subsystemLibrary_ == null && this.subsystemName_ == null && this.poolSequenceNumber_ == 0;
    }

    public void loadInformation() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, UnsupportedEncodingException {
        this.refreshCache();
    }

    public synchronized void refreshCache() {
        this.poolRecord_ = null;
        if (this.changesTable_ != null) {
            this.changesTable_.clear();
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.changes_ != null) {
            this.changes_.removePropertyChangeListener(propertyChangeListener);
        }
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (vetoableChangeListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.vetos_ != null) {
            this.vetos_.removeVetoableChangeListener(vetoableChangeListener);
        }
    }

    private ProgramParameter[] buildParameterList() {
        int n;
        AS400Bin4 aS400Bin4 = new AS400Bin4();
        if (this.indicatedSharedPool_ || this.poolIdentifier_ != null) {
            n = 7;
            if (this.systemStatusFormat_ == null || this.systemStatusFormat_.getClass() != (class$com$ibm$as400$access$SSTS0400Format == null ? (class$com$ibm$as400$access$SSTS0400Format = SystemPool.class$("com.ibm.as400.access.SSTS0400Format")) : class$com$ibm$as400$access$SSTS0400Format)) {
                this.systemStatusFormat_ = new SSTS0400Format(this.system_);
                this.poolFormat_ = new PoolInformationFormat0400(this.system_);
            }
        } else {
            n = 5;
            if (this.systemStatusFormat_ == null || this.systemStatusFormat_.getClass() != (class$com$ibm$as400$access$SSTS0300Format == null ? (class$com$ibm$as400$access$SSTS0300Format = SystemPool.class$("com.ibm.as400.access.SSTS0300Format")) : class$com$ibm$as400$access$SSTS0300Format)) {
                this.systemStatusFormat_ = new SSTS0300Format(this.system_);
                this.poolFormat_ = new PoolInformationFormat(this.system_);
            }
        }
        ProgramParameter[] programParameterArray = new ProgramParameter[n];
        int n2 = this.systemStatusFormat_.getNewRecord().getRecordLength();
        programParameterArray[0] = new ProgramParameter(n2);
        programParameterArray[1] = new ProgramParameter(aS400Bin4.toBytes(n2));
        AS400Text aS400Text = new AS400Text(8, this.system_.getCcsid(), this.system_);
        programParameterArray[2] = new ProgramParameter(aS400Text.toBytes(this.systemStatusFormat_.getName()));
        aS400Text = new AS400Text(10, this.system_.getCcsid(), this.system_);
        programParameterArray[3] = new ProgramParameter(aS400Text.toBytes("*NO"));
        byte[] byArray = new byte[32];
        programParameterArray[4] = new ProgramParameter(byArray, 0);
        if (n > 5) {
            int n3;
            String string = this.indicatedSharedPool_ ? "*SHARED   " : "*SYSTEM   ";
            StringBuffer stringBuffer = new StringBuffer(this.indicatedSharedPool_ ? this.poolName_ : "");
            if (stringBuffer.length() < 10) {
                n3 = 10 - stringBuffer.length();
                stringBuffer.append(TEN_BLANKS.substring(10 - n3));
            }
            n3 = this.indicatedSharedPool_ ? 0 : this.poolIdentifier_;
            byte[] byArray2 = aS400Text.toBytes(string);
            byte[] byArray3 = aS400Text.toBytes(stringBuffer.toString());
            byte[] byArray4 = BinaryConverter.intToByteArray(n3);
            byte[] byArray5 = new byte[24];
            System.arraycopy(byArray2, 0, byArray5, 0, 10);
            System.arraycopy(byArray3, 0, byArray5, 10, 10);
            System.arraycopy(byArray4, 0, byArray5, 20, 4);
            programParameterArray[5] = new ProgramParameter(byArray5);
            if (Trace.isTraceOn()) {
                Trace.log(1, "QWCRSSTS parameter 6: poolType==|" + string + "| , poolName==|" + stringBuffer.toString() + "| , poolID==|" + n3 + "|");
            }
            programParameterArray[6] = new ProgramParameter(aS400Bin4.toBytes(24));
        }
        return programParameterArray;
    }

    public static final boolean isValidNameForSharedPool(String string) {
        if (string == null) {
            return false;
        }
        return string.equals("*ALL") || string.equals("*MACHINE") || string.equals("*BASE") || string.equals("*INTERACT") || string.equals("*SPOOL") || string.startsWith("*SHRPOOL");
    }

    private void retrieveInformation() throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, UnsupportedEncodingException {
        if (this.poolRecord_ != null) {
            return;
        }
        if (!this.connected_) {
            this.connect();
        }
        QSYSObjectPathName qSYSObjectPathName = new QSYSObjectPathName("QSYS", "QWCRSSTS", "PGM");
        ProgramParameter[] programParameterArray = this.buildParameterList();
        ProgramCall programCall = new ProgramCall(this.system_);
        try {
            programCall.setProgram(qSYSObjectPathName.getPath(), programParameterArray);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        if (Trace.isTraceOn()) {
            Trace.log(1, "Retrieving system pool information.");
        }
        if (!programCall.run()) {
            AS400Message[] aS400MessageArray = programCall.getMessageList();
            if (Trace.isTraceOn()) {
                Trace.log(2, "Error retrieving system pool information:");
                for (int i = 0; i < aS400MessageArray.length; ++i) {
                    Trace.log(2, aS400MessageArray[i].toString());
                }
            }
            if (this.poolIdentifier_ == null && !SystemPool.isValidNameForSharedPool(this.poolName_)) {
                Trace.log(2, "Invalid name for shared pool: " + this.poolName_);
                throw new ObjectDoesNotExistException(this.poolName_, 2);
            }
            throw new AS400Exception(aS400MessageArray);
        }
        byte[] byArray = programParameterArray[0].getOutputData();
        Record record = this.systemStatusFormat_.getNewRecord(byArray);
        if (this.resizeFormat(record)) {
            this.retrieveInformation();
            return;
        }
        int n = (Integer)record.getField("offsetToPoolInformation");
        int n2 = (Integer)record.getField("numberOfPools");
        int n3 = (Integer)record.getField("lengthOfPoolInformationEntry");
        byte[] byArray2 = record.getContents();
        if (Trace.isTraceOn()) {
            Trace.log(1, "Parsing out " + n2 + " system pools with " + n3 + " bytes each starting at offset " + n + " for a maximum length of " + byArray2.length + ".");
        }
        for (int i = 0; i < n2; ++i) {
            int n4 = n + i * n3;
            Record record2 = this.poolFormat_.getNewRecord(byArray2, n4);
            if (Trace.isTraceOn()) {
                Trace.log(1, "Parsed pool at offset " + n4 + ": " + record2.toString());
            }
            String string = ((String)record2.getField("poolName")).trim();
            Integer n5 = (Integer)record2.getField("poolIdentifier");
            if (this.poolIdentifier_ != null) {
                if (!this.poolIdentifier_.equals(n5)) continue;
                if (Trace.isTraceOn()) {
                    Trace.log(1, "Found matching system pool '" + this.poolName_ + "'");
                }
                this.poolRecord_ = record2;
                return;
            }
            if (this.indicatedSharedPool_) {
                if (!string.equals(this.poolName_)) continue;
                if (Trace.isTraceOn()) {
                    Trace.log(1, "Found matching system pool '" + this.poolName_ + "'");
                }
                this.poolRecord_ = record2;
                if (this.poolIdentifier_ == null) {
                    this.poolIdentifier_ = n5;
                }
                return;
            }
            String string2 = ((String)record2.getField("subsystemName")).trim();
            String string3 = ((String)record2.getField("subsystemLibraryName")).trim();
            if (!string2.equalsIgnoreCase(this.subsystemName_) || !string3.equalsIgnoreCase(this.subsystemLibrary_) || !string.equals(this.poolName_)) continue;
            this.poolRecord_ = record2;
            if (this.poolIdentifier_ == null) {
                this.poolIdentifier_ = n5;
            }
            return;
        }
        Trace.log(2, "System pool '" + this.poolName_ + "' not found.");
        throw new ObjectDoesNotExistException(this.poolName_, 2);
    }

    private boolean resizeFormat(Record record) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, UnsupportedEncodingException {
        int n;
        int n2;
        int n3;
        int n4 = (Integer)record.getField("numberOfBytesAvailable");
        int n5 = (Integer)record.getField("numberOfBytesReturned");
        if (Trace.isTraceOn()) {
            Trace.log(1, "Size check of System Status format: " + n4 + ", " + n5);
            n3 = (Integer)record.getField("numberOfPools");
            n2 = (Integer)record.getField("offsetToPoolInformation");
            n = (Integer)record.getField("lengthOfPoolInformationEntry");
            Trace.log(1, "  Old pool information: " + n3 + ", " + n2 + ", " + n + ", " + record.getRecordLength());
        }
        if (n4 > n5) {
            n3 = (Integer)record.getField("numberOfPools");
            n2 = (Integer)record.getField("offsetToPoolInformation");
            n = (Integer)record.getField("lengthOfPoolInformationEntry");
            int n6 = this.systemStatusFormat_.getNewRecord().getRecordLength();
            int n7 = n3 * n + (n2 - n6);
            this.systemStatusFormat_.addFieldDescription(new HexFieldDescription(new AS400ByteArray(n7), "poolInformation"));
            if (Trace.isTraceOn()) {
                Trace.log(1, "Resizing System Status format to hold more system pool information.");
                Trace.log(1, "  New pool information: " + n6 + ", " + n7 + ", " + this.systemStatusFormat_.getNewRecord().getRecordLength());
            }
            return true;
        }
        return false;
    }

    private void set(String string, Object object) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, PropertyVetoException, UnsupportedEncodingException {
        Object var3_3 = null;
        if ((this.vetos_ != null || this.changes_ != null) && this.changesTable_ != null) {
            var3_3 = this.changesTable_.get(string);
        }
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange(string, var3_3, object);
        }
        if (this.changesTable_ == null) {
            this.changesTable_ = new Hashtable(11);
        }
        this.changesTable_.put(string, object);
        if (this.changes_ != null) {
            this.changes_.firePropertyChange(string, var3_3, object);
        }
        if (!this.cacheChanges_) {
            this.commitCache();
        }
    }

    public synchronized void setCaching(boolean bl) {
        this.cacheChanges_ = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFaults(float f, float f2, float f3) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, PropertyVetoException, UnsupportedEncodingException {
        if (!this.indicatedSharedPool_) {
            SystemPool.throwUnsupported();
        }
        if (!this.cacheChanges_) {
            SystemPool systemPool = this;
            synchronized (systemPool) {
                this.cacheChanges_ = true;
                this.setMinimumFaults(f);
                this.setPerThreadFaults(f2);
                this.setMaximumFaults(f3);
                this.commitCache();
                this.cacheChanges_ = false;
            }
        } else {
            this.setMinimumFaults(f);
            this.setPerThreadFaults(f2);
            this.setMaximumFaults(f3);
        }
    }

    public void setMaximumFaults(float f) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, PropertyVetoException, UnsupportedEncodingException {
        if (!this.indicatedSharedPool_) {
            SystemPool.throwUnsupported();
        }
        this.set("maximumFaults", new Float(f));
    }

    public void setMaximumPoolSize(float f) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, PropertyVetoException, UnsupportedEncodingException {
        if (!this.indicatedSharedPool_) {
            SystemPool.throwUnsupported();
        }
        this.set("maximumPoolSize", new Float(f));
    }

    public void setMessageLogging(boolean bl) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, PropertyVetoException, UnsupportedEncodingException {
        this.set("messageLogging", bl ? "Y" : "N");
    }

    public void setMinimumFaults(float f) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, PropertyVetoException, UnsupportedEncodingException {
        if (!this.indicatedSharedPool_) {
            SystemPool.throwUnsupported();
        }
        this.set("minimumFaults", new Float(f));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMinAndMaxPoolSize(float f, float f2) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, PropertyVetoException, UnsupportedEncodingException {
        if (!this.indicatedSharedPool_) {
            SystemPool.throwUnsupported();
        }
        if (!this.cacheChanges_) {
            SystemPool systemPool = this;
            synchronized (systemPool) {
                this.cacheChanges_ = true;
                this.setMinimumPoolSize(f);
                this.setMaximumPoolSize(f2);
                this.commitCache();
                this.cacheChanges_ = false;
            }
        } else {
            this.setMinimumPoolSize(f);
            this.setMaximumPoolSize(f2);
        }
    }

    public void setMinimumPoolSize(float f) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, PropertyVetoException, UnsupportedEncodingException {
        if (!this.indicatedSharedPool_) {
            SystemPool.throwUnsupported();
        }
        this.set("minimumPoolSize", new Float(f));
    }

    public void setPagingOption(String string) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, PropertyVetoException, UnsupportedEncodingException {
        this.set("pagingOption", string);
    }

    public void setPerThreadFaults(float f) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, PropertyVetoException, UnsupportedEncodingException {
        if (!this.indicatedSharedPool_) {
            SystemPool.throwUnsupported();
        }
        this.set("perThreadFaults", new Float(f));
    }

    public void setPoolActivityLevel(int n) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, PropertyVetoException, UnsupportedEncodingException {
        this.setActivityLevel(n);
    }

    public void setActivityLevel(int n) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, PropertyVetoException, UnsupportedEncodingException {
        this.set("activityLevel", new Integer(n));
    }

    public void setPoolName(String string) throws PropertyVetoException {
        this.setName(string);
    }

    public void setName(String string) throws PropertyVetoException {
        if (string == null) {
            throw new NullPointerException("poolName");
        }
        if (this.connected_) {
            throw new ExtendedIllegalStateException("poolName", 5);
        }
        String string2 = this.poolName_;
        String string3 = string.trim();
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("poolName", string2, string3);
        }
        this.poolName_ = string;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("poolName", string2, string3);
        }
    }

    public void setPoolSize(int n) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, PropertyVetoException, UnsupportedEncodingException {
        this.setSize(n);
    }

    public void setSize(int n) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, PropertyVetoException, UnsupportedEncodingException {
        this.set("poolSize", new Integer(n));
    }

    public void setPriority(int n) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, PropertyVetoException, UnsupportedEncodingException {
        if (!this.indicatedSharedPool_) {
            SystemPool.throwUnsupported();
        }
        this.set("priority", new Integer(n));
    }

    public void setSystem(AS400 aS400) throws PropertyVetoException {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        if (this.connected_) {
            throw new ExtendedIllegalStateException("system", 5);
        }
        AS400 aS4002 = this.system_;
        AS400 aS4003 = aS400;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("system", aS4002, aS4003);
        }
        this.system_ = aS400;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("system", aS4002, aS4003);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        if (this.poolName_ != null || this.subsystemName_ != null || this.poolIdentifier_ != null) {
            if (this.subsystemName_ != null) {
                stringBuffer.append("[" + this.subsystemLibrary_ + "/" + this.subsystemName_ + "/" + this.poolSequenceNumber_ + "]");
            } else if (this.poolName_ != null) {
                stringBuffer.append("[" + this.poolName_ + "]");
            } else if (this.poolIdentifier_ != null) {
                stringBuffer.append("[poolID=" + this.poolIdentifier_.toString() + "]");
            }
        }
        return stringBuffer.toString();
    }

    private static final void throwUnsupported() {
        Trace.log(2, "Method not supported for subsystem (non-shared) pools.");
        throw new UnsupportedOperationException();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

