/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.data;

import com.ibm.as400.data.PcmlDocRoot;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

abstract class PcmlNode
implements Serializable,
Cloneable {
    static final long serialVersionUID = -2955209136470053178L;
    private PcmlNode parent = null;
    private PcmlNode prevSibling = null;
    private PcmlNode nextSibling = null;
    private PcmlNode firstChild = null;
    private PcmlNode lastChild = null;
    private int nbrChildren = 0;

    PcmlNode() {
    }

    public Object clone() {
        PcmlNode pcmlNode = null;
        Object var2_2 = null;
        Object var3_3 = null;
        try {
            pcmlNode = (PcmlNode)super.clone();
            pcmlNode.parent = null;
            pcmlNode.firstChild = null;
            pcmlNode.lastChild = null;
            pcmlNode.prevSibling = null;
            pcmlNode.nextSibling = null;
            pcmlNode.nbrChildren = 0;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return pcmlNode;
    }

    void readObjectPostprocessing() {
        if (this.getNbrChildren() == 0) {
            return;
        }
        Enumeration enumeration = this.getChildren();
        while (enumeration.hasMoreElements()) {
            PcmlNode pcmlNode = (PcmlNode)enumeration.nextElement();
            pcmlNode.readObjectPostprocessing();
        }
    }

    public abstract String getName();

    public abstract String getQualifiedName();

    protected final PcmlNode getParent() {
        return this.parent;
    }

    private final void setParent(PcmlNode pcmlNode) {
        this.parent = pcmlNode;
    }

    protected final PcmlNode getNextSibling() {
        return this.nextSibling;
    }

    private final void setNextSibling(PcmlNode pcmlNode) {
        this.nextSibling = pcmlNode;
    }

    protected final PcmlNode getPrevSibling() {
        return this.prevSibling;
    }

    private final void setPrevSibling(PcmlNode pcmlNode) {
        this.prevSibling = pcmlNode;
    }

    protected Enumeration getChildren() {
        Vector<PcmlNode> vector = new Vector<PcmlNode>(this.nbrChildren);
        for (PcmlNode pcmlNode = this.firstChild; pcmlNode != null; pcmlNode = pcmlNode.getNextSibling()) {
            vector.addElement(pcmlNode);
        }
        return vector.elements();
    }

    protected final int getNbrChildren() {
        return this.nbrChildren;
    }

    protected final int getChildNbr() {
        int n = 0;
        PcmlNode pcmlNode = this;
        while (pcmlNode.getPrevSibling() != null) {
            ++n;
            pcmlNode = pcmlNode.getPrevSibling();
        }
        return n;
    }

    protected final boolean hasChildren() {
        return this.nbrChildren > 0;
    }

    protected void addChild(PcmlNode pcmlNode) {
        if (!this.hasChildren()) {
            this.firstChild = pcmlNode;
        } else {
            this.lastChild.setNextSibling(pcmlNode);
            pcmlNode.setPrevSibling(this.lastChild);
        }
        this.lastChild = pcmlNode;
        pcmlNode.setParent(this);
        ++this.nbrChildren;
    }

    protected PcmlDocRoot getRootNode() {
        PcmlNode pcmlNode = this;
        PcmlNode pcmlNode2 = this.parent;
        while (pcmlNode2 != null) {
            pcmlNode = pcmlNode2;
            pcmlNode2 = pcmlNode.getParent();
        }
        if (pcmlNode instanceof PcmlDocRoot) {
            return (PcmlDocRoot)pcmlNode;
        }
        return null;
    }

    protected void printTree(PcmlNode pcmlNode, int n) {
        for (int i = 0; i < n; ++i) {
            System.out.print("  ");
        }
        System.out.println(pcmlNode.toString());
        Enumeration enumeration = pcmlNode.getChildren();
        if (enumeration == null) {
            return;
        }
        while (enumeration.hasMoreElements()) {
            PcmlNode pcmlNode2 = (PcmlNode)enumeration.nextElement();
            this.printTree(pcmlNode2, n + 1);
        }
    }
}

