/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.ActionCompletedListener;
import com.ibm.as400.vaccess.ActionCompletedEventSupport;
import com.ibm.as400.vaccess.ErrorEventSupport;
import com.ibm.as400.vaccess.ErrorListener;
import com.ibm.as400.vaccess.PropertyChangeSupport;
import com.ibm.as400.vaccess.SQLConnection;
import com.ibm.as400.vaccess.VetoableChangeSupport;
import com.ibm.as400.vaccess.WorkingEventSupport;
import com.ibm.as400.vaccess.WorkingListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class SQLStatementDocument
extends PlainDocument
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private transient PropertyChangeSupport changeListeners_ = new PropertyChangeSupport(this);
    private transient VetoableChangeSupport vetoListeners_ = new VetoableChangeSupport(this);
    private transient ActionCompletedEventSupport actionListeners_ = new ActionCompletedEventSupport(this);
    private transient ErrorEventSupport errorListeners_ = new ErrorEventSupport(this);
    private transient WorkingEventSupport workingListeners_ = new WorkingEventSupport(this);
    private SQLConnection connection_ = null;
    private transient SQLWarning warnings_ = null;
    private transient Statement statement_ = null;
    private transient String sql_ = "";

    public SQLStatementDocument() {
    }

    public SQLStatementDocument(SQLConnection sQLConnection, String string) {
        if (sQLConnection == null) {
            throw new NullPointerException("connection");
        }
        if (string == null) {
            throw new NullPointerException("text");
        }
        try {
            this.insertString(0, string, null);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        this.connection_ = sQLConnection;
    }

    public void addActionCompletedListener(ActionCompletedListener actionCompletedListener) {
        this.actionListeners_.addActionCompletedListener(actionCompletedListener);
    }

    public void addErrorListener(ErrorListener errorListener) {
        this.errorListeners_.addErrorListener(errorListener);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeListeners_.addPropertyChangeListener(propertyChangeListener);
    }

    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.vetoListeners_.addVetoableChangeListener(vetoableChangeListener);
    }

    public void addWorkingListener(WorkingListener workingListener) {
        this.workingListeners_.addWorkingListener(workingListener);
    }

    public void execute() {
        if (this.connection_ == null) {
            IllegalStateException illegalStateException = new IllegalStateException("connection");
            this.errorListeners_.fireError(illegalStateException);
            return;
        }
        this.workingListeners_.fireStartWorking();
        if (this.statement_ == null) {
            Connection connection;
            try {
                connection = this.connection_.getConnection();
                this.statement_ = connection.createStatement();
            }
            catch (SQLException sQLException) {
                this.errorListeners_.fireError(sQLException);
                return;
            }
            try {
                this.warnings_ = connection.getWarnings();
            }
            catch (SQLException sQLException) {
                this.errorListeners_.fireError(sQLException);
            }
        } else {
            this.warnings_ = null;
            try {
                this.statement_.clearWarnings();
            }
            catch (SQLException sQLException) {
                this.errorListeners_.fireError(sQLException);
            }
        }
        try {
            this.sql_ = this.getText(0, this.getLength());
            this.statement_.execute(this.sql_);
        }
        catch (BadLocationException badLocationException) {
            this.errorListeners_.fireError(badLocationException);
        }
        catch (SQLException sQLException) {
            this.errorListeners_.fireError(sQLException);
        }
        this.actionListeners_.fireActionCompleted();
        this.workingListeners_.fireStopWorking();
    }

    public SQLConnection getConnection() {
        return this.connection_;
    }

    public void getMoreResults() {
        if (this.statement_ != null) {
            this.workingListeners_.fireStartWorking();
            try {
                this.statement_.getMoreResults();
            }
            catch (SQLException sQLException) {
                this.errorListeners_.fireError(sQLException);
            }
            this.workingListeners_.fireStopWorking();
        }
    }

    public ResultSet getResultSet() {
        if (this.statement_ == null) {
            return null;
        }
        this.workingListeners_.fireStartWorking();
        ResultSet resultSet = null;
        try {
            resultSet = this.statement_.getResultSet();
        }
        catch (SQLException sQLException) {
            this.errorListeners_.fireError(sQLException);
        }
        this.workingListeners_.fireStopWorking();
        return resultSet;
    }

    public String getSQLStatement() {
        return this.sql_;
    }

    public int getUpdateCount() {
        if (this.statement_ == null) {
            return -1;
        }
        try {
            return this.statement_.getUpdateCount();
        }
        catch (SQLException sQLException) {
            this.errorListeners_.fireError(sQLException);
            return 0;
        }
    }

    public SQLWarning getWarnings() {
        if (this.statement_ == null) {
            return null;
        }
        SQLWarning sQLWarning = null;
        try {
            sQLWarning = this.statement_.getWarnings();
        }
        catch (SQLException sQLException) {
            this.errorListeners_.fireError(sQLException);
        }
        if (this.warnings_ != null) {
            SQLWarning sQLWarning2;
            if (sQLWarning == null) {
                return this.warnings_;
            }
            SQLWarning sQLWarning3 = this.warnings_;
            while ((sQLWarning2 = sQLWarning3.getNextWarning()) != null) {
                sQLWarning3 = sQLWarning2;
            }
            sQLWarning3.setNextWarning(sQLWarning);
            return this.warnings_;
        }
        return sQLWarning;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.changeListeners_ = new PropertyChangeSupport(this);
        this.vetoListeners_ = new VetoableChangeSupport(this);
        this.actionListeners_ = new ActionCompletedEventSupport(this);
        this.errorListeners_ = new ErrorEventSupport(this);
        this.workingListeners_ = new WorkingEventSupport(this);
        this.warnings_ = null;
        this.statement_ = null;
        this.sql_ = "";
    }

    public void removeActionCompletedListener(ActionCompletedListener actionCompletedListener) {
        this.actionListeners_.removeActionCompletedListener(actionCompletedListener);
    }

    public void removeErrorListener(ErrorListener errorListener) {
        this.errorListeners_.removeErrorListener(errorListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeListeners_.removePropertyChangeListener(propertyChangeListener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.vetoListeners_.removeVetoableChangeListener(vetoableChangeListener);
    }

    public void removeWorkingListener(WorkingListener workingListener) {
        this.workingListeners_.removeWorkingListener(workingListener);
    }

    public void setConnection(SQLConnection sQLConnection) throws PropertyVetoException {
        if (sQLConnection == null) {
            throw new NullPointerException("connection");
        }
        this.vetoListeners_.fireVetoableChange("connection", this.connection_, sQLConnection);
        SQLConnection sQLConnection2 = this.connection_;
        this.connection_ = sQLConnection;
        if (sQLConnection2 != sQLConnection) {
            if (this.statement_ != null) {
                try {
                    this.statement_.close();
                }
                catch (SQLException sQLException) {
                    this.errorListeners_.fireError(sQLException);
                }
            }
            this.statement_ = null;
            this.warnings_ = null;
        }
        this.changeListeners_.firePropertyChange("connection", sQLConnection2, this.connection_);
    }
}

