/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jt400;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400ConnectionPool;
import com.ibm.as400.access.ConnectionPoolException;
import java.beans.PropertyVetoException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.jt400.Jt400Type;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.spi.UriPath;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriParams
public class Jt400Configuration {
    private static final Logger LOG = LoggerFactory.getLogger(Jt400Configuration.class);
    private static final int DEFAULT_SYSTEM_CCSID = -1;
    private final AS400ConnectionPool connectionPool;
    @UriPath
    @Metadata(required="true")
    private String userID;
    @UriPath
    @Metadata(required="true")
    private String password;
    @UriPath
    @Metadata(required="true")
    private String systemName;
    @UriPath
    @Metadata(required="true")
    private String objectPath;
    @UriPath
    @Metadata(required="true")
    private Jt400Type type;
    @UriParam
    private int ccsid = -1;
    @UriParam(defaultValue="text")
    private Format format = Format.text;
    @UriParam
    private boolean guiAvailable;
    @UriParam
    private boolean keyed;
    @UriParam
    private String searchKey;
    @UriParam(defaultValue="EQ")
    private SearchType searchType = SearchType.EQ;
    @UriParam
    private Integer[] outputFieldsIdxArray;
    @UriParam
    private Integer[] outputFieldsLengthArray;

    public Jt400Configuration(String endpointUri, AS400ConnectionPool connectionPool) throws URISyntaxException {
        ObjectHelper.notNull((Object)endpointUri, (String)"endpointUri", (Object)this);
        ObjectHelper.notNull((Object)connectionPool, (String)"connectionPool", (Object)this);
        URI uri = new URI(endpointUri);
        String[] credentials = uri.getUserInfo().split(":");
        this.systemName = uri.getHost();
        this.userID = credentials[0];
        this.password = credentials[1];
        this.objectPath = uri.getPath();
        this.connectionPool = connectionPool;
    }

    public Jt400Type getType() {
        return this.type;
    }

    public void setType(Jt400Type type) {
        this.type = type;
    }

    public String getSystemName() {
        return this.systemName;
    }

    public void setSystemName(String systemName) {
        this.systemName = systemName;
    }

    public String getUserID() {
        return this.userID;
    }

    public void setUserID(String userID) {
        this.userID = userID;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getObjectPath() {
        return this.objectPath;
    }

    public void setObjectPath(String objectPath) {
        this.objectPath = objectPath;
    }

    public int getCssid() {
        return this.ccsid;
    }

    public void setCcsid(int ccsid) {
        this.ccsid = ccsid < 0 ? -1 : ccsid;
    }

    public Format getFormat() {
        return this.format;
    }

    public void setFormat(Format format) {
        ObjectHelper.notNull((Object)((Object)format), (String)"format", (Object)this);
        this.format = format;
    }

    public boolean isGuiAvailable() {
        return this.guiAvailable;
    }

    public void setGuiAvailable(boolean guiAvailable) {
        this.guiAvailable = guiAvailable;
    }

    public int getCcsid() {
        return this.ccsid;
    }

    public boolean isKeyed() {
        return this.keyed;
    }

    public void setKeyed(boolean keyed) {
        this.keyed = keyed;
    }

    public String getSearchKey() {
        return this.searchKey;
    }

    public void setSearchKey(String searchKey) {
        this.searchKey = searchKey;
    }

    public SearchType getSearchType() {
        return this.searchType;
    }

    public void setSearchType(SearchType searchType) {
        this.searchType = searchType;
    }

    public Integer[] getOutputFieldsIdxArray() {
        return this.outputFieldsIdxArray;
    }

    public void setOutputFieldsIdxArray(Integer[] outputFieldsIdxArray) {
        this.outputFieldsIdxArray = outputFieldsIdxArray;
    }

    public Integer[] getOutputFieldsLengthArray() {
        return this.outputFieldsLengthArray;
    }

    public void setOutputFieldsLengthArray(Integer[] outputFieldsLengthArray) {
        this.outputFieldsLengthArray = outputFieldsLengthArray;
    }

    public void setOutputFieldsIdx(String outputFieldsIdx) {
        if (outputFieldsIdx != null) {
            String[] outputArray = outputFieldsIdx.split(",");
            this.outputFieldsIdxArray = new Integer[outputArray.length];
            for (int i = 0; i < outputArray.length; ++i) {
                String str = outputArray[i];
                this.outputFieldsIdxArray[i] = Integer.parseInt(str);
            }
        }
    }

    public void setFieldsLength(String fieldsLength) {
        if (fieldsLength != null) {
            String[] outputArray = fieldsLength.split(",");
            this.outputFieldsLengthArray = new Integer[outputArray.length];
            for (int i = 0; i < outputArray.length; ++i) {
                String str = outputArray[i];
                this.outputFieldsLengthArray[i] = Integer.parseInt(str);
            }
        }
    }

    public AS400 getConnection() {
        AS400 system = null;
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Getting an AS400 object for '{}' from {}.", (Object)(this.systemName + '/' + this.userID), (Object)this.connectionPool);
            }
            system = this.connectionPool.getConnection(this.systemName, this.userID, this.password);
            if (this.ccsid != -1) {
                system.setCcsid(this.ccsid);
            }
            try {
                system.setGuiAvailable(this.guiAvailable);
            }
            catch (PropertyVetoException e) {
                LOG.warn("Failed to disable AS/400 prompting in the environment running Camel. This exception will be ignored.", (Throwable)e);
            }
            return system;
        }
        catch (ConnectionPoolException e) {
            throw new RuntimeCamelException(String.format("Unable to obtain an AS/400 connection for system name '%s' and user ID '%s'", this.systemName, this.userID), (Throwable)e);
        }
        catch (PropertyVetoException e) {
            throw new RuntimeCamelException("Unable to set the CSSID to use with " + system, (Throwable)e);
        }
    }

    public void releaseConnection(AS400 connection) {
        ObjectHelper.notNull((Object)connection, (String)"connection", (Object)this);
        this.connectionPool.returnConnectionToPool(connection);
    }

    public static enum Format {
        text,
        binary;

    }

    public static enum SearchType {
        EQ,
        NE,
        LT,
        LE,
        GT,
        GE;

    }
}

