/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.juel;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import javax.el.BeanELResolver;
import javax.el.ELContext;
import javax.el.PropertyNotFoundException;

public class BeanAndMethodELResolver
extends BeanELResolver {
    public BeanAndMethodELResolver() {
        super(false);
    }

    @Override
    public Object getValue(ELContext elContext, Object base, Object property) {
        try {
            return property instanceof Method ? property : super.getValue(elContext, base, property);
        }
        catch (PropertyNotFoundException e) {
            Method method = this.findMethod(elContext, base, property);
            if (method != null) {
                elContext.setPropertyResolved(true);
                return method;
            }
            throw e;
        }
    }

    protected Method findMethod(ELContext elContext, Object base, Object property) {
        if (base != null) {
            Method[] methods = base.getClass().getMethods();
            ArrayList<Method> matching = new ArrayList<Method>();
            for (Method method : methods) {
                if (!method.getName().equals(property.toString()) || !Modifier.isPublic(method.getModifiers())) continue;
                matching.add(method);
            }
            int size = matching.size();
            if (size > 0) {
                if (size > 1) {
                    for (Method method : matching) {
                        Class<?>[] paramTypes = method.getParameterTypes();
                        if (paramTypes.length != 1) continue;
                        return method;
                    }
                }
                return (Method)matching.get(0);
            }
        }
        return null;
    }
}

