/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.jxpath;

import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.ExpressionEvaluationException;
import org.apache.camel.support.ExpressionSupport;
import org.apache.commons.jxpath.CompiledExpression;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.JXPathException;

public class JXPathExpression
extends ExpressionSupport {
    private final String expression;
    private CompiledExpression compiledExpression;
    private final Class<?> type;
    private boolean lenient;

    public JXPathExpression(String expression, Class<?> type) {
        this(expression, type, false);
    }

    public JXPathExpression(String expression, Class<?> type, boolean lenient) {
        this.expression = expression;
        this.type = type;
        this.lenient = lenient;
    }

    public boolean isLenient() {
        return this.lenient;
    }

    public void setLenient(boolean lenient) {
        this.lenient = lenient;
    }

    public <T> T evaluate(Exchange exchange, Class<T> tClass) {
        try {
            JXPathContext context = JXPathContext.newContext(exchange);
            context.setLenient(this.lenient);
            Object result = this.getJXPathExpression().getValue(context, this.type);
            this.assertResultType(exchange, result);
            return (T)exchange.getContext().getTypeConverter().convertTo(tClass, result);
        }
        catch (JXPathException e) {
            throw new ExpressionEvaluationException((Expression)this, exchange, (Throwable)e);
        }
    }

    private void assertResultType(Exchange exchange, Object result) {
        if (result != null && !this.type.isAssignableFrom(result.getClass())) {
            throw new JXPathException("JXPath result type is " + result.getClass() + " instead of required type " + this.type);
        }
    }

    protected String assertionFailureMessage(Exchange exchange) {
        return this.expression;
    }

    private synchronized CompiledExpression getJXPathExpression() {
        if (this.compiledExpression == null) {
            this.compiledExpression = JXPathContext.compile(this.expression);
        }
        return this.compiledExpression;
    }

    public String toString() {
        return "JXpath[" + this.expression + "]";
    }
}

