/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kafka.consumer.errorhandler;

import java.util.Set;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SeekUtil {
    private static final Logger LOG = LoggerFactory.getLogger(SeekUtil.class);

    private SeekUtil() {
    }

    public static void seekToNextOffset(Consumer<?, ?> consumer, long partitionLastOffset) {
        block5: {
            Set<TopicPartition> tps;
            boolean logged;
            block4: {
                logged = false;
                tps = consumer.assignment();
                if (tps == null || partitionLastOffset == -1L) break block4;
                long next = partitionLastOffset + 1L;
                for (TopicPartition tp : tps) {
                    if (LOG.isInfoEnabled()) {
                        LOG.info("Consumer seeking to next offset {} to continue polling next message from topic {} on partition {}", new Object[]{next, tp.topic(), tp.partition()});
                    }
                    consumer.seek(tp, next);
                }
                break block5;
            }
            if (tps == null) break block5;
            for (TopicPartition tp : tps) {
                long next = consumer.position(tp) + 1L;
                if (!logged) {
                    LOG.info("Consumer seeking to next offset {} to continue polling next message from topic {} on partition {}", new Object[]{next, tp.topic(), tp.partition()});
                    logged = true;
                }
                consumer.seek(tp, next);
            }
        }
    }
}

