/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.health;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Stream;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.DeferredContextBinding;
import org.apache.camel.NonManagedService;
import org.apache.camel.StaticService;
import org.apache.camel.health.WritableHealthCheckRepository;
import org.apache.camel.spi.annotations.HealthCheck;
import org.apache.camel.support.service.ServiceSupport;

@HealthCheck(value="components-repository")
@DeferredContextBinding
public class ComponentsHealthCheckRepository
extends ServiceSupport
implements CamelContextAware,
WritableHealthCheckRepository,
StaticService,
NonManagedService {
    public static final String REPOSITORY_ID = "components";
    public static final String REPOSITORY_NAME = "components-repository";
    private final List<org.apache.camel.health.HealthCheck> checks = new CopyOnWriteArrayList<org.apache.camel.health.HealthCheck>();
    private volatile CamelContext context;
    private boolean enabled = true;

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.context = camelContext;
    }

    @Override
    public String getId() {
        return REPOSITORY_ID;
    }

    @Override
    public CamelContext getCamelContext() {
        return this.context;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public Stream<org.apache.camel.health.HealthCheck> stream() {
        return this.context != null && this.enabled ? this.checks.stream() : Stream.empty();
    }

    @Override
    public void addHealthCheck(org.apache.camel.health.HealthCheck healthCheck) {
        CamelContextAware.trySetCamelContext(healthCheck, this.getCamelContext());
        this.checks.add(healthCheck);
    }

    @Override
    public void removeHealthCheck(org.apache.camel.health.HealthCheck healthCheck) {
        this.checks.remove(healthCheck);
    }
}

