/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.health;

import java.util.Map;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.health.HealthCheckResultBuilder;
import org.apache.camel.impl.health.AbstractHealthCheck;
import org.apache.camel.spi.annotations.HealthCheck;

@HealthCheck(value="context-check")
public final class ContextHealthCheck
extends AbstractHealthCheck {
    public ContextHealthCheck() {
        super("camel", "context");
    }

    @Override
    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    @Override
    public boolean isLiveness() {
        return false;
    }

    @Override
    protected void doCall(HealthCheckResultBuilder builder, Map<String, Object> options) {
        builder.unknown();
        if (this.getCamelContext() != null) {
            builder.detail("context.name", this.getCamelContext().getName());
            builder.detail("context.version", this.getCamelContext().getVersion());
            builder.detail("context.status", this.getCamelContext().getStatus().name());
            builder.detail("context.phase", this.getCamelContext().adapt(ExtendedCamelContext.class).getStatusPhase());
            if (this.getCamelContext().getStatus().isStarted()) {
                builder.up();
            } else {
                builder.down();
            }
        }
    }
}

