/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kafka.consumer.support.resume;

import org.apache.camel.Exchange;
import org.apache.camel.resume.Offset;
import org.apache.camel.resume.OffsetKey;
import org.apache.camel.resume.Resumable;
import org.apache.camel.support.resume.OffsetKeys;
import org.apache.camel.support.resume.Offsets;

public final class KafkaResumable
implements Resumable {
    private final String addressable;
    private final Long offset;

    private KafkaResumable(String addressable, Long offset) {
        this.addressable = addressable;
        this.offset = offset;
    }

    @Override
    public OffsetKey<?> getOffsetKey() {
        return OffsetKeys.unmodifiableOf(this.addressable);
    }

    @Override
    public Offset<?> getLastOffset() {
        return Offsets.of(this.offset);
    }

    public static KafkaResumable of(Exchange exchange) {
        String topic = exchange.getMessage().getHeader("kafka.TOPIC", String.class);
        Integer partition = exchange.getMessage().getHeader("kafka.PARTITION", Integer.class);
        Long offset = exchange.getMessage().getHeader("kafka.OFFSET", Long.class);
        String topicPartition = topic + "/" + partition;
        return new KafkaResumable(topicPartition, offset);
    }
}

