/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kafka.serde;

import java.nio.ByteBuffer;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.component.kafka.serde.KafkaHeaderSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultKafkaHeaderSerializer
implements KafkaHeaderSerializer,
CamelContextAware {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultKafkaHeaderSerializer.class);
    private CamelContext camelContext;

    @Override
    public byte[] serialize(String key, Object value) {
        byte[] converted;
        if (value instanceof String) {
            return ((String)value).getBytes();
        }
        if (value instanceof Long) {
            ByteBuffer buffer = ByteBuffer.allocate(8);
            buffer.putLong((Long)value);
            return buffer.array();
        }
        if (value instanceof Integer) {
            ByteBuffer buffer = ByteBuffer.allocate(4);
            buffer.putInt((Integer)value);
            return buffer.array();
        }
        if (value instanceof Double) {
            ByteBuffer buffer = ByteBuffer.allocate(8);
            buffer.putDouble((Double)value);
            return buffer.array();
        }
        if (value instanceof Boolean) {
            return value.toString().getBytes();
        }
        if (value instanceof byte[]) {
            return (byte[])value;
        }
        if (this.camelContext != null && (converted = this.camelContext.getTypeConverter().tryConvertTo(byte[].class, value)) != null) {
            return converted;
        }
        LOG.debug("Cannot propagate header value of type[{}], skipping... Supported types: String, Integer, Long, Double, byte[].", value != null ? value.getClass() : "null");
        return null;
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }
}

