/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.health;

import java.util.Map;
import org.apache.camel.Consumer;
import org.apache.camel.Route;
import org.apache.camel.health.HealthCheck;
import org.apache.camel.health.HealthCheckAware;
import org.apache.camel.health.HealthCheckResultBuilder;
import org.apache.camel.impl.health.RouteHealthCheck;
import org.apache.camel.spi.HttpResponseAware;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumerHealthCheck
extends RouteHealthCheck {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConsumerHealthCheck.class);
    private final Consumer consumer;
    private final String sanitizedUri;

    public ConsumerHealthCheck(Route route, String id) {
        super(route, id);
        this.consumer = route.getConsumer();
        this.sanitizedUri = URISupport.sanitizeUri(this.consumer.getEndpoint().getEndpointUri());
    }

    @Override
    protected void doCallCheck(HealthCheckResultBuilder builder, Map<String, Object> options) {
        HealthCheck hc;
        boolean up;
        boolean bl = up = builder.state().compareTo(HealthCheck.State.UP) == 0;
        if (up && this.consumer instanceof HealthCheckAware && (hc = ((HealthCheckAware)((Object)this.consumer)).getHealthCheck()) != null) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Calling HealthCheck on consumer route: {}", (Object)this.route.getRouteId());
            }
            HealthCheck.Result result = hc.call(options);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("HealthCheck consumer route: {} -> {}", (Object)this.route.getRouteId(), (Object)result.getState());
            }
            builder.detail("endpoint.uri", this.sanitizedUri);
            builder.detail("failure.endpoint.uri", this.sanitizedUri);
            builder.state(result.getState());
            if (result.getMessage().isPresent()) {
                builder.message(result.getMessage().get());
            }
            if (result.getError().isPresent()) {
                int code;
                Throwable cause = result.getError().get();
                builder.error(cause);
                if (cause instanceof HttpResponseAware && (code = ((HttpResponseAware)((Object)cause)).getHttpResponseCode()) > 0) {
                    builder.detail("http.response.code", code);
                }
            }
            builder.details(result.getDetails());
        }
    }
}

